<?php

// QuickTalk 1.7 build:20080526

// --------
// HTML start
// --------

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="en" lang="en">
<head>
<title>QuickTalk installation checker</title>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1"/>
<style type="text/css">
body { color:#000000; background-color:#FFFFFF; margin-top:6px; }
form {  display:inline; }
p,select,input,textarea,td,th,a,h1 { font-family:Verdana, Arial, sans-serif; text-decoration:none; font-size:9pt; }
h1 { margin:10px 0px 10px 0px; font-size:12pt; }
a  { color:#0000FF; }
a:hover { text-decoration:underline; }
.ok { color:#009900; }
.nok { color:#990000; }
</style>
</head>';

echo '<body>

<!-- PAGE CONTROL -->
<div class="div_page">
<table class="tab_page" width="550" cellspacing="0" style="margin:5px">
<tr class="tr_page">
<td class="td_page">
<!-- PAGE CONTROL -->

<!-- HEADER BANNER -->
<div style="background:url(admin/bg_btop_c.gif) repeat-x;">
<img src="admin/qtg_logo.gif" width="175" height="50" style="border-width:0" alt="QuickTalk" title="QuickTalk"/>
</div>
<!-- END HEADER BANNER -->

<!-- BODY MAIN -->
<table width="100%" cellspacing="0" style="border:1px solid #156AC2;">
<tr>
<td style="padding:5px 10px 5px 10px;">
<!-- BODY MAIN -->
';

// --------
// 1 CONFIG
// --------

echo '<h1>Checking your configuration</h1>';

$qtg_error = '';

// 1 file exist

  echo 'Checking installed files... ';

  if ( !file_exists('bin/config.php') ) $qtg_error .= 'File <b>config.php</b> is not in the <b>bin</b> directory. Communication with database is impossible.<br/>';
  if ( !file_exists('bin/qt_lib_db.php') ) $qtg_error .= 'File <b>qt_lib_db.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qt_lib_txt.php') ) $qtg_error .= 'File <b>qt_lib_txt.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qtg_init.php') ) $qtg_error .= 'File <b>qtg_init.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !empty($qtg_error) ) die($qtg_error);

  echo '<span class="ok">Main files found.</span><br/>';

// 2 config is correct

  echo 'Checking config.php... ';

  include('bin/config.php');

  if ( !isset($qtg_dbsystem) ) $qtg_error .= 'Variable <b>$qtg_dbsystem</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_host) )     $qtg_error .= 'Variable <b>$qtg_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_database) ) $qtg_error .= 'Variable <b>$qtg_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_prefix) )   $qtg_error .= 'Variable <b>$qtg_prefix</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_user) )     $qtg_error .= 'Variable <b>$qtg_user</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_pwd) )      $qtg_error .= 'Variable <b>$qtg_pwd</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_port) )     $qtg_error .= 'Variable <b>$qtg_port</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qtg_dsn) )      $qtg_error .= 'Variable <b>$qtg_dsn</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !empty($qtg_error) ) die($qtg_error);
  
  // check db type
  if ( !in_array($qtg_dbsystem,array('mysql','mssql','pg','ibase','sqlite','db2','access','ifx','oci')) ) die('Unknown db type '.$qtg_dbsystem);
  
  // check other values
  if ( empty($qtg_host) )      $qtg_error .= 'Variable <b>$qtg_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( empty($qtg_database) )  $qtg_error .= 'Variable <b>$qtg_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !empty($qtg_error) ) die($qtg_error);

  echo '<span class="ok">Done.</span><br/>';

// 3 test db connection

  echo 'Connecting to database... ';

  include('bin/qt_lib_db.php');
  include('bin/qt_lib_txt.php');

  $oDB = new cDB($qtg_dbsystem,$qtg_host,$qtg_database,$qtg_user,$qtg_pwd,$qtg_port,$qtg_dsn);
  if ( !empty($oDB->error) ) die ('<p style="color:red">Connection with database failed.<br/>Check that server is up and running.<br/>Check that the settings in the file <b>bin/config.php</b> are correct for your database.</p>');

  echo '<span class="ok">Done.</span><br/><br/>';

echo '<span class="ok">Configuration tests completed successfully.</span>';

// --------
// 2 DATABASE
// --------

$qtg_error = '';

echo '<h1>Checking your database</h1>';

// 1 message table

  echo 'Checking message table... ';
  
  $oDB->Query('SELECT count(id) as countid FROM '.$qtg_prefix.'qtgmessage WHERE id>=0');
  if ( !empty($oDB->error) ) die("<br/><font color=red>Problem with table ".$qtg_prefix."qtgmessage</font>");
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo '<span class="ok">Table [',$qtg_prefix,'qtgmessage] exists.</span> ',$intCount,' messages found.<br/>';

  // search version
  $strVersion='unknown';
  $oDB->Query( 'SELECT name FROM '.$qtg_prefix.'qtgmessage WHERE id=-1');
  $row = $oDB->Getrow();
  if ( isset($row['name']) ) { if ( $row['name']=='1.7' ) $strVersion='1.7'; }
  echo 'Database version: ',$strVersion,'.<br/><br/>';


echo '<span class="ok">Database tests completed successfully.</span>';

// --------
// 3 LANGUAGE AND SKIN
// --------

$qtg_error = '';

echo "<h1>Checking language and skin options</h1>";
 
  include('bin/config_display.php');

  if ( empty($qtg_language) ) $qtg_error .= 'Setting <b>language</b> is not defined in the setting table. Application can only work with english.<br/>';  
  if ( !file_exists("language/$qtg_language/qtg_lang_main.php") ) $qtg_error .= "File <b>qtg_lang_main.php</b> is not in the <b>language/$qtg_language</b> directory.<br/>";
  if ( !file_exists("language/$qtg_language/qtg_lang_adm.php") )  $qtg_error .= "File <b>qtg_lang_adm.php</b> is not in the <b>language/$qtg_language</b> directory.<br/>";
  if ( !file_exists("language/$qtg_language/qtg_lang_cntry.php") )  $qtg_error .= "File <b>qtg_lang_cntry.php</b> is not in the <b>language/$qtg_language</b> directory.<br/>";
  if ( !file_exists("language/english/qtg_lang_main.php") ) $qtg_error .= "File <b>qtg_lang_main.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( !file_exists("language/english/qtg_lang_adm.php") )  $qtg_error .= "File <b>qtg_lang_adm.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( !file_exists("language/english/qtg_lang_cntry.php") )  $qtg_error .= "File <b>qtg_lang_cntry.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( empty($qtg_skin) ) $qtg_error .= 'Setting <b>skin</b> is not defined in the setting table. Application will not display correctly.<br/>';  
  if ( !file_exists("skin/$qtg_skin/qtg_main.css") ) $qtg_error .= "File <b>qtg_main.css</b> is not in the <b>skin/xxxx</b> directory.<br/>";
  if ( !file_exists("skin/default/qtg_main.css") ) $qtg_error .= "File <b>qtg_main.css</b> is not in the <b>skin/default</b> directory. Default skin is mandatory.<br/>";  
  if ( !empty($qtg_error) )
  {
     echo '<span class="nok">',$qtg_error,'</span>';
  }
  else
  {
    echo '<span class="ok">Language and skin files tested.</span>';
  }  

// --------
// 4 ADMINISTRATION TIPS
// --------

$qtg_error = '';

echo '<h1>Administration tips</h1>';

  if ( !QTismail($qtg_email) ) $qtg_error .= 'Guestbook contact email not defined (or wrong).<br/>';  
  if ( !QTislogin($qtg_user,2) ) $qtg_error .= 'The admin login ['.$qtg_user.'] is not valid. You will have problem to enter the Administration section from the guestbook.<br/>';  
  if ( !QTislogin($qtg_pwd,2) ) $qtg_error .= 'The password of user ['.$qtg_user.'] is not valid. You will have problem to enter the Administration section from the guestbook.<br/>';  
  if ( !empty($qtg_user_2) )
  {
  if ( !QTislogin($qtg_user_2,2) ) $qtg_error .= 'The admin login ['.$qtg_user_2.'] is not valid. He will have problem to enter the Administration section from the guestbook.<br/>';  
  if ( !QTislogin($qtg_pwd_2,2) ) $qtg_error .= 'The password of user ['.$qtg_user_2.'] is not valid. He will have problem to enter the Administration section from the guestbook.<br/>';  
  }
  if ( !file_exists("language/$qtg_language/qtg_privacy.php") ) $qtg_error .= "File <b>qtg_privacy.php</b> is not in the <b>language/$qtg_language</b> directory. It's recommended to define your privacy rules.<br/>";
  if ( !file_exists("language/english/qtg_privacy.php") ) $qtg_error .= "File <b>qtg_privacy.php</b> is not in the <b>language/english</b> directory. It's recommended to define your privacy rules.<br/>";

  if ( !empty($qtg_error) )
  {
     echo '<span class="nok">',$qtg_error,'</span>';
  }
  else
  {
    echo '<span class="ok">Administration tips completed.</span>';
  }  
  $qtg_error = '';

// --------
// 5 END
// --------

echo '<h1>Result</h1>';
echo 'The checker did not found blocking issues in your configuration.<br/>';

include('bin/config_stop.php');
if ( !$qtg_actif ) echo 'Your board seams well installed, but is currently off-line.<br/>Log as Administrator and go to the Administration panel to turn your board on-line.<br/>';

echo '<br/><br/><a href="qtg_index.php">Go to the guestbook</a>';

// --------
// HTML END
// --------

echo '<!-- END BODY MAIN -->
</td>
</tr>
</table>
<!-- END BODY MAIN -->

<!-- footer line -->

<p style="margin:2px;text-align:right;font-size:8pt">powered by <a href="http://www.qt-cute.org">QT-cute</a></p>

<!-- END PAGE CONTROL -->
</td>
</tr>
</table>
</div>
<!-- END PAGE CONTROL -->

</body>

</html>';

?>
