<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

function AsEmails($strEmails,$strId,$strRender='txt',$bFirst=false,$strSkin='skin/default',$strNojava='Java protected email',$strEmpty='&nbsp;')
{
  if ( !is_string($strEmails) ) return $strEmpty;
  if ( empty($strEmails) ) return $strEmpty;
  // get list of Emails
  if ( strstr($strEmails,' ; ') ) { $arrEmails = explode(' ; ',$strEmails); } else { $arrEmails = array($strEmails);  }
  // get first Email
  $strFirst = $arrEmails[0];
  // only one email
  if ( $bFirst ) $arrEmails = array($strFirst);
  // build expression
  $strReturn = '';
  switch ($strRender)
  {
  case 'txt':
    $strReturn .= '<a id="href'.$strId.'" class="small" href="mailto:'.implode(';',$arrEmails).'">';
    $strReturn .= implode(' ; ',$arrEmails);
    $strReturn .= '</a>';
    break;
  case 'img':
    $strReturn .= '<a id="href'.$strId.'" class="small" href="mailto:'.implode(';',$arrEmails).'">';
    $strReturn .= '<img class="email" id="img'.$strId.'" src="'.$strSkin.'/ico_mail.gif" alt="email" title="'.$strFirst.'"/>';
    $strReturn .= '</a>';
    break;
  case 'txtjava':
    $strReturn .= '<script type="text/javascript">';
    foreach ($arrEmails as $strEmail)
    {
    $arr = explode('@',$strEmail);
    $strReturn .= 'writemailto("'.$arr[0].'","'.$arr[1].'"," ");';
    }
    $strReturn .= '</script><noscript class="small">'.$strNojava.'</noscript>';
    break;
  case 'imgjava':
    $str = implode(';',$arrEmails);
    $str = str_replace('@','-at-',$str);
    $str = str_replace('.','-dot-',$str);
    $strFirst = str_replace('@','-at-',$strFirst);
    $strFirst = str_replace('.','-dot-',$strFirst);
    $strReturn .= '<a id="href'.$strId.'" onmouseover="vmail(\''.$strId.'\');" onmouseout="hmail(\''.$strId.'\');" class="small" href="javamail:'.$str.'">';
    $strReturn .= '<img class="email" id="img'.$strId.'" src="'.$strSkin.'/ico_mail.gif" alt="email" title="'.$strFirst.'"/>';
    $strReturn .= '</a>';
    break;
  }
  return $strReturn;
}

// LangS
//  Returns the plural.
//  Returns the orignial word if $intVal<2, or if plural word is not existing.
//  The variable $strVar can be composed of 2 strings (comma separated)
//  ex: LangS['userrole,A',25] returns $L['Userroles']['A']

// LangS
// Returns the plural.
// - Returns the orignial word if $intVal<2, or if plural word is not existing.
// - If the last argument is true, returns the number + space + the word 
// - The variable $strVar can be composed of 2 strings (comma separated)
// ex: LangS['userrole,A',25] returns $L['Userroles']['A']

function LangS($strVar,$intVar,$L,$bInclude=true)
{
  if ( !strstr($strVar,',') )
  {
    if ( $intVar>1 && isset($L[$strVar.'s']) )
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$strVar.'s']; 
    }
    else
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$strVar];
    }
  }
  else
  {
    $lstVar = explode(',',$strVar);
    if ( $intVar>1 && isset($L[$lstVar[0].'s'][$lstVar[1]]) )
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$lstVar[0].'s'][$lstVar[1]]; 
    }
    else
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$lstVar[0]][$lstVar[1]];
    }
  }
}

function LimitSQL($dbtype,$strState,$strOrder,$intStart=0,$intLength=50,$intCount=50)
{
  $strOrder = trim($strOrder); if ( substr($strOrder,-3,3)!='ASC' && substr($strOrder,-4,4)!='DESC' ) $strOrder .= ' ASC';
  switch ($dbtype)
  {
  case 'mysql':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intStart,$intLength";
    break;
  case 'mssql':
    if ($intStart==0)
    {
      $query = "SELECT TOP $intLength $strState ORDER BY $strOrder";
    }
    elseif ( ($intLength+$intStart)>$intCount )
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $intLast = $intCount-$intStart;
      $query = "SELECT TOP $intLast $strState ORDER BY $strInvor";
      $strOrder = str_replace('t.','',$strOrder); // to support t1,t2
      $strInvor = str_replace('t.','',$strInvor); // to support t1,t2
      $query = "SELECT * FROM ($query) As t1 ORDER BY $strOrder";
    }
    else
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('t.','',$strOrder); // to support t1,t2
      $strInvor = str_replace('t.','',$strInvor); // to support t1,t2
      $query = "SELECT * FROM (SELECT TOP $intLength * FROM ($query) As t1 ORDER BY $strInvor) As t2 ORDER BY $strOrder";
    }
    return $query;
    break;
  case 'pg':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intLength OFFSET $intStart";
    break;
  case 'ibase':
    return "SELECT FIRST $intLength SKIP $intStart $strState ORDER BY $strOrder";
    break;
  case 'sqlite':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intLength OFFSET $intStart";
    break;
  case 'ifx':
    return "SELECT SKIP $intStart FIRST $intLength $strState ORDER BY $strOrder";
    break;
  case 'db2':
    if ($intStart==0)
    {
      return "SELECT $strState ORDER BY $strOrder FETCH FIRST $intLength ROWS ONLY";
    }
    else
    {
      return "SELECT * FROM (SELECT ROW_NUMBER() OVER() AS RN, $strState) AS cols WHERE RN BETWEEN ($intStart+1) AND ($intStart+1+$intLength)";
    }
    break;
  case 'access':
    if ($intStart==0)
    {
      $query = "SELECT TOP $intLength $strState ORDER BY $strOrder";
    }
    elseif ( ($intLength+$intStart)>$intCount )
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $finaltop = $intCount-$intLength;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('t.','',$strOrder); // to support t1,t2
      $strInvor = str_replace('t.','',$strInvor); // to support t1,t2
      $query = "SELECT * FROM (SELECT TOP $finaltop * FROM ($query) As t1 ORDER BY $strInvor) As t2 ORDER BY $strOrder";
    }
    else
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('t.','',$strOrder); // to support t1,t2
      $strInvor = str_replace('t.','',$strInvor); // to support t1,t2
      $query = "SELECT * FROM (SELECT TOP $intLength * FROM ($query) As t1 ORDER BY $strInvor) As t2 ORDER BY $strOrder";
    }
    return $query;
    break;
  case 'oci':
    if ($intStart==0)
    {
      return "SELECT * FROM (SELECT $strState ORDER BY $strOrder) WHERE ROWNUM<=$intLength";
    }
    else
    {
      return "SELECT * FROM (SELECT a.*, rownum RN FROM (SELECT $strState ORDER BY $strOrder) a WHERE rownum<$intStart+1+$intLength) WHERE rn>$intStart";
    }
    break;
  default: die('Unknown db type '.$dbtype);
  }
}

// --------

function MakePager($uri, $count, $intPagesize=50, $currentpage=1, $L)
{
   $arrUri = parse_url($uri);
   $uri = $arrUri['path'];
   $arg = $arrUri['query'];
   $arrArg = explode('&',$arg);
   $arrNew = array();
   foreach ($arrArg as $strValue)
   {
      if ( substr($strValue,0,4)=='page' ) continue;
      $arrNew[]=$strValue;
   }
   $arg = implode('&amp;',$arrNew);
   
   $strPager='';  
   if ( $count>($intPagesize*5) )
   {
      // firstpage
      if ( $currentpage==1 )
      {
        $firstpage = ' &laquo;';
      }
      else
      {
        $firstpage = ' <a href="'.$uri.'?'.$arg.'&amp;page=1" title="'.$L['First'].'">&laquo;</a>';
      }
      // lastpage
      $il = ceil($count/$intPagesize);
      if ( $currentpage==$il )
      {
        $lastpage = ' &raquo;';
      }
      else
      {
        $lastpage = ' <a href="'.$uri.'?'.$arg.'&amp;page='.$il.'" title="'.$L['Last'].': '.$il.'">&raquo;</a>';
      }
      // 3 pages
      if ( $currentpage==1 )
      {
         $thesepages = ' <b>'.$currentpage.'</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+2).'" title="'.$L['Next'].'">'.($currentpage+2).'</a>';
      }
      elseif ( $currentpage==$il )
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-2).'" title="'.$L['Previous'].'">'.($currentpage-2).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>'.$currentpage.'</b> ';
      }
      else
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>'.$currentpage.'</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a>';
      }
      // finish
      $strPager .= $firstpage.$thesepages.$lastpage;
   }
   elseif ($count>$intPagesize)
   {
      for ($i=0; $i<$count; $i+=$intPagesize)
      {
        $page = $i/$intPagesize+1;
        if ( $currentpage==$page )
        {
          $strPager .= ' <b>'.$page.'</b>';
        }
        else
        {
          $strPager .= ' <a href="'.$uri.'?'.$arg.'&amp;page='.$page.'">'.$page.'</a>';
        }
      }
   }
   return $strPager;
}

// --------

function LastPostDelayAcceptable($qtg_max_sec=5)
{
  if ( isset($_SESSION['qtg_beginedit']) ) {
  if ( !empty($_SESSION['qtg_beginedit']) ) {
    if ( $_SESSION['qtg_beginedit']+$qtg_max_sec >= time() ) return FALSE;
  }}
  return TRUE;
}

// --------

function TooMuch($oDB,$qtg_max_day=5)
{
  switch($oDB->type)
  {
  case 'mysql': $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER["REMOTE_ADDR"].'" AND SUBSTRING(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'mssql': $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER["REMOTE_ADDR"].'" AND SUBSTRING(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'pg':    $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER["REMOTE_ADDR"].'" AND SUBSTRING(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'ibase': $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND SUBSTRING(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'sqlite':$oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND SUBSTR(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'db2':   $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND SUBSTR(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'ifx':   $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND SUBSTRING(issuedate,1,8)="'.date('Ymd').'"' ); break;
  case 'access':$oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND LEFT(issuedate,8)="'.date('Ymd').'"' ); break;
  case 'oci':   $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE ip="'.$_SERVER['REMOTE_ADDR'].'" AND SUBSTR(issuedate,1,8)="'.date('Ymd').'"' ); break;
  default: die('Unknown db type '.$oDB->type);
  }
  $row = $oDB->Getrow();
  if ($row['countid']>=$qtg_max_day) Return TRUE;
  return FALSE;
}

// --------

function IQTbbc($oPost,$output='html',$nl='<br/>',$maxlen=0, $beforediv='', $afterdiv='',$arrBbc=array(true,true,true,true,true),$L,$skin='skin/default',$page=0)
{  

  $strMsg = $oPost->message;
  $intMsg = strlen($strMsg);
  $bTruncated=false; 
  
  // STRIP TAGS (if '<' exists)
  if ( strpos($strMsg,'<')!==FALSE ) $strMsg = strip_tags($strMsg);
  
  // DROP SOME UNALLOWED BBC TAGS before using QTbbc (if '[' exists)
  if ( strpos($strMsg,'[')!==FALSE )
  {
    $arrSearch = array ("/\[color\=(.*?)\](.*?)\[\/color\]/",  "/\[size=(.*?)\](.*?)\[\/size\]/", "/\[quote\]/", "/\[quote\=(.*?)\]/", "/\[\/quote\]/", "/\[code\]/", "/\[\/code\]/");
    $arrReplace = array('','','','','','','');
    $strMsg = preg_replace( $arrSearch, $arrReplace, $strMsg );
  }

  // TRUNCATE (if long message)
  if ( is_numeric($maxlen) ) {
  if ( $maxlen>0 ) {
  if ( $intMsg>$maxlen ) {
    // smart-cutting
    if ( SMARTCUT>0 )
    {
      // don't cut if within smartcut tolerance
      if ( $intMsg>$maxlen+SMARTCUT )
      {
        // if some caracters are at the cut-position, cut after
        switch (substr($strMsg,$maxlen,1))
        {
        case ']': $maxlen++; break;
        case '.': $maxlen++; break;
        case ',': $maxlen++; break;
        case ':': $maxlen++; break;
        case '!': $maxlen++; break;
        case '?': $maxlen++; break;
        case ')': $maxlen++; break;
        case ';': $maxlen++; break;
        case '}': $maxlen++; break;
        }
        // cut
        $strMsg=substr($strMsg,0,$maxlen);
        $bTruncated=true;
      }
    }
    else
    {
      // strict-cutting (smartcut==0)
      $strMsg=substr($strMsg,0,$maxlen);
      $bTruncated=true;
    }
  }}}
  
  // DROP UNALLOWED BBC TAGS before using QTbbc (if '[' exists)
  if ( strpos($strMsg,'[')!==FALSE )
  {
    if ( !$arrBbc[0] ) $strMsg = preg_replace("/\[b\](.*?)\[\/b\]/","\$1", $strMsg);
    if ( !$arrBbc[1] ) $strMsg = preg_replace("/\[i\](.*?)\[\/i\]/","\$1", $strMsg);
    if ( !$arrBbc[2] ) $strMsg = preg_replace("/\[u\](.*?)\[\/u\]/","\$1", $strMsg);
    if ( !$arrBbc[3] ) $strMsg = preg_replace("/\[url\](.*?)\[\/url\]/","\$1", $strMsg);
    if ( !$arrBbc[4] ) $strMsg = preg_replace("/\[:(.*?)\]/","", $strMsg);
  }
  
  // format text
  $strMsg = QTbbc($strMsg,$output,$nl);

  if ( strpos($strMsg,'[')!==FALSE )
  {
    if ( $arrBbc[4] )
    {
    $strMsg = str_replace(
      array
      (
      '[:)]','[:(]','[:|]','[;)]','[:t]','[:o]','[:?]','[:!]','[:*]'
      ),
      array
      (
      '<img class="smile" src="'.$skin.'/ico_smile_01.gif" alt="[:)]" title="'.$L['Ico_smile01'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_02.gif" alt="[:(]" title="'.$L['Ico_smile02'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_03.gif" alt="[:|]" title="'.$L['Ico_smile03'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_04.gif" alt="[;)]" title="'.$L['Ico_smile04'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_05.gif" alt="[:t]" title="'.$L['Ico_smile05'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_06.gif" alt="[:o]" title="'.$L['Ico_smile06'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_07.gif" alt="[:?]" title="'.$L['Ico_smile07'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_08.gif" alt="[:!]" title="'.$L['Ico_smile08'].'"/>',
      '<img class="smile" src="'.$skin.'/ico_smile_09.gif" alt="[:*]" title="'.$L['Ico_smile09'].'"/>',
      ),
      $strMsg);
    }
  }
  
  // ADD '[More]' TO THE TEXT (if truncation has occurs)
  if ( $bTruncated )
  {
    $strMsg .= ' <a href="qtg_msg_view.php?id='.$oPost->id.'&amp;page='.$page.'">'.$L['More'].'</a>';
  }
  
  return $strMsg;
}
      
?>