<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

class cPost
{

//----------

var $id = -1;
var $name = '';
var $message = '';
var $userage = -1;
var $useremail = '';
var $issuedate = '0';
var $postfrom = '';
var $visible = 'Y';
var $x = 0;
var $y = 0;
var $z = 0;

//----------

function cPost($arr=null,$oDB=0)
{
  if ( !empty($arr) )
  {
    foreach ($arr as $strKey => $oValue)
    {
      switch ($strKey)
      {
      case 'id':       $this->id = $oValue; break;
      case 'name':     $this->name = $oValue; break;
      case 'userage':  $this->userage = $oValue; break;
      case 'useremail':$this->useremail = $oValue; break;
      case 'issuedate':$this->issuedate = $oValue; break;
      case 'postfrom': $this->postfrom = $oValue; break;
      case 'visible':  $this->visible = $oValue; break;
      case 'message':  $this->message = $oValue;
        if ( !empty($oDB) ) {
        if ( isset($oDB->type) ) {
        if ( $oDB->type=='oci' ) {
          $this->message = $arr['message']->read(50000);
        }}}
      break;
      case 'textmsg':  $this->message = $oValue; break; // required for firebird
      case 'x':        $this->x = floatval($oValue); break;
      case 'y':        $this->y = floatval($oValue); break;
      case 'z':        $this->z = floatval($oValue); break;
      }
    }
  }
}

//----------

function CheckMessage($max_size=5000,$min_char=false,$min_word=false)
{
  // check shortness
  if ( $min_char ) { if ( strlen($this->message)<$min_char ) return False; }
  if ( $min_word ) { $str = strtolower(substr($this->message,0,100)); $iWords = str_word_count($str); if ( $iWords < $min_word ) return False; }
  // check longness
  if ( strlen($this->message)>$max_size ) return False;
  // end
  return True;
}

//----------

function CheckMeaning()
{
  // no message
  if ( strlen($this->message)<2 ) return false; 
  // no letters  
  $str = strtolower(substr($this->message,0,200));
  if ( !ereg("[a-z]+",$str) ) return false;
  // check vowels exists
  $str = substr($this->message,0,100);
  $str = strtr($str,''  ,'eeeeeeee');
  $str = strtr($str,'','aaaaaaaaaa');
  $str = strtr($str,''  ,'iiiiiiii');
  $str = strtr($str,'','oooooooooo');
  $str = strtr($str,''  ,'uuuuuuuu'); 
  if ( !ereg("[aeiouy]+",$str) ) return false;
  // check random keyboard
  $arrWords = str_word_count($str,1);
  $i=0;
  foreach ( $arrWords as $strWord) {
  foreach ( array('qwe','wqe','qsd','sdf','dfg','fgh','jkl','klm','ghg','fjf','jfj','fgf','dfd','fdj','dfj') as $a ) {
    if ( strpos($strWord,$a)===false ) continue;
    $i++;
  }}  
  if ( $i>1 ) return false;
  // check multiple (4 and some 3)
  $str = substr($str,0,50);
  foreach ( array('a','b','c','d','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z') as $a )
  {
    $a = $a.$a.$a.$a;
    if ( strpos($str,$a)===false ) continue;
    return false;
  }
  foreach ( array('b','c','d','f','g','h','j','k','l','m','n','p','q','r','s','t','u','v','z') as $a )
  {
    $a = $a.$a.$a;
    if ( strpos($str,$a)===false ) continue;
    return false;
  }
  // check at least 1/2 words contains vowel
  $intWords = count($arrWords);
  $i=0;
  foreach ($arrWords as $strWord)
  {
    if ( ereg("[aeiouy]+",$strWord) ) $i++;
  }
  if ( $i==0 ) return false;
  if ( $i/$intWords<0.5 ) return false;
  // end control
  Return True;
}

//----------

function CheckWording($voc=array())
{
  if (count($voc)>0)
  {
    $str = strtolower(substr($this->message,0,1000));
    $words = str_word_count($str,1);
    $intwords = array_intersect($voc['good'],$words);
    if (count($intwords)==0) Return FALSE;
    $intwords = array_intersect($voc['bad'],$words);
    $ibad = count($intwords);
    if ($ibad>1) Return FALSE;
  }
  Return True;
}

//----------

}

?>