<?php 

// QuickTalk Guestbook 1.7 build:20080601

session_start();

//Select Font
$font = 'futurab.ttf';

//Select random background image
$bgurl = rand(1, 2);
$im = ImageCreateFromPNG('bg'.$bgurl.'.png');

//Generate the random string
$textstr = rand(0,9).rand(0,9).rand(0,9).rand(0,9);
$_SESSION['textcolor'] = sha1($textstr);

//Create random size, angle, and dark color
$size = 12;
$angle = 0;
$color = ImageColorAllocate($im, rand(0, 100), rand(0, 100), rand(0, 100));

//Determine text size, and use dimensions to generate x & y coordinates
$textsize = imagettfbbox($size, $angle, $font, $textstr);
$twidth = abs($textsize[2]-$textsize[0]);
$theight = abs($textsize[5]-$textsize[3]);
$x = (imagesx($im)/2)-($twidth/2)+(rand(-15, 15));
$y = (imagesy($im))-($theight/2);

//Add text to image
ImageTTFText($im, $size, $angle, $x, $y, $color, $font, $textstr);

//Output PNG Image
header('Content-Type: image/png');
ImagePNG($im);

//Destroy the image to free memory
imagedestroy($im);

//End Output
exit;

?>