<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ View Guestbook
+ Started: 28th May 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	function Module() {
		global $gcgb, $DB, $skin;

		switch ($gcgb->input['c']) {
		case 'view':
			$this->View();
		break;
		case 'hiddenemail':
			$this->HiddenEmail();
		break;
		default:
			$this->View();
		}
	}
	
	function View() {
	global $gcgb, $DB, $skin;

		// Do we have invalid input?
		if (!is_numeric($gcgb->input['show'])) {
			$gcgb->input['show'] =  $gcgb->config['perpage'];
		}
		if (!is_numeric($gcgb->input['show'])) {
			$gcgb->input['show'] =  "0";
		}
		
		$perpage = $gcgb->input['show'] ? floor($gcgb->input['show']) : $gcgb->config['perpage'];
		$start = $gcgb->input['start'] ? floor($gcgb->input['start']) : "0";

		// Prepare the Query
		$limit = "LIMIT ".$start.",".$perpage;
		$order = $gcgb->config['newattop'] ? "time DESC" : "time";

		// Query the Database
		$DB->query("SELECT * FROM gcgb_entries WHERE queued='0' ORDER BY ".$order." ".$limit);

		// Do we have any guestbook entries? Display them if so.
		// If not, say so.

		if ($DB->num_rows()) {

			$skin->LoadSkin("entry");

			// Display!
			while ($row = $DB->fetch_array()) {
			
				// Do we need to hide email adddy?
				if ($row['hideemail'] != "0" OR $gcgb->config['hideemail'] != '0') {
					$email_link = $gcgb->baseurl."?a=view".$gcgb->config['queryseperator']."c=hiddenemail";
				}
				else {
					$email_link = "mailto:".$row['email'];
				}

				// Do we have a reply?
				if ($row['reply']) {
					$row['reply'] = "Reply: ".$row['reply'];
				}
				
				// IP Address
				if ($gcgb->config['hideip']) {
					$ip = "Logged";
				}
				else {
					$ip = $row['ip'];
				}

				// Is it a private entry???
				if ($row['private']) {
					$row['comments'] = "The user has chosen to keep this entry private.";
				}
				
				echo $skin->ParseSkin("entry", array("id" => $row['id'], "name" => $row['name'], "comments" => $row['comments'], "reply" => $row['reply'], "time" => date($gcgb->config['timeformat'], $row['time']), "ip" => $ip, "email_link" => $email_link));
			}

			// Add some page links.
			$DB->query("SELECT approved FROM gcgb_stats");
			$row = $DB->fetch_array();
			$pages = ceil($row['approved'] / $perpage);

			echo '<span class="small">Pages: ';

			// Cycle adding links
			$pcount = "1";
			while ($pcount <= $pages) {
				echo ' <a href="'.$gcgb->baseurl.'?a=view'.$gcgb->config['queryseperator'].'start='.(($pcount - 1) * $perpage).$gcgb->config['queryseperator'].'show='.$perpage.'">'.$pcount.'</a> |';
				++$pcount;
			}

			echo '</span>';
		}
		else {
			$skin->LoadSkin("notice");
			echo $skin->ParseSkin("notice", array("message" => "No guestbook entries matching the specified criteria found."));
		}

	}

	function HiddenEmail() {
		global $gcgb, $DB, $skin;

		$skin->LoadSkin("notice");
		echo $skin->ParseSkin("notice", array("message" => "This user or administrator has chosen to hide this e-mail address from public view."));
	}
}

?>