<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Skin Functions
+ Started: 6th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Skin {
	var $skinid;
	var $skin = array();

	function Skin() {
		// Checks relevant skin exists
		global $gcgb;
		$gcgb->config['skin'] = str_replace(".", "", $gcgb->config['skin']);
		$gcgb->config['skin'] = str_replace("/", "", $gcgb->config['skin']);
		$this->skinid = $gcgb->config['skin'];

		if (!file_exists("skin/".$this->skinid)) {
			fatal_error("", "Could not find skin (ID:".$this->skinid.")", "", "", "", "Guestbook");
		}
	}

	function LoadSkin($file) {
		// Load a Skin File into memory
		if (file_exists("skin/".$this->skinid."/".$file.".html")) {
			if ($fp = fopen("skin/".$this->skinid."/".$file.".html", "r")) {
				$skinse = fread ($fp, filesize("skin/".$this->skinid."/".$file.".html"));
				fclose ($fp);

				$this->skin[$file] = $skinse;
			}
			else {
				fatal_error("", "Could not load skin section (Skin:".$this->skinid.", File: ".$file.")", "", "", "", "Guestbook");	
			}
		}
		else {
			fatal_error("", "Could not load skin section (Skin:".$this->skinid.", File: ".$file.")", "", "", "", "Guestbook");		
		}
	}

	function ParseSkin($file, $finrep=array()) {
		// Parse the skin file, and return it
		$skin = $this->skin[$file];

		foreach($finrep as $find => $replace) {
			$skin = preg_replace( "/\{$find\}/i", "$replace", $skin);
		}

		return $skin;
	}

	function LoadStyle() {
		// Load and return stylesheet
		if (file_exists("skin/".$this->skinid."/style.css")) {
			if ($fp = fopen("skin/".$this->skinid."/style.css", "r")) {
				$skinse = fread ($fp, filesize("skin/".$this->skinid."/style.css"));
				fclose ($fp);

				return $skinse;
			}
			else {
				fatal_error("", "Could not load skin stylesheet (Skin:".$this->skinid.")", "", "", "", "Guestbook");	
			}
		}
		else {
			fatal_error("", "Could not load skin stylesheet (Skin:".$this->skinid.")", "", "", "", "Guestbook");		
		}
	}
}

?>