<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Guestbook Help Files
+ Started: 28th May 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	function Module() {
	global $gcgb, $DB, $skin;

		switch ($gcgb->input['c']) {
			case 'idx':
				$this->ShowAll();
			break;
			case 'viewhelp':
				$this->ViewHelp();
			break;
			default:
				$this->ShowAll();
		}
	}

	function ShowAll() {
		global $gcgb, $DB, $skin;

		// Query the Database
		$DB->query("SELECT id, title, description FROM gcgb_help ORDER BY title");

		// Do we have any guestbook entries? Display them if so.
		// No help files? Ahh what!

		if ($DB->num_rows()) {

			$skin->LoadSkin("help");

			// Display!
			while ($row = $DB->fetch_array()) {
				echo $skin->ParseSkin("help", array("id" => $row['id'], "title" => $row['title'], "desc" => $row['description'], "link" => $gcgb->baseurl."?a=help".$gcgb->config['queryseperator']."c=viewhelp".$gcgb->config['queryseperator']."id=".$row['id']));
			}
		}
		else {
			$skin->LoadSkin("notice");
			echo $skin->ParseSkin("notice", array("message" => "No help files exist."));
		}
	}

	function ViewHelp() {
		global $gcgb, $DB, $skin;

		if (!$gcgb->input['id'] OR !is_numeric($gcgb->input['id'])) {
			$skin->LoadSkin("notice");
			echo $skin->ParseSkin("notice", array("message" => "Invalid Help File ID"));
		}

		// Query the Database
		$DB->query("SELECT author, title, description, text FROM gcgb_help WHERE id='".$gcgb->input['id']."';");

		// Display Guestbook Help File if exists
		if ($row = $DB->fetch_array()) {
			$skin->LoadSkin("helpfile");
			echo $skin->ParseSkin("helpfile", array("author" => $row['author'], "title" => $row['title'], "description" => $row['description'], "text" => $row['text']));
		}
		else {
			$skin->LoadSkin("notice");
			echo $skin->ParseSkin("notice", array("message" => "Invalid Help File ID"));
		}
	}
}

?>