<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin World Filter Management Module
+ Started: 23rd June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_config']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowFilters();
				break;
				case '01':
					$this->AddFilter();
				break;
				case '02':
					$this->RemoveFilter();
				break;
				case '03':
					$this->EditFilter();
				break;
				case '04':
					$this->DoEditFilter();
				break;
				default:
					$this->ShowFilters();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowFilters() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("wordfilter", "Word Filters");
		$skin->MakeMenu($this->permissions);

		echo '<table width="100%"><tr><th>Word</th><th>Replacment</th><th>Operations</th></tr>';
		$DB->query ("SELECT id, find, rep FROM gcgb_filters WHERE is_emo='0'");
		if ($DB->num_rows()) {
			while ($row = $DB->fetch_array()) {
				echo '<tr class="logc"><td>'.$row['find'].'</td><td>'.$row['rep'].'</td><td><a href="'.$gcgb->baseurl.'?a=wordfilter'.$gcgb->config['queryseperator'].'code=03'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Modify</a> | <a href="'.$gcgb->baseurl.'?a=wordfilter'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Remove</a></td></tr>';
			}
		}
		else {
			echo '<tr><td colspan="3" class="logc">No Word Filters Exist.</td></tr>';
		}
		echo '</table><form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="wordfilter" /><input type="hidden" name="code" value="01" /><strong>Add Word Filter</strong><br />Word Filters are not case sensetive. Therefore foo will match FOO and FoO.<br /><br />Word to Filter: <input type="text" name="word" /><br />Replacement: <input type="text" name="replacement" /><br /><br /><input type="Submit" value="Add Word Filter" /></form>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function AddFilter() {
		global $DB, $skin, $gcgb;

		$output = "";

		if (!$gcgb->input['word'] OR !$gcgb->input['replacement']) {
			$output .= "One of the Required Fields was left blank.";
		}
		else {
			// Insert Word Filter into Database
				$DB->query("INSERT INTO gcgb_filters VALUES ('', '".$gcgb->input['word']."', '".$gcgb->input['replacement']."', '0');");

				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Added a Word Filter to the Database', '".$_SERVER['REMOTE_ADDR']."');");

				$output .= "Word Filter Added.";
		}

		$skin->StartPage("wordfilter", "Word Filters");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}
	
	function RemoveFilter() {
		global $DB, $skin, $gcgb;
		if ($gcgb->input['id']) {
			// Attempt to remove Word Filter
			$DB->query ("DELETE FROM gcgb_filters WHERE is_emo='0' AND id='".$gcgb->input['id']."' LIMIT 1");
			if ($DB->affected_rows()) {
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Removed a Word Filter to the Database', '".$_SERVER['REMOTE_ADDR']."');");
				$output = "Word Filter removed.";
			}
			else {
				$output = "Could not remove word filter.";
			}
		}
		else {
			$output = "Could not remove wordfilter.";
		}
	
		$skin->StartPage("wordfilter", "Word Filters");
		$skin->MakeMenu($this->permissions);
	
		echo $output;
	
		$skin->EndTable();
		$skin->EndPage();
	}
	
	function EditFilter() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("wordfilter", "Word Filters");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['id']) {
			$DB->query("SELECT find, rep FROM gcgb_filters WHERE id='".$gcgb->input['id']."' AND is_emo='0';");
			if ($row = $DB->fetch_array()) {

				// Form to Edit Emotion
				echo '<form name="editemo" action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="wordfilter" /><input type="hidden" name="code" value="04" /><input type="hidden" name="id" value="'.$gcgb->input['id'].'"><strong>Edit Word Filter</strong><br /><br /><table width="100%" border="0"><tr><td width="75">Find</td><td><input type="text" name="find" value="'.$row['find'].'" maxlength="8" size="8" /></td></tr><tr><td width="75">Replace</td><td><input type="text" name="rep" value="'.$row['rep'].'"/></td></tr></table><input type="Submit" value="Edit Filter" /></form>';
			}
			else {
				echo "No/Invalid Filter Specified.";
			}
		}
		else {
			echo "No/Invalid Filter Specified.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoEditFilter() {
		global $DB, $skin, $gcgb;
		
		$output = "";

		if (!$gcgb->input['find'] OR !$gcgb->input['rep'] OR !$gcgb->input['id']) {
			$output .= "One of the Required Fields was left blank.";
		}
		else {				
				// Update Word Filter in DB
				$DB->query("UPDATE gcgb_filters SET find='".$gcgb->input['find']."',  rep='".$gcgb->input['rep']."' WHERE id='".$gcgb->input['id']."';");
		
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Modified a Word Filter to the Database', '".$_SERVER['REMOTE_ADDR']."');");
				
				$output .= "Word Filter Updated.";
			}

		$skin->StartPage("wordfilter", "Word Filters");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}
	
}

?>