<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Users Manager
+ Started: 27th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_admins']) {

			if ($gcgb->input['a'] == "adminadd") {
				switch ($gcgb->input['code']) {
					case '00':
						$this->AddUser();
					break;
					case '01':
						$this->DoAddUser();
					break;
					default:
						$this->AddUser();
				}
			}
			else {
				switch ($gcgb->input['code']) {
					case '00':
						$this->ShowUsers();
					break;
					case '01':
						$this->EditUser();
					break;
					case '02':
						$this->DeleteUser();
					break;
					case '03':
						$this->DoEditUser();
					break;
					default:
						$this->ShowUsers();
				}
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function AddUser() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminadd", "Add Admin");
		$skin->MakeMenu($this->permissions);

		// Display Form
		echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="adminadd" /><input type="hidden" name="code" value="01" /><table width="100%" border="0"><tr><td width="100">Username:</td><td><input type="text" name="ad_username" /></td></tr><tr><td width="100">Password:</td><td><input type="password" name="ad_password" /></td><tr><td colspan="2"><strong>Administrative Permissions</strong><br /><input type="checkbox" name="adedit_config" value="1" /> Modify Guestbook <strong>Configuration</strong><br /><input type="checkbox" name="adedit_entries" value="1" /> Approve and Manage <strong>Guestbook Entries</strong><br /><input type="checkbox" name="adedit_skin" value="1" /> Modify <strong>Skin</strong> Settings, Templates, and Styles<br /><input type="checkbox" name="adedit_help" value="1" /> Access and Edit <strong>Help Files</strong><br /><input type="checkbox" name="adedit_stats" value="1" /> View <strong>Statistics Centre</strong><br /><input type="checkbox" name="adedit_logs" value="1" /> View Guestbook <strong>Logs</strong><br /><input type="checkbox" name="adedit_admins" value="1" /> Create and Modify <strong>Admin Users</strong></td></tr></tr></table><input type="Submit" value="Add User" /></form>';

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoAddUser() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminadd", "Add Admin");
		$skin->MakeMenu($this->permissions);

		// Check we have all input
		if ($gcgb->input['ad_username'] AND $gcgb->input['ad_password']) {
			$DB->query ("SELECT id FROM gcgb_admins WHERE username='".$gcgb->input['ad_username']."';");
			if ($DB->num_rows()) {
				// Uh, Oh. Multis
				$skin->ActionFailiure ("A user with that username already exists.", "Add Admin", "adminadd");
			}
			else {
				// Permissions
				$adedit_config = $gcgb->input['adedit_config'] ? "1" : "0";
				$adedit_entries = $gcgb->input['adedit_entries'] ? "2" : "0";
				$adedit_skin = $gcgb->input['adedit_skin'] ? "4" : "0";
				$adedit_help = $gcgb->input['adedit_help'] ? "8" : "0";
				$adedit_stats = $gcgb->input['adedit_stats'] ? "16" : "0";
				$adedit_logs = $gcgb->input['adedit_logs'] ? "32" : "0";
				$adedit_admins = $gcgb->input['adedit_admins'] ? "64" : "0";

				$perms = intval($adedit_config + $adedit_entries + $adedit_skin + $adedit_help + $adedit_stats + $adedit_logs + $adedit_admins);

				// Add User
				$DB->query ("INSERT INTO gcgb_admins (id, username, password, admin_perms) VALUES ('', '".$gcgb->input['ad_username']."', '".md5($gcgb->input['ad_password'])."', '".$perms."');");

				if ($DB->affected_rows()) {
					$DB->query ("INSERT INTO gcgb_logs VALUES('', '4', '".$this->username."', 'Added Admin User: \'".$gcgb->input['ad_username']."\'', '".$_SERVER['REMOTE_ADDR']."');");

					$skin->ActionSuccess ("User Created.<br /><br />Username: ".$gcgb->input['ad_username']."<br />Password: ".$gcgb->input['ad_password'], "adminadd", "Add Admin");
				}
				else {
					$skin->ActionFailiure ("Could not add user", "Add Admin", "adminadd");
				}
			}
		}
		else {
			$skin->ActionFailiure ("One or more required fields were left blank.", "Add Admin", "adminadd");
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function ShowUsers() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminmanage", "Manage Admins");
		$skin->MakeMenu($this->permissions);

		echo '<table width="100%" border="0"><tr><th>Username</th><th>Config</th><th>Entries</th><th>Skin</th><th>Help</th><th>Stats</th><th>Logs</th><th>Admins</th><th>Operations</th></tr>';
		$DB->query ("SELECT id, username, admin_perms FROM gcgb_admins");
		while ($row = $DB->fetch_array()) {
			// Cycle through the users. If root user (1), do not display delete link
			if ($row['id'] != "1") {
				$deletelink = ' | <a href="'.$gcgb->baseurl.'?a=adminmanage'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'uid='.$row['id'].'">Delete</a>';
			}
			// Permissions. Display Yes or No.
			$perms = strrev(base_convert(intval($row['admin_perms']), 10, 2));

			$permsarray = array(
				"edit_config" => intval($perms['0']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_entries" => intval($perms['1']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_skin" => intval($perms['2']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_help" => intval($perms['3']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_stats" => intval($perms['4']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_logs" => intval($perms['5']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
				"edit_admins" => intval($perms['6']) ? '<span style="color: green">Y</span>' : '<span style="color: red">N</span>',
			);

			echo '<tr style="text-align: center;"><td>'.$row['username'].'</td><td>'.$permsarray['edit_config'].'</td><td>'.$permsarray['edit_entries'].'</td><td>'.$permsarray['edit_skin'].'</td><td>'.$permsarray['edit_help'].'</td><td>'.$permsarray['edit_stats'].'</td><td>'.$permsarray['edit_logs'].'</td><td>'.$permsarray['edit_admins'].'</td><td align="left"><a href="'.$gcgb->baseurl.'?a=adminmanage'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'uid='.$row['id'].'">Edit</a>'.$deletelink.'</td></tr>';
		}
		echo '</table><br />&nbsp;<a href="'.$gcgb->baseurl.'?a=adminadd">Add Admin</a>';

		$skin->EndTable();
		$skin->EndPage();
	}

	function EditUser() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminmanage", "Manage Admins");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['uid']) {
			// Grab current info from the DB
			$DB->query ("SELECT username, admin_perms FROM gcgb_admins WHERE id='".$gcgb->input['uid']."';");
			if ($row = $DB->fetch_array()) {
				// Permissions!!!
				$perms = strrev(base_convert(intval($row['admin_perms']), 10, 2));

				$permsarray = array(
					"edit_config" => intval($perms['0']) ? 'checked="checked" ' : '',
					"edit_entries" => intval($perms['1']) ? 'checked="checked" ' : '',
					"edit_skin" => intval($perms['2']) ? 'checked="checked" ' : '',
					"edit_help" => intval($perms['3']) ? 'checked="checked" ' : '',
					"edit_stats" => intval($perms['4']) ? 'checked="checked" ' : '',
					"edit_logs" => intval($perms['5']) ? 'checked="checked" ' : '',
					"edit_admins" => intval($perms['6']) ? 'checked="checked" ' : '',
				);

				echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="adminmanage" /><input type="hidden" name="code" value="03" /><input type="hidden" name="uid" value="'.$gcgb->input['uid'].'" /><table width="100%" border="0"><tr><td width="100">Username:</td><td><input type="text" name="ad_username" value="'.$row['username'].'" /></td></tr><tr><td width="100">Password:</td><td><input type="password" name="ad_password" /> (Leave blank to keep as current)</td></tr><tr><td colspan="2"><strong>Administrative Permissions</strong><br /><input type="checkbox" name="adedit_config" value="1" '.$permsarray['edit_config'].'/> Modify Guestbook <strong>Configuration</strong><br /><input type="checkbox" name="adedit_entries" value="1" '.$permsarray['edit_entries'].'/> Approve and Manage <strong>Guestbook Entries</strong><br /><input type="checkbox" name="adedit_skin" value="1" '.$permsarray['edit_skin'].'/> Modify <strong>Skin</strong> Settings, Templates, and Styles<br /><input type="checkbox" name="adedit_help" value="1" '.$permsarray['edit_help'].'/> Access and Edit <strong>Help Files</strong><br /><input type="checkbox" name="adedit_stats" value="1" '.$permsarray['edit_stats'].'/> View <strong>Statistics Centre</strong><br /><input type="checkbox" name="adedit_logs" value="1" '.$permsarray['edit_logs'].'/> View Guestbook <strong>Logs</strong><br /><input type="checkbox" name="adedit_admins" value="1" '.$permsarray['edit_admins'].'/> Create and Modify <strong>Admin Users</strong></td></tr></table><input type="Submit" value="Edit User" /></form>';
			}
			else {
				echo "You did not specifiy a valid admin.";
			}
		}
		else {
			echo "You did not specifiy a valid admin.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoEditUser() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminadd", "Add Admin");
		$skin->MakeMenu($this->permissions);

		// Check we have all input
		if ($gcgb->input['ad_username']) {
			$DB->query ("SELECT id FROM gcgb_admins WHERE username='".$gcgb->input['ad_username']."' AND id!='".$gcgb->input['uid']."';");
			if ($DB->num_rows()) {
				// Make sure no user has that username except from self
				$skin->ActionFailiure ("There is already an admin with that username.", "Manage Admins", "adminmanage");
			}
			else {
				// Permissions. Grr.
				$adedit_config = $gcgb->input['adedit_config'] ? "1" : "0";
				$adedit_entries = $gcgb->input['adedit_entries'] ? "2" : "0";
				$adedit_skin = $gcgb->input['adedit_skin'] ? "4" : "0";
				$adedit_help = $gcgb->input['adedit_help'] ? "8" : "0";
				$adedit_stats = $gcgb->input['adedit_stats'] ? "16" : "0";
				$adedit_logs = $gcgb->input['adedit_logs'] ? "32" : "0";
				$adedit_admins = $gcgb->input['adedit_admins'] ? "64" : "0";

				$perms = intval($adedit_config + $adedit_entries + $adedit_skin + $adedit_help + $adedit_stats + $adedit_logs + $adedit_admins);

				// Update Password?
				if ($gcgb->input['ad_password'] != "") {
					$passwordsql = ", password='".md5($gcgb->input['ad_password'])."'";
				}
				else {
					$passwordsql = "";
				}

				$DB->query ("UPDATE gcgb_admins SET username='".$gcgb->input['ad_username']."'".$passwordsql.", admin_perms='".$perms."' WHERE id='".$gcgb->input['uid']."' LIMIT 1");

				if ($DB->affected_rows()) {

					// Log
					$DB->query ("INSERT INTO gcgb_logs VALUES('', '4', '".$this->username."', 'Updated Admin User: \'".$gcgb->input['ad_username']."\'', '".$_SERVER['REMOTE_ADDR']."');");

					$skin->ActionSuccess ("User Updated.", "Manage Admins", "adminmanage");
				}
				else {
					$skin->ActionFailiure ("Could not update user.", "Manage Admins", "adminmanage");
				}
			}
		}
		else {
			$skin->ActionFailiure ("One or more required fields were left blank.", "Manage Admins", "adminmanage");
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DeleteUser() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminmanage", "Manage Admins");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['uid']) {
			// Check Root User isn't being deleted
			if ($gcgb->input['uid'] != "1") {
				$DB->query ("DELETE FROM gcgb_admins WHERE id='".$gcgb->input['uid']."' AND id != '1'");
				if ($DB->affected_rows()) {
					// Log
					$DB->query ("INSERT INTO gcgb_logs VALUES('', '4', '".$this->username."', 'Deleted an Admin User', '".$_SERVER['REMOTE_ADDR']."');");
					
					echo "User Deleted.";
				}
				else {
					echo "Could not delete user.";
				}
			}
			else {
				echo "You cannot delete the root user.";
			}
		}
		else {
			echo "No User Specified.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

}

?>