<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Statistics Centre Module
+ Started: 12th August 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_stats']) {

			switch ($gcgb->input['s']) {
				case '1':
					$this->GuestbookEntries();
				break;
				case '2':
					$this->AdminActions();
				break;
				default:
					$this->GuestbookEntries();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function GuestbookEntries() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("stats", "Statistics Centre");
		$skin->MakeMenu($this->permissions);

		// Function which does it all

		echo '<p>Please note these statistics are based on the information currently in the database, and does not take into account deleted entries.</p>';
		echo '<table width="100%" border="0"><tr class="formsec"><th colspan="3">&nbsp;Entries By Day</td></tr>';

		$DB->query ("SELECT COUNT(id) AS entries, time, DATE_FORMAT(FROM_UNIXTIME(time), '%w %U %m %Y') AS timed FROM gcgb_entries GROUP BY timed ORDER BY time DESC");
		$count = 0;
		$total = 0;
		$max = 0;
		$cache = array();
		while ($row = $DB->fetch_array()) {
			$cache[] = $row;
			//echo $skin->BuildRow(date("jS F Y", $row['time']), $row['entries']);
			$total = $total + $row['entries'];
			$max = $row['entries'] > $max ? $row['entries'] : $max;
			++$count;
		}

		foreach ($cache as $row) {
			// Display

			echo '<tr><td width="30%">&nbsp;'.date("jS F Y", $row['time']).'</td><td width="60%"><img src="script/bar.gif" height="10" width="'.(floor($row['entries']/ $total * 100 * 3) + 10).'" /></td><td width="10%" align="right">'.$row['entries'].'&nbsp;</td></tr>';
		}

		echo '<tr style="font-weight: bold;"><td></td><td>Total Entries:</td><td align="right">'.$total.'&nbsp;</td></tr>';

		echo '</table><br />';

		echo '<table width="100%" border="0"><tr class="formsec"><th colspan="3">&nbsp;Entries By Month</td></tr>';

		$DB->query ("SELECT COUNT(id) AS entries, time, DATE_FORMAT(FROM_UNIXTIME(time), '%m %Y') AS timed FROM gcgb_entries GROUP BY timed ORDER BY time DESC");
		$count = 0;
		$total = 0;
		$max = 0;
		$cache = array();
		while ($row = $DB->fetch_array()) {
			$cache[] = $row;
			//echo $skin->BuildRow(date("jS F Y", $row['time']), $row['entries']);
			$total = $total + $row['entries'];
			$max = $row['entries'] > $max ? $row['entries'] : $max;
			++$count;
		}

		foreach ($cache as $row) {
			// Display

			echo '<tr><td width="30%">&nbsp;'.date("F Y", $row['time']).'</td><td width="60%"><img src="script/bar.gif" height="10" width="'.(floor($row['entries']/ $total * 100 * 3) + 10).'" /></td><td width="10%" align="right">'.$row['entries'].'&nbsp;</td></tr>';
		}

		echo '<tr style="font-weight: bold;"><td></td><td>Total Entries:</td><td align="right">'.$total.'&nbsp;</td></tr>';

		echo '</table><br />';

		echo '<table width="100%" border="0"><tr class="formsec"><th colspan="3">&nbsp;Entries By Year</td></tr>';

		$DB->query ("SELECT COUNT(id) AS entries, time, DATE_FORMAT(FROM_UNIXTIME(time), '%Y') AS timed FROM gcgb_entries GROUP BY timed ORDER BY time DESC");
		$count = 0;
		$total = 0;
		$max = 0;
		$cache = array();
		while ($row = $DB->fetch_array()) {
			$cache[] = $row;
			$total = $total + $row['entries'];
			$max = $row['entries'] > $max ? $row['entries'] : $max;
			++$count;
		}

		foreach ($cache as $row) {
			// Display

			echo '<tr><td width="30%">&nbsp;'.date("Y", $row['time']).'</td><td width="60%"><img src="script/bar.gif" height="10" width="'.(floor($row['entries']/ $total * 100 * 3) + 10).'" /></td><td width="10%" align="right">'.$row['entries'].'&nbsp;</td></tr>';
		}

		echo '<tr style="font-weight: bold;"><td></td><td>Total Entries:</td><td align="right">'.$total.'&nbsp;</td></tr>';

		echo '</table>';

		$skin->EndTable();
		$skin->EndPage();
	}

	function AdminActions() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("stats", "Statistics Centre");
		$skin->MakeMenu($this->permissions);

		echo '<table width="100%" border="0"><tr class="formsec"><th colspan="3">&nbsp;Admin Actions By User</td></tr>';

		$DB->query ("SELECT COUNT(id) AS actions, user FROM gcgb_logs GROUP BY user ORDER BY user");
		$count = 0;
		$total = 0;
		$max = 0;
		$cache = array();
		while ($row = $DB->fetch_array()) {
			$cache[] = $row;
			$total = $total + $row['actions'];
			$max = $row['actions'] > $max ? $row['actions'] : $max;
			++$count;
		}

		foreach ($cache as $row) {
			// Display

			echo '<tr><td width="30%">&nbsp;'.$row['user'].'</td><td width="60%"><img src="script/bar.gif" height="10" width="'.(floor($row['actions']/ $total * 100 * 3) + 10).'" /></td><td width="10%" align="right">'.$row['actions'].'&nbsp;</td></tr>';
		}

		echo '<tr style="font-weight: bold;"><td></td><td>Total Actions:</td><td align="right">'.$total.'&nbsp;</td></tr>';

		echo '</table><br />';		

		echo '<table width="100%" border="0"><tr class="formsec"><th colspan="3">&nbsp;Admin Actions By Type</td></tr>';

		$DB->query ("SELECT COUNT(id) AS actions, type FROM gcgb_logs WHERE type > '0' AND type < '6' GROUP BY type ORDER BY type");
		$count = 0;
		$total = 0;
		$max = 0;
		$cache = array();
		$tehstuff = array (
			"1" => "Basic Configuration",
			"2" => "Entries",
			"3" => "Skin",
			"4" => "Admin Users",
			"5" => "Help Files",
		);

		while ($row = $DB->fetch_array()) {
			$cache[] = $row;
			$total = $total + $row['actions'];
			$max = $row['actions'] > $max ? $row['actions'] : $max;
			++$count;
		}

		foreach ($cache as $row) {
			// Display

			echo '<tr><td width="30%">&nbsp;'.$tehstuff[$row['type']].'</td><td width="60%"><img src="script/bar.gif" height="10" width="'.(floor($row['actions']/ $total * 100 * 3) + 10).'" /></td><td width="10%" align="right">'.$row['actions'].'&nbsp;</td></tr>';
		}

		echo '<tr style="font-weight: bold;"><td></td><td>Total Actions:</td><td align="right">'.$total.'&nbsp;</td></tr>';

		echo '</table>';

		$skin->EndTable();
		$skin->EndPage();
	}

}

?>