<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Style Editor
+ Started: 27th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_skin']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->Select();
				break;
				case '01':
					$this->ShowStyle();
				break;
				case '02':
					$this->UpdateStyle();
				break;
				default:
					$this->Select();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function GetCompatible($cproduct, $cversion) {
		// This function checks whether skins created with the version
		// of Global Centre Guestbook are compatible with the current
		// version.

		if ($cversion == "1.0rc1") {
			return true;
		}
		else {
			return false;
		}
	}

	function Select() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sstyle", "Style Editor");
		$skin->MakeMenu($this->permissions);
		// Make a cute wubbable list of compatible skins to select or to get more info on

		if ($skinf = opendir ("skin")) {
			echo '<table width="100%" border="0"><tr><th>Skin Name</th><th width="100">Current Skin</th><th width="200">Actions</th></tr>';

			while (false !== ($file = readdir($skinf))) { 
				if ($file != "." AND $file != "..") {
					if (include ("skin/".$file."/info.php")) {
						// Get Skin Information
						$skininfo = $info;
						if ($this->GetCompatible($skininfo['genproduct'], $skininfo['genversion'])) {
							// Work out if it's the current skin
							if ($gcgb->config['skin'] == $file) {
								$currentskin = "Yes";
							}
							else {
								$currentskin = "No";
							}

							// We have a compatible skin and stuff. Show info and options.
							echo '<tr class="logc"><td>'.$skininfo['name'].'</td><td>'.$currentskin.'</td><td><a href="'.$gcgb->baseurl.'?a=sstyle'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'skin='.$file.'">Edit CSS</a></td></tr>';
						}
					}
					else {
						echo $file;
					}
				}
			}
			closedir ($skinf);

			echo '</table>';

		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function ShowStyle() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sstyle", "Style Editor");
		$skin->MakeMenu($this->permissions);

		// Check we have a goody goody skin which exists or a ebil one
		if ($gcgb->input['skin'] AND file_exists("skin/".$gcgb->input['skin']."/style.css")) {
			// Load the CSS into memory
			$css = fopen ("skin/".$gcgb->input['skin']."/style.css", "r");
			$cssfile = fread ($css, filesize("skin/".$gcgb->input['skin']."/style.css"));
			fclose ($css);

			// Display box with CSS in so you can edit :)
			echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="sstyle" /><input type="hidden" name="code" value="02" /><input type="hidden" name="skin" value="'.$gcgb->input['skin'].'" /><textarea name="cssfile" cols="70" rows="15">'.$cssfile.'</textarea><br /><br /><input type="Submit" value="Update CSS" /></form>';
		}
		else {
			echo "Invalid Skin or Error occured whilst attempting to load CSS.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function UpdateStyle() {
		global $DB, $skin, $gcgb;
		// This is really wubbable... we're changing the style of the guestbook. :D

		if ($gcgb->input['skin'] AND $gcgb->input['cssfile']  AND file_exists("skin/".$gcgb->input['skin']."/style.css")) {
			// Step One: Remove ebil <br />s
			$cssfile = str_replace ("<br />", "", $gcgb->input['cssfile']);

			// Update the CSS
			$css = fopen ("skin/".$gcgb->input['skin']."/style.css", "w");
			fwrite ($css, $cssfile);
			fclose ($css);

			// Log it so if someone changes the CSS and screws it up
			// You'll know who :P
			$DB->query ("INSERT INTO gcgb_logs VALUES('', '3', '".$this->username."', 'Updated Stylesheets for skin: ".$gcgb->input['skin']."', '".$_SERVER['REMOTE_ADDR']."');");

			$output = "Style Updated.";
		}
		else {
			$output = "Could not update CSS.";
		}

		$skin->StartPage("sstyle", "Style Editor");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

}

?>