<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Skin Selector
+ Started: 26th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_skin']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->Select();
				break;
				case '01':
					$this->DoSelect();
				break;
				case '02':
					$this->MoreInfo();
				break;
				default:
					$this->Select();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function GetCompatible($cproduct, $cversion) {
		// This function checks whether skins created with the version
		// of Global Centre Guestbook are compatible with the current
		// version.

		if ($cversion == "1.0rc1" OR $cversion == "1.0rc2") {
			return true;
		}
		else {
			return false;
		}
	}

	function Select() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sselect", "Skin Selector");
		$skin->MakeMenu($this->permissions);

		echo "Current Skin: <strong>".$gcgb->config['skin']."</strong><br /><br />";

		// Make a cute wubbable list of compatible skins to select or to get more info on

		if ($skinf = opendir ("skin")) {
			echo '<table width="100%" border="0"><tr><th>Skin Name</th><th>Skin Author</th><th>Skin Options</th></tr>';

			while (false !== ($file = readdir($skinf))) { 
				if ($file != "." AND $file != "..") {
					if (include ("skin/".$file."/info.php")) {
						// Get Skin Information
						$skininfo = $info;
						if ($this->GetCompatible($skininfo['genproduct'], $skininfo['genversion'])) {
							// We have a compatible skin and stuff. Show info and options.
							echo '<tr class="logc"><td>'.$skininfo['name'].'</td><td>'.$skininfo['author'].'</td><td><a href="'.$gcgb->baseurl.'?a=sselect'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$file.'">More Info</a> | <a href="'.$gcgb->baseurl.'?a=sselect'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'skin='.$file.'">Select Skin</a></td></tr>';
						}
					}
					else {
						echo $file;
					}
				}
			}
			closedir ($skinf);

			echo '</table>';

			echo "<p>Skins which are not compatible with the current version of Global Centre Guestbook are automatically hidden.</p>";
		}
		else {
			echo "Could not open skin directory";
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function DoSelect() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sselect", "Skin Selector");
		$skin->MakeMenu($this->permissions);

		$output = "";

		if ($gcgb->input['skin'] AND file_exists("skin/".$gcgb->input['skin']."/info.php")) {
			// Write Config
			
			require ("config.php");
				
			if (!$fp = fopen ("config.php", "w")) {
				$output .= "<p>Fatal Error: Could not open Configuration File.</p>";
			}
			else {
				// Mmmmm.... Pie
				$configfile = <<<EOC
<?php
\$config['sql']['driver'] = "{$config['sql']['driver']}";
\$config['sql']['host'] = "{$config['sql']['host']}";
\$config['sql']['user'] = "{$config['sql']['user']}";
\$config['sql']['password'] = "{$config['sql']['password']}";
\$config['sql']['db'] = "{$config['sql']['db']}";
\$config['sql']['prefix'] = "{$config['sql']['prefix']}";

\$config['sitename'] = "{$config['sitename']}";
\$config['siteurl'] = "{$config['siteurl']}";
\$config['adminemail'] = "{$config['adminemail']}";

\$config['offline'] = "{$config['offline']}";
\$config['offline_msg'] = "{$config['offline_msg']}";
\$config['scriptname'] = "{$config['scriptname']}";
\$config['adminscriptname'] = "{$config['adminscriptname']}";
\$config['queryseperator'] = "{$config['queryseperator']}";

\$config['perpage'] = "{$config['perpage']}";
\$config['newattop'] = "{$config['newattop']}";
\$config['hideip'] = "{$config['hideip']}";
\$config['hideemail'] = "{$config['hideemail']}";
\$config['moderate'] = "{$config['moderate']}";

\$config['allow_html'] = "{$config['allow_html']}";
\$config['allow_gccode'] = "{$config['allow_gccode']}";

\$config['gzip'] = "{$config['gzip']}";
\$config['timeformat'] = "{$config['timeformat']}";
\$config['smileyfolder'] = "{$config['smileyfolder']}";

\$config['skin'] = "{$gcgb->input['skin']}";
?>
EOC;
				 
				fwrite ($fp, $configfile);
				fclose ($fp);

				$output .= "Skin Settings Updated.";

				// Logger it
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '3', '".$this->username."', 'Updated Skin Settings', '".$_SERVER['REMOTE_ADDR']."');");
			}
		}
		else {
			$output .= "Invalid Skin Specified.";
		}

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

	function MoreInfo() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sselect", "Skin Selector");
		$skin->MakeMenu($this->permissions);

		// Get more info on the skin because info wants to be free :P

		if ($gcgb->input['skin']) {
			if (file_exists("skin/".$gcgb->input['skin']."/info.php")) {
				include ("skin/".$gcgb->input['skin']."/info.php");
				$skininfo = $info;

				echo '<strong>Skin Name:</strong> '.$skininfo['name'].'<br /><strong>Skin Version:</strong> '.$skininfo['version'].'<br /><strong>Author Name:</strong> '.$skininfo['author'].'<br /><strong>Author E-Mail:</strong> <a href="mailto:'.$skininfo['email'].'">'.$skininfo['email'].'</a>'.'<br /><strong>Author Website:</strong> <a href="'.$skininfo['url'].'">'.$skininfo['url'].'</a>'.'<br /><strong>License:</strong> '.$skininfo['license'].'<br /><br /><a href="'.$gcgb->baseurl.'?a=sselect'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].'">Select Skin</a><br /><br />Skin Generated with '.$skininfo['genproduct'].' '.$skininfo['genversion'];
			}
			else {
				echo "Invalid Skin Selected.";
			}
		}
		else {
			echo "No Skin Selected";
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

?>