<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Skin Editor
+ Started: 27th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_skin']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->SelectSkin();
				break;
				case '01':
					$this->SelectTemplate();
				break;
				case '02':
					$this->ShowTemplate();
				break;
				case '03':
					$this->UpdateTemplate();
				break;
				default:
					$this->SelectSkin();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function GetNotes($section) {
		// Notes for each skin section. Says what it does etc.
		switch ($section) {
			case 'entry':
				return 'The HTML code for each guestbook entry.';
			break;
			case 'footer':
				return 'The HTML code for the page footer. Shown below entries, and everything else.<br /><br /><span style="color:red">Yes, we know it\'s easy to remove the copyright. However, literally hundreds of hours have been spent on creating a powerful guestbook, for you to use. Furthermore, we even give it to you for free :)<br /><br />We could make it harder to remove the copyright, but we do not intend to, as we hope users would respect the copyright, and the hours of work gone into creating it.</span>';
			break;
			case 'header':
				return 'The HTML code for the page header. This is shown above all content.';
			break;
			case 'help':
				return 'The HTML code used on the help page to display a list of help files';
			break;
			case 'helpfile':
				return 'The HTML code for the actual help file';
			break;
			case 'notice':
				return 'Whenever there is a notice to the user, this template will be used';
			break;
			case 'postform':
				return 'The code for the form on the Sign Guestbook page.';
			break;
		}
	}
	
	function GetCodes($section) {
		// Code Guide :)
		switch ($section) {
			case 'entry':
				return array(
				'email_link' => 'Link to visitor\'s email address',
				'id' => 'Internal Guestbook Entry ID',
				'time' => 'The time the entry was posted',
				'comments' => 'The comments the visitor left',
				'reply' => 'The reply left by the Guestbook Admin (if applicable)',
				'ip' => 'The visitor\'s IP Address (If not hidden)',
				);
			break;
			case 'footer':
				return array(
				'exectime' => 'The length of time it took for the script to execute',
				'queries' => 'The amount of database queries used to build the page',
				'gzipstatus' => 'Whether GZIP compression is enabled',
				'copyright' => 'The copyright notice. Please do not remove this :)',
				);
			break;
			case 'header':
				return array(
				'sitename' => 'Your site\'s name',
				'page' => 'The current guestbook page',
				'style' => 'The current skin\'s CSS',
				'siteurl' => 'The address of your site',
				'sitename' => 'Your site\'s name',
				'viewurl' => 'The URL of the Sign Guestbook page',
				'signurl' => 'The URL of the View Guestbook page',
				'helpurl' => 'The URL of the Help page',
				);
			break;
			case 'help':
				return array(
				'id' => 'The internal help file ID',
				'link' => 'The URL of the help file page',
				'title' => 'The Help File Name',
				'desc' => 'The Help File Description',
				);
			break;
			case 'helpfile':
				return array(
				'title' => 'The Help File Name',
				'author' => 'The author of the help file',
				'description' => 'The Help File Description',
				'link' => 'The actual help file!',
				);
			break;
			case 'notice':
				return array(
				'message' => 'Notice',
				);
			break;
			case 'postform':
				return array(
				'codebutton' => 'GCCode Buttons (If GCCode Enabled)',
				'emoticons' => 'Clickable list of Emoticons Installed',
				);
			break;
		}
	}

	function GetCompatible($cproduct, $cversion) {
		// This function checks whether skins created with the version
		// of Global Centre Guestbook are compatible with the current
		// version.

		if ($cversion == "1.0rc1" OR $cversion == "1.0rc2") {
			return true;
		}
		else {
			return false;
		}
	}

	function SelectSkin() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sedit", "Skin Editor");
		$skin->MakeMenu($this->permissions);
		// Make a cute wubbable list of compatible skins to select or to get more info on

		if ($skinf = opendir ("skin")) {
			echo '<table width="100%" border="0"><tr><th>Skin Name</th><th width="100">Current Skin</th><th width="200">Actions</th></tr>';

			while (false !== ($file = readdir($skinf))) { 
				if ($file != "." AND $file != "..") {
					if (include ("skin/".$file."/info.php")) {
						// Get Skin Information
						$skininfo = $info;
						if ($this->GetCompatible($skininfo['genproduct'], $skininfo['genversion'])) {
							// Work out if it's the current skin
							if ($gcgb->config['skin'] == $file) {
								$currentskin = "Yes";
							}
							else {
								$currentskin = "No";
							}

							// We have a compatible skin and stuff. Show info and options.
							echo '<tr class="logc"><td>'.$skininfo['name'].'</td><td>'.$currentskin.'</td><td><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'skin='.$file.'">Edit HTML Templates</a></td></tr>';
						}
					}
					else {
						echo $file;
					}
				}
			}
			closedir ($skinf);

			echo '</table>';

		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function SelectTemplate() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("sedit", "Skin Editor");
		$skin->MakeMenu($this->permissions);

		// Check we have a goody goody skin which exists or a ebil one
		if ($gcgb->input['skin'] AND file_exists("skin/".$gcgb->input['skin'])) {

			// Display list of templates - Argh Messy
			echo 'Please select a template to edit:<br /><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=entry
			">Guestbook Entry</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=footer
			">Page Footer</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=header
			">Page Header</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=help
			">Help File List</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=helpfile
			">Help File</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=notice
			">Notice</a><br /><a href="'.$gcgb->baseurl.'?a=sedit'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'skin='.$gcgb->input['skin'].$gcgb->config['queryseperator'].'template=postform
			">Post Form</a>';
		}
		else {
			echo "Invalid Skin.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}
	
	function ShowTemplate() {
		global $DB, $skin, $gcgb;
		$skin->StartPage("sedit", "Skin Editor");
		$skin->MakeMenu($this->permissions);
		
		if ($gcgb->input['skin'] AND $gcgb->input['template'] AND file_exists("skin/".$gcgb->input['skin']."/".$gcgb->input['template'].".html")) {
			$template = fopen ("skin/".$gcgb->input['skin']."/".$gcgb->input['template'].".html", "r");
			$templatefile = fread ($template, filesize("skin/".$gcgb->input['skin']."/".$gcgb->input['template'].".html"));
			fclose ($template);
			
			$templatefile = str_replace ("<", "&lt;", $templatefile);
			$templatefile = str_replace (">", "&gt;", $templatefile);
			
			// Display the template in a nice box with template info and codes
			echo '<strong>Template Information</strong><br />'.$this->GetNotes($gcgb->input['template']).'<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="sedit" /><input type="hidden" name="code" value="03" /><input type="hidden" name="skin" value="'.$gcgb->input['skin'].'" /><input type="hidden" name="template" value="'.$gcgb->input['template'].'" /><textarea name="templatefile" cols="70" rows="15">'.$templatefile.'</textarea><br /><br /><input type="Submit" value="Update Template" /></form>';

			// Display list of codes which can be used in template
			$codes = $this->GetCodes($gcgb->input['template']);
			echo '<strong>Template Codes</strong><br />You can use the following codes in the templates. They will automatically be parsed at runtime.<table width="100%" border="0"><tr><th>Code</th><th>Representation</th></tr>';
			while ($bob = current($codes)) {
				echo '<tr><td>{'.key($codes)."}</td><td>".$bob."</td></tr>";
				next ($codes);
			}
			echo '</table>';
		}
		else {
			echo "Invalid Skin/Template.";
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function UpdateTemplate() {
		global $DB, $skin, $gcgb;
		// Update Template Files - Check if all fields are there and file exists

		if ($gcgb->input['skin'] AND $gcgb->input['template'] AND $gcgb->input['templatefile']  AND file_exists("skin/".$gcgb->input['skin']."/".$gcgb->input['template'].".html")) {
			// Convert &lt; and &gt; back to < and >
			$templatefile = str_replace ("&lt;", "<", $gcgb->input['templatefile']);
			$templatefile = str_replace ("&gt;", ">", $templatefile);
			$templatefile = str_replace ("&quot;", "\"", $templatefile);

			// Open and Update Template
			$tfile = fopen ("skin/".$gcgb->input['skin']."/".$gcgb->input['template'].".html", "w");
			fwrite ($tfile, $templatefile);
			fclose ($tfile);

			// Log Action
			$DB->query ("INSERT INTO gcgb_logs VALUES('', '3', '".$this->username."', 'Updated \'".$gcgb->input['template']."\' template in skin: ".$gcgb->input['skin']."', '".$_SERVER['REMOTE_ADDR']."');");

			$output = "Template Updated.";
		}
		else {
			$output = "Could not update template.";
		}

		$skin->StartPage("sedit", "Skin Editor");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

}

?>