<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Overview
+ Started: 18th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;

		$skin->StartPage("overview", "Overview");
		$skin->MakeMenu($acppermissions);

		// If just logged in say its successful.
		if ($gcgb->input['login']) {
			echo '<strong>Login Successful!</strong><br /><br />';
		}

		echo 'Welcome to your Administration Panel. From here, you can manage your guestbook, including adding emotions and word filters, managing guestbook entries, and changing the look of your guestbook.<br /><br />';
		
		$DB->query ("SELECT * FROM gcgb_stats");
		$row = $DB->fetch_array();

		if ($row['queued'] > "0") {
			$row['queued'] = '<span style="color: red; font-weight: bold;">'.$row['queued'].'</span>';
		}

		echo '<table class="infotable" width="100%"><tr><th colspan="2">Guestbook Statistics</th></tr><tr><td>Total Entries</td><td>'.$row['entries'].'</td></tr><tr><td>Queued Entries</td><td>'.$row['queued'].'</td></tr></table><br />';

		echo '<table class="infotable" width="100%"><tr><th colspan="2">Quick Clicks</th></tr>';
		if ($this->permissions['edit_config']) {
			echo '<tr><td><a href="'.$gcgb->baseurl.'?a=basic">Basic Guestbook Config</a></td><td><a href="'.$gcgb->baseurl.'?a=wordfilter">Add Word Filters</a></td></tr>';
		}
		if ($this->permissions['edit_entries']) {
			echo '<tr><td><a href="'.$gcgb->baseurl.'?a=manage">Manage Existing Entries</a></td><td><a href="'.$gcgb->baseurl.'?a=approve">Approve Queued Entries</a></td></tr>';
		}
		if ($this->permissions['edit_skin']) {
			echo '<tr><td><a href="'.$gcgb->baseurl.'?a=sselect">Select Guestbook Skin</a></td><td><a href="'.$gcgb->baseurl.'?a=sstyle">Edit CSS</a></td></tr>';
		}
		if ($this->permissions['edit_admins']) {
			echo '<tr><td><a href="'.$gcgb->baseurl.'?a=adminadd">Add Guestbook Administrator</a></td><td><a href="'.$gcgb->baseurl.'?a=adminmanage">Edit Admins</a></td></tr>';
		}
		echo '</table><br />';

		if ($this->permissions['edit_logs']) {
			// Last 5 Admin Actions
			echo '<table class="infotable" width="100%"><tr><th colspan="3">Most Recent Admin Actions</th></tr><tr class="logtop"><td>Administrator</td><td width="300">Action</td><td>IP Address</td></tr>';
			$DB->query("SELECT type, user, action, ip FROM gcgb_logs ORDER BY id DESC LIMIT 0,5");
			while ($row = $DB->fetch_array()) {
				switch ($row['type']) {
					case '1':
						$color = "#0410B0";
					break;
					case '2':
						$color = "#357F03";
					break;
					case '3':
						$color = "#BB1403";
					break;
					case '4':
						$color = "#FF7F01";
					break;
					case '5':
						$color = "#800080";
					break;
				}
				echo '<tr class="logc"><td>'.$row['user'].'</td><td style="color: '.$color.'">'.$row['action'].'</td><td>'.$row['ip'].'</td></tr>';
			}
			echo '</table><br />';
		}

		// Latest Global Centre News
		echo '<table class="infotable" width="100%"><tr><th colspan="2">Global Centre Latest</th></tr><tr><td><script type="text/javascript"  src="http://www.global-centre.com/services/scripts/latest.php?p=guestbook&v=100rc2"></script></td></tr></table>';
		
		$skin->EndTable();
		$skin->EndPage();
	}
}

?>