<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Entries Management
+ Started: 23rd June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_entries']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowAll();
				break;
				case '01':
					$this->EditEntry();
				break;
				case '02':
					$this->AddReply();
				break;
				case '03':
					$this->UpdateEntry();
				break;
				case '04':
					$this->DoAddReply();
				break;
				case '05':
					$this->DeleteEntry();
				break;
				default:
					$this->ShowAll();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowAll() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);

		// Show all of the wubbably entries and wubbable options and l33t entry info
		// and that crazy stuff
		if ($gcgb->config['newattop']) {
			$order = "ORDER BY time DESC";
		}
		else {
			$order = "ORDER BY time";
		}

		// Get the entries and display stuff one by one. No queued, No Evil Things.
		$DB->query ("SELECT * FROM gcgb_entries WHERE queued='0' ".$order);
		while ($row = $DB->fetch_array()) {
			$aet = $row['reply'] ? "Edit" : "Add";
			$row['reply'] = $row['reply'] ? $row['reply'] : "(none)";
			$row['hideemail'] = $row['hideemail'] ? "Yes" : "No";
			$row['private'] = $row['private'] ? "Yes" : "No";
			echo '<table width="100%" cellspacing="0"><tr class="formsec"><td>Posted by <a href="'.$row['email'].'">'.$row['name'].'</a></td><td style="text-align: right;"><a href="'.$gcgb->baseurl.'?a=manage'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Edit Entry</a> | <a href="'.$gcgb->baseurl.'?a=manage'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'id='.$row['id'].'">'.$aet.' Reply</a> | <a href="'.$gcgb->baseurl.'?a=manage'.$gcgb->config['queryseperator'].'code=05'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Remove Entry</a>&nbsp;</td></tr><tr><td colspan="2">'.$row['comments'].'<br /><br /><span style="font-size: 8pt;">Reply: '.$row['reply'].'<br />Hide Email? '.$row['hideemail'].'<br />Private Entry? '.$row['private'].'<br />IP: '.$row['ip'].'<br />Time: '.date($gcgb->config['timeformat'], $row['time']).'</span></td></tr></table>';
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function EditEntry() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);

		// Check for ID
		if ($gcgb->input['id']) {
			$DB->query ("SELECT * FROM gcgb_entries WHERE id='".$gcgb->input['id']."';");
			if ($DB->num_rows()) {
				$row = $DB->fetch_array();
				
				echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="manage" /><input type="hidden" name="code" value="03" /><input type="hidden" name="id" value="'.$row['id'].'" /><table border="0" width="100%"><tr><td><strong>Name:</strong></td><td><input type="text" name="name" value="'.$row['name'].'" /></td></tr><tr><td><strong>E-Mail Address:</strong></td><td><input type="text" name="email" value="'.$row['email'].'" /></td></tr><tr><td valign="top"><strong>Comments:</strong></td><td><textarea rows="8" style="width: 350px;" name="comments">'.$row['comments'].'</textarea></td></tr><tr><td>&nbsp;</td><td><input type="checkbox" name="hideemail"'.($row['hideemail'] ? ' checked="checked"' : '').' value="1" /> <strong>Tick</strong> to hide e-mail address.</td></tr><tr><td>&nbsp;</td><td><input type="checkbox" name="hidden"'.($row['private'] ? ' checked="checked"' : '').' value="1" /> <strong>Tick</strong> to make this message private.</td></tr></table><input type="Submit" value="Update Entry" /></form>You can use <strong>HTML</strong> when editing messages.<br />The Word Filter is <strong>not active</strong> for Administrative Edits.';
			}
			else {
				echo "Entry not found.";
			}
		}
		else {
			echo "No entry specified.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function AddReply() {
		global $DB, $skin, $gcgb;
	
		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);

		// This bit of code does Edit Reply too. Just AddOrEditReply() wasn't a good function name. :P

		// Check for ID
		if ($gcgb->input['id']) {
			$DB->query ("SELECT reply FROM gcgb_entries WHERE id='".$gcgb->input['id']."';");
			if ($DB->num_rows()) {
				$row = $DB->fetch_array();
				echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="manage" /><input type="hidden" name="code" value="04" /><input type="hidden" name="id" value="'.$gcgb->input['id'].'" /><table border="0" width="100%"><tr><td valign="top"><strong>Reply:</strong></td><td><textarea name="reply" cols="50" rows="5">'.$row['reply'].'</textarea></td></tr></table><input type="Submit" value="Add/Edit Reply" /></form>';
			}
			else {
				echo "Entry not found.";
			}
		}
		else {
			echo "No entry specified.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}
	
	function UpdateEntry() {
		global $DB, $skin, $gcgb;
	
		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);
		
		if ($gcgb->input['id'] AND $gcgb->input['name'] AND $gcgb->input['email'] AND $gcgb->input['comments']) {
			// Hide Email and Private Things
			$hideemail = $gcgb->input['hideemail'] ? "1" : "0";
			$private = $gcgb->input['private'] ? "1" : "0";
		
			// Updatey
			$DB->query("UPDATE gcgb_entries SET name='".$gcgb->input['name']."',  email='".$gcgb->input['email']."',  comments='".nl2br($gcgb->input['comments'])."',  hideemail='".$hideemail."',  private='".$private."' WHERE id='".$gcgb->input['id']."';");

			if ($DB->affected_rows()) {
			
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '2', '".$this->username."', 'Modified a Guestbook Entry.', '".$_SERVER['REMOTE_ADDR']."');");
			
				echo "Entry Modified";
			}
			else {
				echo "Could not update.";
			}
		}
		else {
			echo "One or more fields were left blank.";
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function DoAddReply() {
		global $DB, $skin, $gcgb;
	
		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['id']) {
			// Updatey
			$DB->query("UPDATE gcgb_entries SET reply='".$gcgb->input['reply']."' WHERE id='".$gcgb->input['id']."';");

			if ($DB->affected_rows()) {
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '2', '".$this->username."', 'Replied to a Guestbook Entry.', '".$_SERVER['REMOTE_ADDR']."');");

				echo "Added/Edited Reply.";
			}
			else {
				echo "Could not update.";
			}	
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DeleteEntry() {
		global $DB, $skin, $gcgb;
	
		$skin->StartPage("manage", "Manage Entries");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['id']) {
			// Nukey
			$DB->query("DELETE FROM gcgb_entries  WHERE id='".$gcgb->input['id']."';");

			if ($DB->affected_rows()) {
				// Update Statistics
				$DB->query ("UPDATE gcgb_stats SET entries=entries-1, approved=approved-1");

				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '2', '".$this->username."', 'Removed a Guestbook Entry.', '".$_SERVER['REMOTE_ADDR']."');");

				echo "Removed Entry.";
			}
			else {
				echo "Could not update.";
			}	
		}
	}
}

?>