<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Mage Help Files Module
+ Started: 10th August 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_help']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowAll();
				break;
				case '01':
					$this->EditHelp();
				break;
				case '02':
					$this->DoEditHelp();
				break;
				case '03':
					$this->Delete();
				break;
				default:
					$this->ShowAll();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowAll() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpmanage", "Manage Help Files");
		$skin->MakeMenu($this->permissions);

		$DB->query ("SELECT id, author, title, description FROM gcgb_help ORDER BY title");
		while ($row = $DB->fetch_array()) {
			echo '<table width="100%" cellspacing="0"><tr class="formsec"><td>'.$row['title'].'</td><td align="right" nowrap="nowrap"><a href="'.$gcgb->baseurl.'?a=helpmanage&code=01&help='.$row['id'].'">Modify</a> | <a href="'.$gcgb->baseurl.'?a=helpmanage&code=03&help='.$row['id'].'">Delete</a>&nbsp;</td></tr><tr><td><strong>Description:</strong> '.$row['description'].'<br /><strong>Author:</strong> '.$row['author'].'</td></tr></table>';
		}

		echo '<p><a href="'.$gcgb->baseurl.'?a=helpadd">Add Help File</a></p>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function EditHelp() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpmanage", "Manage Help Files");
		$skin->MakeMenu($this->permissions);

		$DB->query ("SELECT id, author, title, description, text FROM gcgb_help WHERE id='".$gcgb->input['help']."';");
		if ($row = $DB->fetch_array()) {
			echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="helpmanage" /><input type="hidden" name="code" value="02" /><input type="hidden" name="help" value="'.$gcgb->input['help'].'" /><table width="100%">'.$skin->FormTitle("Help File Information").$skin->BuildField("Help File Title:", "title", $row['title']).$skin->BuildField("Help File Author:", "author", $row['author']).$skin->BuildField("Help File Description:", "description", $row['description']).$skin->FormTitle("Help File Text").$skin->BuildTextArea("Help File:", "helpfile", $row['text'], "HTML <strong>Enabled</strong>").'</table><input type="Submit" value="Edit Help File" /></form>';
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoEditHelp() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpmanage", "Manage Help Files");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['help'] AND $gcgb->input['title'] AND $gcgb->input['author'] AND $gcgb->input['description'] AND $gcgb->input['helpfile']) {
			// Change stuff back to HTML things
			$helpfile = str_replace ("&lt;", "<", $gcgb->input['helpfile']);
			$helpfile = str_replace ("&gt;", ">", $helpfile);
			$helpfile = str_replace ("&quot;", "\"", $helpfile);

			// Update in Database
			$DB->query ("UPDATE gcgb_help SET author='{$gcgb->input['author']}', title='{$gcgb->input['title']}', description='{$gcgb->input['description']}', text='{$helpfile}' WHERE id='".$gcgb->input['help']."' LIMIT 1;");
			if ($DB->affected_rows()) {
				// Log it :D
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '5', '".$this->username."', 'Modified Help File', '".$_SERVER['REMOTE_ADDR']."');");

				echo $skin->ActionSuccess("Help File updated.", "Manage Help Files", "helpmanage");
			}
			else {
				echo $skin->ActionFailiure("Could not update help file.", "Manage Help Files", "helpmanage");
			}
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function Delete() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpmanage", "Manage Help Files");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['help']) {
			$DB->query ("DELETE FROM gcgb_help WHERE id='".$gcgb->input['help']."';");

			if ($DB->affected_rows()) {
				// Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '5', '".$this->username."', 'Deleted Help File', '".$_SERVER['REMOTE_ADDR']."');");

				echo $skin->ActionSuccess("Help File deleted!", "Manage Help Files", "helpmanage");
			}
			else {
				echo $skin->ActionFailiure("Could not delete help file.", "Manage Help Files", "helpmanage");
			}
		}
		else {
			echo $skin->ActionFailiure("No Help File ID specified.", "Manage Help Files", "helpmanage");
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

?>