<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Add Help File Module
+ Started: 8th August 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_help']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->AddForm();
				break;
				case '01':
					$this->DoAdd();
				break;
				default:
					$this->AddForm();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function AddForm() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpadd", "Add Help File");
		$skin->MakeMenu($this->permissions);

		echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="helpadd" /><input type="hidden" name="code" value="01" /><table width="100%">'.$skin->FormTitle("Help File Information").$skin->BuildField("Help File Title:", "title").$skin->BuildField("Help File Author:", "author", $this->username).$skin->BuildField("Help File Description:", "description").$skin->FormTitle("Help File Text").$skin->BuildTextArea("Help File:", "helpfile", "", "HTML <strong>Enabled</strong>").'</table><input type="Submit" value="Add Help File" /></form>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function DoAdd() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("helpadd", "Add Help File");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['title'] AND $gcgb->input['author'] AND $gcgb->input['description'] AND $gcgb->input['helpfile']) {

			// Change stuff back to HTML things
			$helpfile = str_replace ("&lt;", "<", $gcgb->input['helpfile']);
			$helpfile = str_replace ("&gt;", ">", $helpfile);
			$helpfile = str_replace ("&quot;", "\"", $helpfile);

			$DB->query ("INSERT INTO gcgb_help (author, title, description, text) VALUES ('{$gcgb->input['author']}', '{$gcgb->input['title']}', '{$gcgb->input['description']}', '{$helpfile}');");

			if ($DB->affected_rows()) {
				// Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '5', '".$this->username."', 'Added Help File', '".$_SERVER['REMOTE_ADDR']."');");

				echo $skin->ActionSuccess("Help File added!", "Add Help File", "helpadd");
			}
			else {
				echo $skin->ActionFailiure("Could not add help file.", "Add Help File", "helpadd");
			}
		}
		else {
			echo $skin->ActionFailiure("One of the required fields were left blank.", "Add Help File", "helpadd");
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

?>