<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Emoticons Module
+ Started: 21st June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_config']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowEmos();
				break;
				case '01':
					$this->AddEmo();
				break;
				case '02':
					$this->RemoveEmo();
				break;
				case '03':
					$this->EditEmo();
				break;
				case '04':
					$this->NoEmo();
				break;
				case '05':
					$this->DoAddEmo();
				break;
				case '06':
					$this->DoEditEmo();
				break;
				default:
					$this->ShowEmos();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowEmos() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);

		echo '<table width="100%"><tr><th>Code</th><th>Emoticon</th><th>Operations</th></tr>';
		$DB->query ("SELECT id, find, rep FROM gcgb_filters WHERE is_emo='1'");
		while ($row = $DB->fetch_array()) {
			echo '<tr class="logc"><td>'.$row['find'].'</td><td><img src="'.$gcgb->config['smileyfolder']."/".$row['rep'].'" /></td><td><a href="'.$gcgb->baseurl.'?a=emoticons'.$gcgb->config['queryseperator'].'code=03'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Modify</a> | <a href="'.$gcgb->baseurl.'?a=emoticons'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Remove</a></td></tr>';
		}
		echo '</table><br /><a href="'.$gcgb->baseurl.'?a=emoticons'.$gcgb->config['queryseperator'].'code=01">Add Emoticon</a>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function AddEmo() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);
		
		// Form to Add Emotion
		echo '<form name="addemo" action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="emoticons" /><input type="hidden" name="code" value="05" /><strong>Add Emoticon</strong><br /><br /><table width="100%" border="0"><tr><td width="75">Code</td><td><input type="text" name="find" maxlength="8" size="8" /></td><td rowspan="2" width="150" class="logc" valign="top"><strong>Emoticon Preview</strong><br /><img name="emopreview" src="script/blank.gif" onError="this.src=\''.$gcgb->baseurl.'?a=emoticons'.$gcgb->config['queryseperator'].'code=04\';" /></td></tr><tr><td width="75">Emoticon</td><td>'.$gcgb->config['smileyfolder'].'/ <input type="text" name="emoticon" onChange="document.emopreview.src=\''.$gcgb->config['smileyfolder'].'/\' + this.value;" /></td></tr></table><input type="Submit" value="Add Emoticon" /></form>Emoticons should be situated in the folder <strong>'.$gcgb->config['smileyfolder'].'</strong>.';

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoAddEmo() {
		global $DB, $skin, $gcgb;

		// Add a likkle emoticon thing
		$output = "";

		if (!$gcgb->input['find'] OR !$gcgb->input['emoticon']) {
			$output .= "One of the Required Fields was left blank.";
		}
		else if (!file_exists($gcgb->config['smileyfolder']."/".$gcgb->input['emoticon'])) {
			$output .= "The emoticon specified could not be found.";
		}
		else {
			// See if Emo with code already exists
			$DB->query ("SELECT id FROM gcgb_filters WHERE is_emo='1' AND find='".$gcgb->input['find']."';");
			if ($DB->fetch_array()) {
				// Emoticon with code already exists. Make Error.
				
				$output .= "An emoticon with that code already exists.";
			}
			else {				
				// Insert Smiley into Database
				$DB->query("INSERT INTO gcgb_filters VALUES ('', '".$gcgb->input['find']."', '".$gcgb->input['emoticon']."', '1');");
				
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Added a Emoticon to the Database', '".$_SERVER['REMOTE_ADDR']."');");
				
				$output .= "Smiley Added.";
			}
		}

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

	function RemoveEmo() {
		global $DB, $skin, $gcgb;
		if ($gcgb->input['id']) {
			// Attempt to remove Emoticon
			$DB->query ("DELETE FROM gcgb_filters WHERE is_emo='1' AND id='".$gcgb->input['id']."' LIMIT 1");
			if ($DB->affected_rows()) {
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Removed a Emoticon to the Database', '".$_SERVER['REMOTE_ADDR']."');");
				$output = "Emoticon removed.";
			}
			else {
				$output = "Could not remove emoticon.";
			}
		}
		else {
			$output = "Could not remove emoticon.";
		}

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

	function EditEmo() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);

		if ($gcgb->input['id']) {
			$DB->query("SELECT find, rep FROM gcgb_filters WHERE id='".$gcgb->input['id']."' AND is_emo='1';");
			if ($row = $DB->fetch_array()) {

				// Form to Edit Emotion
				echo '<form name="editemo" action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="emoticons" /><input type="hidden" name="code" value="06" /><input type="hidden" name="id" value="'.$gcgb->input['id'].'"><strong>Edit Emoticon</strong><br /><br /><table width="100%" border="0"><tr><td width="75">Code</td><td><input type="text" name="find" value="'.$row['find'].'" maxlength="8" size="8" /></td><td rowspan="2" width="150" class="logc" valign="top"><strong>Emoticon Preview</strong><br /><img name="emopreview" src="'.$gcgb->config['smileyfolder'].'/'.$row['rep'].'" onError="this.src=\''.$gcgb->baseurl.'?a=emoticons'.$gcgb->config['queryseperator'].'code=04\';" /></td></tr><tr><td width="75">Emoticon</td><td>'.$gcgb->config['smileyfolder'].'/ <input type="text" name="emoticon" onChange="document.emopreview.src=\''.$gcgb->config['smileyfolder'].'/\' + this.value;" value="'.$row['rep'].'"/></td></tr></table><input type="Submit" value="Edit Emoticon" /></form>Emoticons should be situated in the folder <strong>'.$gcgb->config['smileyfolder'].'</strong>.';
			}
			else {
				echo "No/Invalid Emoticon Specified.";
			}
		}
		else {
			echo "No/Invalid Emoticon Specified.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function DoEditEmo() {
		global $DB, $skin, $gcgb;

		// Add a likkle emoticon thing
		$output = "";

		if (!$gcgb->input['find'] OR !$gcgb->input['emoticon'] OR !$gcgb->input['id']) {
			$output .= "One of the Required Fields was left blank.";
		}
		else if (!file_exists($gcgb->config['smileyfolder']."/".$gcgb->input['emoticon'])) {
			$output .= "The emoticon specified could not be found.";
		}
		else {
			// See if Emo with code already exists
			$DB->query ("SELECT id FROM gcgb_filters WHERE is_emo='1' AND find='".$gcgb->input['find']."' AND id !='".$gcgb->input['id']."';");
			if ($DB->fetch_array()) {
				// Emoticon with code already exists. Make Error.
				
				$output .= "An emoticon with that code already exists.";
			}
			else {				
				// Update Smiley into Database
				$DB->query("UPDATE gcgb_filters SET find='".$gcgb->input['find']."',  rep='".$gcgb->input['emoticon']."' WHERE id='".$gcgb->input['id']."';");
		
				// Insert Log
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', 'Modified a Emoticon to the Database', '".$_SERVER['REMOTE_ADDR']."');");
				
				$output .= "Emoticon Updated.";
			}
		}

		$skin->StartPage("emoticons", "Emoticons");
		$skin->MakeMenu($this->permissions);

		echo $output;

		$skin->EndTable();
		$skin->EndPage();
	}

	function NoEmo() {
		// No Emotion - Generate Image
		header ("Content-type: image/gif");
		echo base64_decode ("R0lGODlhTwAdAPcAAAAAAP///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////ywAAAAATwAdAAAI/gADCBwYAIBBAAUHIixoUODBhgcdNpS4cGFCghYrTnxokaDHjgxDZlSI0SHJkRs/VrzIEqRHjA8TIpxJ0mRNkChlftQ50ubLlzhP1mR5MadJjTtFDnX5kyJNmxGXbpzIcKVPnxo7Mm3KtavXr2DDig0bsyrWllW3jl3bNejRkyt7sp3rlSPanDTl0t0LNKnOt0qv8h1MlKLClEejEl7MuLHjx5AjS55MubLly5gza6YctWfZzkMPQ7w5NWJnqqAlCgW8tGhfmIHR3lwtEylM0zFxUr09Om/r2SXfzjT6t7XV4MZ/Q6X9FCLioqePu8xNWqtow9j1bt4+lnrirMOjHqu9PF02U+3cnerNuFvrbu7l0aMvvN177fDWnRIOCAA7");
	}
	
}

?>