<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Database Settings Module
+ Started: 20th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();
	var $sqlconfig = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_config']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->Form();
				break;
				case '01':
					$this->Update();
				break;
				default:
					$this->Form();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function BuildField($name, $value) {
		global $gcgb;
		return '<tr><td>'.$name.'</td><td width="250"><input type="text" name="dbn_'.$value.'" size="40" value="'.$this->sqlconfig[$value].'" /></td></tr>';
	}

	function BuildPassword($name, $value) {
		global $gcgb;
		return '<tr><td>'.$name.'</td><td width="250"><input type="password" name="dbn_'.$value.'" size="40" /></td></tr>';
	}

	function BuildDriver($name, $value) {
		global $gcgb;

		// Open Drivers Folder and List All Drivers
		$dir = opendir ("sources/drivers");
		while (($file = readdir($dir)) !== false) { 
			if ($file != "." AND $file != "..") {
				$driver = explode (".", $file);
				$dropdown .= '<option value="'.$driver['0'].'">'.$driver['0'].'</option>'; 
			}
		}   
		closedir ($dir);
		return '<tr><td>'.$name.'</td><td width="250"><select name="dbn_driver">'.$dropdown.'</select></td></tr>';
	}

	function IsField($value) {
		global $gcgb;
		if ($gcgb->input[$value] AND $gcgb->input[$value] != "") {
			return true;
		}
		else {
			return false;
		}
	}

	function IsDriver($value) {
		global $gcgb;
		if ($gcgb->input[$value] AND file_exists("sources/drivers/".$gcgb->input[$value].".php")) {
			return true;
		}
		else {
			return false;
		}
	}

	function Form() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("database", "Database Configuration");
		$skin->MakeMenu($this->permissions);

		require ("config.php");
		$this->sqlconfig = $config['sql'];
		unset ($config);

		echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="db" /><input type="hidden" name="code" value="01" /><table width="100%"><tr><th class="formsec" colspan="2">&nbsp;Database Details</th></tr>'.$this->BuildDriver("SQL Driver", "host").$this->BuildField("Host", "host").$this->BuildField("SQL Username", "user").$this->BuildPassword("SQL Password<br />(Leave blank to keep existing)", "password").$this->BuildField("SQL Database", "db").$this->BuildField("SQL Table Prefix", "prefix").'</table><br /><span style="color:red"><strong>WARNING:</strong> These settings should not be changed if your guestbook is currently working. Entering incorrect details will lead to the guestbook not working. Global Centre Guestbook will not create tables for you or move posts, you will have to do this manually.</span><br /><br /><input type="Submit" value="Update Configuration" /></font>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function Update() {
		global $DB, $skin, $gcgb;
		$output = "";

		// Check input
		if ($this->IsField("dbn_host") AND $this->IsField("dbn_user") AND $this->IsField("dbn_db") AND $this->IsField("dbn_prefix") AND $this->IsDriver("dbn_driver")) {

			// Backup Config File just incase :-)
			if (copy ("config.php", "config.backup.php")) {
				$output .= "Configuration File Backed Up. ";
				$log = "; Backup Written";
			}
			else {
				$output .= "Could not create a backup of the configuration file. ";
				$log = "; Could not write Backup";
			}



			// Write Config
			
			require ("config.php");
				
			if (!$fp = fopen ("config.php", "w")) {
				$output .= "Fatal Error: Could not open Configuration File. ";
			}
			else {

				$dbnpassword = $gcgb->input['dbn_password'] ? $gcgb->input['dbn_password'] : $config['sql']['password'];
				// Its messy, I know...
				$configfile = <<<EOC
<?php
\$config['sql']['driver'] = "{$gcgb->input['dbn_driver']}";
\$config['sql']['host'] = "{$gcgb->input['dbn_host']}";
\$config['sql']['user'] = "{$gcgb->input['dbn_user']}";
\$config['sql']['password'] = "{$dbnpassword}";
\$config['sql']['db'] = "{$gcgb->input['dbn_db']}";
\$config['sql']['prefix'] = "{$gcgb->input['dbn_prefix']}";

\$config['sitename'] = "{$config['sitename']}";
\$config['siteurl'] = "{$config['siteurl']}";
\$config['adminemail'] = "{$config['adminemail']}";

\$config['offline'] = "{$config['offline']}";
\$config['offline_msg'] = "{$config['offline_msg']}";
\$config['scriptname'] = "{$config['scriptname']}";
\$config['adminscriptname'] = "{$config['adminscriptname']}";
\$config['queryseperator'] = "{$config['queryseperator']}";

\$config['perpage'] = "{$config['perpage']}";
\$config['newattop'] = "{$config['newattop']}";
\$config['hideip'] = "{$config['hideip']}";
\$config['hideemail'] = "{$config['hideemail']}";
\$config['moderate'] = "{$config['moderate']}";

\$config['allow_html'] = "{$config['allow_html']}";
\$config['allow_gccode'] = "{$config['allow_gccode']}";

\$config['gzip'] = "{$config['gzip']}";
\$config['timeformat'] = "{$config['timeformat']}";
\$config['smileyfolder'] = "{$config['smileyfolder']}";

\$config['skin'] = "{$config['skin']}";
?>
EOC;
				
				if (fwrite ($fp, $configfile)) {
					$output .= "Configuration File Updated. ";
				}
				else {
					$output .= "Update Failed. ";
				}
				fclose ($fp);

				// Now finally add changes to log
				$logc = "Database Settings Updated".$log;
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '1', '".$this->username."', '".$logc."', '".$_SERVER['REMOTE_ADDR']."');");
			}

$output .= "<br /><br />The next page load will use the new Database settings. If pages do not load, or you get a mySQL connection error, restore the configuration backup by removing config.php, and renaming config.backup.php to config.php.";
		}
		else {
			$output .= "<p>One or more field(s) were either left blank, or contained an invalid value. Please go back and rectify these problems.</p>";
		}

		$skin->StartPage("basic", "Basic Configuration");
		$skin->MakeMenu($this->permissions);

		echo '<p>'.$output.'</p>';

		$skin->EndTable();
		$skin->EndPage();
	}
}

// Thats all folks!

?>