<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Configuration Module
+ Started: 19th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_config']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->Form();
				break;
				case '01':
					$this->Update();
				break;
				default:
					$this->Form();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function BuildField($name, $value) {
		global $gcgb;
		return '<tr><td>'.$name.'</td><td width="250"><input type="text" name="'.$value.'" size="40" value="'.$gcgb->config[$value].'" /></td></tr>';
	}

	function BuildRadio($name, $value) {
		global $gcgb;
		if ($gcgb->config[$value] == "1") {
			$select1 = ' checked="checked"';
		}
		else {
			$select0 = ' checked="checked"';
		}
		return '<tr><td>'.$name.'</td><td width="250"><input type="radio" name="'.$value.'" value="1"'.$select1.' />Yes <input type="radio" name="'.$value.'" value="0"'.$select0.' /> No</td></tr>';
	}

	function IsField($value) {
		global $gcgb;
		if ($gcgb->input[$value] AND $gcgb->input[$value] != "") {
			return true;
		}
		else {
			return false;
		}
	}

	function IsRadio($value) {
		global $gcgb;
		if ($gcgb->input[$value] == "1" OR $gcgb->input[$value] == "0") {
			return true;
		}
		else {
			return false;
		}
	}

	function IsNumber($value) {
		global $gcgb;
		if (is_numeric($gcgb->input[$value])) {
			return true;
		}
		else {
			return false;
		}
	}

	function Form() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("basic", "Basic Configuration");
		$skin->MakeMenu($this->permissions);

		echo '<form action="'.$gcgb->baseurl.'" method="post"><input type="hidden" name="a" value="basic" /><input type="hidden" name="code" value="01" /><table width="100%"><tr><th class="formsec" colspan="2">&nbsp;Site Information</th></tr>'.$this->BuildField("Site Name", "sitename").$this->BuildField("Site URL", "siteurl").$this->BuildField("Administrator's Email Address", "adminemail").'<tr><th class="formsec" colspan="2">&nbsp;Guestbook Settings</th></tr>'.$this->BuildRadio("Offline?", "offline").$this->BuildField("Offline Message", "offline_msg").$this->BuildField("Script Filename", "scriptname").$this->BuildField("Admin Script Filename", "adminscriptname").$this->BuildField("Query String Value Seperator", "queryseperator").'<tr><th class="formsec" colspan="2">&nbsp;Display Options</th></tr>'.$this->BuildField("Default entries per page", "perpage").$this->BuildRadio("New Entries at Top?", "newattop").$this->BuildRadio("Hide IP Addresses?", "hideip").$this->BuildRadio("Hide E-Mail Addresses by default?", "hideemail").$this->BuildRadio("Moderate all entries before shown?", "moderate").'<tr><th class="formsec" colspan="2">&nbsp;Posting Options</th></tr>'.$this->BuildRadio("Allow HTML in Entries?", "allow_html").$this->BuildRadio("Allow GCCode in Entries?", "allow_gccode").'<tr><th class="formsec" colspan="2">&nbsp;Other Options</th></tr>'.$this->BuildRadio("GZip Pages?", "gzip").$this->BuildField("Time Format (Same as <a href=\"http://www.php.net/date\">PHP Date</a>)", "timeformat").$this->BuildField("Smileys Folder", "smileyfolder").'</table><br /><input type="Submit" value="Update Configuration" /></font>';
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function Update() {
		global $DB, $skin, $gcgb;
		$output = "";

		$skin->StartPage("basic", "Basic Configuration");
		$skin->MakeMenu($this->permissions);

		// Check input
		if ($this->IsField("sitename") AND $this->IsField("siteurl") AND $this->IsField("adminemail") AND $this->IsRadio("offline") AND $this->IsField("offline_msg") AND $this->IsField("scriptname") AND $this->IsField("adminscriptname") AND $this->IsField("queryseperator") AND $this->IsNumber("perpage") AND $this->IsRadio("newattop") AND $this->IsRadio("hideip") AND $this->IsRadio("hideemail") AND $this->IsRadio("moderate") AND $this->IsRadio("allow_html") AND $this->IsRadio("allow_gccode") AND $this->IsRadio("gzip")  AND $this->IsField("timeformat") AND $this->IsField("smileyfolder")) {
			// Backup Config :-)
			if (@copy ("config.php", "config.backup.php")) {
				$output .= "Configuration File Backed Up. ";
				$log = "; Backup Written";
			}
			else {
				$output .= "Could not create a backup of the configuration file. ";
				$log = "; Could not write Backup";
			}

			// Write Config
			
			require ("config.php");
				
			if (!$fp = @fopen ("config.php", "w")) {
				echo $skin->ActionFailiure("Could not open Configuration File.", "Basic Configuration", "nasic");
			}
			else {
				// Its messy, I know...
				$configfile = <<<EOC
<?php
\$config['sql']['driver'] = "{$config['sql']['driver']}";
\$config['sql']['host'] = "{$config['sql']['host']}";
\$config['sql']['user'] = "{$config['sql']['user']}";
\$config['sql']['password'] = "{$config['sql']['password']}";
\$config['sql']['db'] = "{$config['sql']['db']}";
\$config['sql']['prefix'] = "{$config['sql']['prefix']}";

\$config['sitename'] = "{$gcgb->input['sitename']}";
\$config['siteurl'] = "{$gcgb->input['siteurl']}";
\$config['adminemail'] = "{$gcgb->input['adminemail']}";

\$config['offline'] = "{$gcgb->input['offline']}";
\$config['offline_msg'] = "{$gcgb->input['offline_msg']}";
\$config['scriptname'] = "{$gcgb->input['scriptname']}";
\$config['adminscriptname'] = "{$gcgb->input['adminscriptname']}";
\$config['queryseperator'] = "{$gcgb->input['queryseperator']}";

\$config['perpage'] = "{$gcgb->input['perpage']}";
\$config['newattop'] = "{$gcgb->input['newattop']}";
\$config['hideip'] = "{$gcgb->input['hideip']}";
\$config['hideemail'] = "{$gcgb->input['hideemail']}";
\$config['moderate'] = "{$gcgb->input['moderate']}";

\$config['allow_html'] = "{$gcgb->input['allow_html']}";
\$config['allow_gccode'] = "{$gcgb->input['allow_gccode']}";

\$config['gzip'] = "{$gcgb->input['gzip']}";
\$config['timeformat'] = "{$gcgb->input['timeformat']}";
\$config['smileyfolder'] = "{$gcgb->input['smileyfolder']}";

\$config['skin'] = "{$config['skin']}";
?>
EOC;
				
				if (fwrite ($fp, $configfile)) {

				// Now finally add changes to log
				$DB->query ("INSERT INTO gcgb_logs VALUES ('', '1', '".$this->username."', 'Board Settings Updated".$log."', '".$_SERVER['REMOTE_ADDR']."');");

				echo $skin->ActionSuccess("Board Settings Updated".$log, "Basic Configuration", "basic");
				}
				else {
					echo $skin->ActionFailiure("Could not update guestbook configuration.", "Basic Configuration", "basic");
				}
				fclose ($fp);
			}
		}
		else {
			echo $skin->ActionFailiure("One or more field(s) were either left blank, or contained an invalid value. Please go back and rectify these problems.", "Basic Configuration", "nasic");
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

// Thats all folks!

?>