<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Approve/Reject Moderated Entries
+ Started: 26th June 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions
		if ($this->permissions['edit_entries']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowAll();
				break;
				case '01':
					$this->ApproveEntry();
				break;
				case '02':
					$this->RejectEntry();
				break;
				default:
					$this->ShowAll();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowAll() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("approve", "Approve Entries");
		$skin->MakeMenu($this->permissions);

		// Show all of the wubbably entries and wubbable options and l33t entry info
		// and that crazy stuff
		if ($gcgb->config['newattop']) {
			$order = "ORDER BY time DESC";
		}
		else {
			$order = "ORDER BY time";
		}

		// Get the entries and display stuff one by one. No queued, No Evil Things.
		$DB->query ("SELECT * FROM gcgb_entries WHERE queued='1' ".$order);
		if ($DB->num_rows()) {
			while ($row = $DB->fetch_array()) {
				$row['hideemail'] = $row['hideemail'] ? "Yes" : "No";
				$row['private'] = $row['private'] ? "Yes" : "No";
				echo '<table width="100%" cellspacing="0"><tr class="formsec"><td>Posted by <a href="'.$row['email'].'">'.$row['name'].'</a></td><td style="text-align: right;"><a href="'.$gcgb->baseurl.'?a=approve'.$gcgb->config['queryseperator'].'code=01'.$gcgb->config['queryseperator'].'id='.$row['id'].'">Approve Entry</a> | <a href="'.$gcgb->baseurl.'?a=approve'.$gcgb->config['queryseperator'].'code=02'.$gcgb->config['queryseperator'].'id='.$row['id'].'"> Reject Entry</a>&nbsp;</td></tr><tr><td colspan="2">'.$row['comments'].'<br /><br /><span style="font-size: 8pt;">Hide Email? '.$row['hideemail'].'<br />Private Entry? '.$row['private'].'<br />IP: '.$row['ip'].'<br />Time: '.date($gcgb->config['timeformat'], $row['time']).'</span></td></tr></table>';
			}
		}
		else {
			echo "No entries to moderate.";
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function ApproveEntry() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("approve", "Approve Entries");
		$skin->MakeMenu($this->permissions);

		// Check for ID
		if ($gcgb->input['id']) {
			$DB->query ("UPDATE gcgb_entries SET queued='0' WHERE id='".$gcgb->input['id']."' AND queued='1'");
			if ($DB->affected_rows()) {
				// Update Stats, Logs, and Display Message if Approved.
				$DB->query ("UPDATE gcgb_stats SET approved=approved+1, queued=queued-1");
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '2', '".$this->username."', 'Approved a Guestbook Entry.', '".$_SERVER['REMOTE_ADDR']."');");
				echo "Entry Approved.";
			}
			else {
				echo "Could not approve entry.";
			}
		}
		else {
			echo "One or more fields were left blank.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}

	function RejectEntry() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("approve", "Approve Entries");
		$skin->MakeMenu($this->permissions);

		// Check for ID
		if ($gcgb->input['id']) {
			$DB->query ("DELETE FROM gcgb_entries WHERE id='".$gcgb->input['id']."' AND queued='1' LIMIT 1");
			if ($DB->affected_rows()) {
				// Everything
				$DB->query ("UPDATE gcgb_stats SET entries=entries-1, queued=queued-1");
				$DB->query ("INSERT INTO gcgb_logs VALUES('', '2', '".$this->username."', 'Rejected a Guestbook Entry.', '".$_SERVER['REMOTE_ADDR']."');");
				echo "Entry Rejected.";
			}
			else {
				echo "Could not reject entry.";
			}
		}
		else {
			echo "One or more fields were left blank.";
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

?>