<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Add Help File Module
+ Started: 8th August 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

class Module {
	var $username;
	var $permissions = array();

	function Module() {
		global $acppermissions, $DB, $skin, $gcgb;
		
		$this->username = $acppermissions['username'];
		$this->permissions = $acppermissions;
		
		// Check user has permissions to edit configuration
		if ($this->permissions['edit_logs']) {

			switch ($gcgb->input['code']) {
				case '00':
					$this->ShowLogs();
				break;
				case '01':
					$this->ClearLogs();
				break;
				default:
					$this->ShowLogs();
			}
		
		}
		else {
			fatal_error("", "You do not have the required permissions to view this page.", "", "", "", "Permissions");
		}
	}

	function ShowLogs() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminlogs", "Admin Logs");
		$skin->MakeMenu($this->permissions);

		$start = $gcgb->input['start'] ? intval($gcgb->input['start']) : "0";

		$DB->query ("SELECT type, user, action, ip FROM gcgb_logs WHERE type='1' OR type='2' OR type='3' OR type='4' OR type='5' ORDER BY id DESC LIMIT ".$start.",31");
		$log = "0";
		if ($num = $DB->num_rows()) {
			echo 'Showing Admin Log Files - Entries <strong>'.$start.'</strong> to <strong>'.($start + $num - 1).'</strong> <br /><table width="100%" border="0"><tr><th>Administrator</th><th>Action</th><th>IP Address</th></tr>';
			while ($row = $DB->fetch_array()) {

				if ($log < "30") {
					switch ($row['type']) {
						case '1':
							$color = "#0410B0";
						break;
						case '2':
							$color = "#357F03";
						break;
						case '3':
							$color = "#BB1403";
						break;
						case '4':
							$color = "#FF7F01";
						break;
						case '5':
							$color = "#800080";
						break;
					}

					echo '<tr style="text-align: center;"><td>'.$row['user'].'</td><td style="color: '.$color.';">'.$row['action'].'</td><td>'.$row['ip'].'</td></tr>';
				}
				else {
					echo '<tr><td colspan="3" align="right">'.($start ? '
<a href="'.$gcgb->baseurl.'?a=adminlogs'.$gcgb->config['queryseperator'].'start='.($start - 30).'">Prev</a> | ' : '').'<a href="'.$gcgb->baseurl.'?a=adminlogs'.$gcgb->config['queryseperator'].'start='.($start + 30).'">Next</a>&nbsp;</td></tr>';
				}
				++$log;
			}
			echo '</table>&nbsp;<a href="'.$gcgb->baseurl.'?a=adminlogs'.$gcgb->config['queryseperator'].'code=01">Clear Admin Logs</a>';
		}
		else {
			echo "No Log Files Found!";
		}
		
		$skin->EndTable();
		$skin->EndPage();
	}

	function ClearLogs() {
		global $DB, $skin, $gcgb;

		$skin->StartPage("adminlogs", "Admin Logs");
		$skin->MakeMenu($this->permissions);

		// Clear the logs. Aroooooooooooga!
		$DB->query ("DELETE FROM gcgb_logs WHERE type='1' OR type='2' OR type='3' OR type='4' OR type='5'");
		if ($DB->affected_rows()) {
			echo $skin->ActionSuccess("Admin Logs Cleared.", "Admin Logs", "adminlogs");
		}
		else {
			echo $skin->ActionFailiure("Could not clear Admin Logs.", "Admin Logs", "adminlogs");
		}

		$skin->EndTable();
		$skin->EndPage();
	}
}

?>