<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Guestbook Wrapper Script
+ Started: 16th May 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

error_reporting (E_ERROR | E_WARNING | E_PARSE);
set_error_handler ('fatal_error');
define('IN_SCRIPT', true);

// Set up a new timer
class Timer {
	var $timer_start;
	var $timer_stop;
	var $time = "0";
	function Start() {
		list($usec, $sec) = explode(" ",microtime());
		$this->timer_start = ((float)$usec + (float)$sec);
	}
	function Stop() {
		list($usec, $sec) = explode(" ",microtime());
		$this->timer_stop = ((float)$usec + (float)$sec);
		$this->time = $this->time+($this->timer_stop - $this->timer_start);
	}
	function GetTime() {
		return substr($this->time, "0", "5");
	}
}

// The class for all the info
class GCGuestbook {
	var $scriptname = "Global Centre Guestbook";
	var $version = "1.0 RC2";
	var $baseurl;
	var $config = array();
	var $input = array();
	function GCGuestbook() {
		// Get Configuation Details
		require_once ("config.php");
		$this->config = &$config; // Import Config info

		// Get Input From Query String
		$input = split("[;&]", urldecode($_SERVER['QUERY_STRING']));
		foreach ($input as $ibuff) {
			if(preg_match("/^([^=]+)[=](.*)/", $ibuff, $qstring)) {
				$this->input[$qstring[1]] = $this->makesafe($qstring[2]);
			}
		}

		// Get Post and Cookie Input
		$pc = array_merge($_COOKIE, $_POST);
		while (list($k, $v) = each($pc)) {
			$this->input[$k] = $this->makesafe($v);
		}

		// Set Base URL
		$this->baseurl = $this->config['scriptname'];

	}
	function makesafe($value) {
		$value = str_replace ("<!--", "&lt;&#33;--", $value);
		$value = str_replace ("-->", "-->&gt;", $value);
		$value = str_replace ("<", "&lt;", $value);
		$value = str_replace (">", "&gt;", $value);
		$value = str_replace ("&#032;", " ", $value);
		$value = str_replace ("\n", "<br />", $value);
		$value = str_replace ("'", "&#39;", $value);
		$value = str_replace ("\"", "&quot;", $value);
		return stripslashes($value);
	}
}

$gcgb = new GCGuestbook;
require_once ("sources/drivers/".$gcgb->config['sql']['driver'].".php");
require_once ("sources/skin.php");
$DB = new DB;
$skin = new Skin;

// Is Guestbook Offline?
if ($gcgb->config['offline'] == "1") {
	fatal_error("", $gcgb->config['offline_msg']."<br />", "", "", "", "Guestbook");
}

// If you are looking for neonBugs you won't find them in this piece of software hopefully :)
// This comment is really banal but who cares? :)

// Connect to DB
$DB->connect($gcgb->config['sql']['host'], $gcgb->config['sql']['user'], $gcgb->config['sql']['password'], $gcgb->config['sql']['db'], $gcgb->config['sql']['prefix']);

// Remove mysql connection details for security
unset($gcgb->config['sql']);

$timer = new Timer;
$timer->start();

// Module Things
$pages = array (
"view" => array ("file" => "sources/view.php", "pagename" => "View Guestbook"),
"sign" => array ("file" => "sources/sign.php", "pagename" => "Sign Guestbook"),
"help" => array ("file" => "sources/help.php", "pagename" => "Help"),
);

$action = $pages[$gcgb->input['a']];
if (!isset ($pages[$gcgb->input['a']])) {
$action = array ("file" => "sources/view.php", "pagename" => "View Guestbook");
}

// Output Buffer and that junk
if ($gcgb->config['gzip']) {
	ob_start("ob_gzhandler");
	$gzipstatus = "Enabled";
}
else {
	ob_start();
	$gzipstatus = "Disabled";
}

// Wubbable Header time
$skin->LoadSkin("header");
echo $skin->ParseSkin("header", array("style" => $skin->LoadStyle(), "sitename" => $gcgb->config['sitename'], "page" => $action['pagename'], "viewurl" => $gcgb->baseurl."?a=view", "signurl" => $gcgb->baseurl."?a=sign", "helpurl" => $gcgb->baseurl."?a=help", "siteurl" => $gcgb->config['siteurl']));

// Do our module thing
require_once ($action['file']);
$module = new Module;

// Stop the Timer and close DB connection
$timer->stop();
$DB->close();

$skin->LoadSkin("footer");
echo $skin->ParseSkin("footer", array("exectime" => $timer->gettime(), "queries" => $DB->queries, "gzipstatus" => $gzipstatus, "copyright" => 'Powered by <a href="http://www.global-centre.com/services/scripts/">'.$gcgb->scriptname.'</a> '.$gcgb->version.' &copy; <a href="http://www.global-centre.com">Global Centre</a> 2003'));

// Send output to browser
ob_end_flush();

// Global Routines
function fatal_error($level, $message, $file, $line, $context, $type="PHP") {
	global $gcgb;
	if ($type == "PHP" AND $level != "1" AND $level != "2" AND $level != "3") {
		// We want to ignore this error o_O Do nowt.
	}
	else {
		// Get rid of junk
		ob_end_clean();
		echo "<!-- Error page generated by Global Centre Guestbook ".$gcgb->version." - ".date("d M Y H:i:s T")." -->\n\n<html><head><title>Global Centre Guestbook Error</title><style type=\"text/css\">body { font-family: Verdana; font-size: 10pt; }</style></head><body><div width=\"500\" style=\"background-color: #0410B0; color: #ffffff; font-weight: bold; padding: 3px;\">".$type.'  Error</div><div width="500" style="background-color: #A7C4F5; color: #000000; padding: 3px;"><img src="script/fatalerror.gif" align="left" />';

		if ($type == "PHP") {
			echo "<strong>Line:</strong> ".$line."<br /><strong>File:</strong> ".$file."<br />";
		}

		echo "<strong>Error Returned:</strong> ".$message."<br /><br />Please contact the <a href=\"mailto:".$gcgb->config['adminemail']."?subject=Guestbook Error\">Guestbook Administrator</a>.<br /><strong>Date/Time:</strong> ".date("d M Y H:i:s T").'</div><br />Powered by <a href="http://www.global-centre.com/services/scripts/">Global Centre Guestbook</a> '.$gcgb->version.'</body></html>';
		exit();
	}
}
?>