<?php
/*
+ ------------------------------------------------------------------------
+ Global Centre Guestbook - Version 1.0
+ Copyright (C) 2003 Global Centre
+ http://www.global-centre.com/services/scripts/
+ ------------------------------------------------------------------------
+ Admin Wrapper Script
+ Started: 26th May 2003
+ Module Version: 1.0
+ ------------------------------------------------------------------------
+ This program is free software; you can redistribute it and/or modify
+ it under the terms of the GNU General Public License as published by
+ the Free Software Foundation; either version 2 of the License, or
+ (at your option) any later version.
+
+ This program is distributed in the hope that it will be useful,
+ but WITHOUT ANY WARRANTY; without even the implied warranty of
+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
+ GNU General Public License for more details.
+
+ You should have received a copy of the GNU General Public License
+ along with this program; if not, write to the Free Software
+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
+ ------------------------------------------------------------------------
*/

error_reporting (E_ERROR | E_WARNING | E_PARSE);
set_error_handler ('fatal_error');
define('IN_ADMIN', true);

// The class for all the info
class GCGuestbook {
	var $scriptname = "Global Centre Guestbook";
	var $version = "1.0 RC2";
	var $baseurl;
	var $config = array();
	var $input = array();
	function GCGuestbook() {
		// Get Configuation Details
		require_once ("config.php");
		$this->config = &$config; // Import Config info

		// Get Input From Query String
		$input = split("[;&]", urldecode($_SERVER['QUERY_STRING']));
		foreach ($input as $ibuff) {
			if(preg_match("/^([^=]+)[=](.*)/", $ibuff, $qstring)) {
				$this->input[$qstring[1]] = $this->makesafe($qstring[2]);
			}
		}

		// Get Post and Cookie Input
		$pc = array_merge($_COOKIE, $_POST);
		while (list($k, $v) = each($pc)) {
			$this->input[$k] = $this->makesafe($v);
		}

		// Set Base URL
		$this->baseurl = $this->config['adminscriptname'];

	}
	function makesafe($value) {
		$value = str_replace ("<!--", "&lt;&#33;--", $value);
		$value = str_replace ("-->", "-->&gt;", $value);
		$value = str_replace ("<", "&lt;", $value);
		$value = str_replace (">", "&gt;", $value);
		$value = str_replace ("&#032;", " ", $value);
		// $value = str_replace ("\n", "<br />", $value);
		$value = str_replace ("'", "&#39;", $value);
		$value = str_replace ("\"", "&quot;", $value);
		return stripslashes($value);
	}
}

$gcgb = new GCGuestbook;
require_once ("sources/drivers/".$gcgb->config['sql']['driver'].".php");
require_once ("sources/admin/skin.php");
$DB = new DB;
$skin = new Skin;

// Connect to DB
$DB->connect($gcgb->config['sql']['host'], $gcgb->config['sql']['user'], $gcgb->config['sql']['password'], $gcgb->config['sql']['db'], $gcgb->config['sql']['prefix']);

// Remove mysql connection details for security
unset($gcgb->config['sql']);

// Make sure info etc is not already set.
$username = "";
$password = "";
$acppermissions = "";

// Rightey O. Lets check if admin is logged in
if (!$gcgb->input['username'] OR !$gcgb->input['password'] OR $gcgb->input['username'] == "" OR $gcgb->input['password'] == "" AND $gcgb->input['a'] != "do_login") {
	login();
}

// What to do and do it :P
switch ($gcgb->input['a']) {
	// Misc
	case 'index':
		require 'sources/admin/ad_overview.php';
	break;
	case 'do_login':
		do_login();
	break;
	case 'logout':
		logout();
	break;

	// Configuration
	case 'basic':
		require 'sources/admin/ad_conf.php';
	break;
	case 'db':
		require 'sources/admin/ad_database.php';
	break;
	case 'emoticons':
		require 'sources/admin/ad_emoticons.php';
	break;
	case 'wordfilter':
		require 'sources/admin/ad_wordfilter.php';
	break;

	// Entries
	case 'manage':
		require 'sources/admin/ad_manage.php';
	break;
	case 'approve':
		require 'sources/admin/ad_approve.php';
	break;

	// Skin
	case 'sselect':
		require 'sources/admin/ad_sselect.php';
	break;
	case 'sedit':
		require 'sources/admin/ad_sedit.php';
	break;
	case 'sstyle':
		require 'sources/admin/ad_sstyle.php';
	break;

	// Help Files
	case 'helpadd':
		require 'sources/admin/ad_helpadd.php';
	break;
	case 'helpmanage':
		require 'sources/admin/ad_helpmanage.php';
	break;

	// Stats
	case 'stats':
		require 'sources/admin/ad_stats.php';
	break;

	// Logs
	case 'adminlogs':
		require 'sources/admin/ad_adminlogs.php';
	break;

	// Users
	case 'adminadd':
		require 'sources/admin/ad_users.php';
	break;
	case 'adminmanage':
		require 'sources/admin/ad_users.php';
	break;

	default:
		require 'sources/admin/ad_overview.php';
}

if ($gcgb->input['a'] != "do_login" AND $gcgb->input['a'] != "logout") {
	$acppermissions = CheckLogin();
	$module = new Module;
}

// Global Routines
function login($message="") {
	global $skin;
	$skin->StartPage ("login", "Login");
	echo <<<EOF
<form action="admin.php" method="post">
<input type="hidden" name="a" value="do_login" />
<table>
<tr><td>Username:</td><td><input type="text" name="username" /></td></tr>
<tr><td>Password:</td><td><input type="password" name="password" /></td></tr>
</table>
<input type="Submit" value="Submit" />
</form>
EOF;


	$skin->EndPage ();
	exit;
}

function do_login() {
	global $gcgb, $skin, $DB;

	if ($gcgb->input['username'] AND $gcgb->input['password']) {
		$DB->query("SELECT username FROM gcgb_admins WHERE username='".$gcgb->input['username']."' AND password='".md5($gcgb->input['password'])."';");
		if ($DB->num_rows()) {
			setcookie ("username", $gcgb->input['username']);
			setcookie ("password", $gcgb->input['password']);
			header ("Location: ".$gcgb->baseurl."?a=index&login=1");
		}
		else {
			$skin->StartPage ("login", "Login");
			echo "<p>Login Failed.</p>";
			$skin->EndPage ();
		}
	}
	else {
		$skin->StartPage ("login", "Login");
		echo "<p>Login Failed.</p>";
		$skin->EndPage ();
	}

	exit;
}

function CheckLogin() {
	global $gcgb, $skin, $DB;

	if ($gcgb->input['username'] AND $gcgb->input['password']) {
		$DB->query("SELECT username, admin_perms FROM gcgb_admins WHERE username='".$gcgb->input['username']."' AND password='".md5($gcgb->input['password'])."';");
		if ($DB->num_rows()) {
			$row = $DB->fetch_array();

			// 1 - Basic Config
			// 2 - Entries
			// 4 - Skin
			// 8 - Manage Help Files
			// 16 - Guestbook Stats
			// 32 - Guestbook Logs
			// 64 - Manage Admins

			// Return Admin Permissions
			$perms = strrev(base_convert(intval($row['admin_perms']), 10, 2));

			$acpperms = array(
				"username" => $row['username'],
				"edit_config" => intval($perms['0']),
				"edit_entries" => intval($perms['1']),
				"edit_skin" => intval($perms['2']),
				"edit_help" => intval($perms['3']),
				"edit_stats" => intval($perms['4']),
				"edit_logs" => intval($perms['5']),
				"edit_admins" => intval($perms['6']),
			);

			return $acpperms;
		}
		else {
			login();
		}
	}
	else {
		login();
	}
}

function Logout() {
	global $gcgb;

	// Clear all cookies - Redirect to Guestbook Main
	setcookie ("username", "", time()-3600);
	setcookie ("password", "", time()-3600);
	header ("Location: ".$gcgb->config['scriptname']);
}

function fatal_error($level, $message, $file, $line, $context, $type="PHP") {
	global $gcgb;
	if ($type == "PHP" AND $level != "1" AND $level != "2" AND $level != "3") {
		// We want to ignore this error o_O Do nowt.
	}
	else {
		echo "<!-- Error page generated by Global Centre Guestbook ".$gcgb->version." - ".date("d M Y H:i:s T")." -->\n\n<html><head><title>Global Centre Guestbook Error</title><style type=\"text/css\">body { font-family: Verdana; font-size: 10pt; }</style></head><body><div width=\"500\" style=\"background-color: #0410B0; color: #ffffff; font-weight: bold; padding: 3px;\">".$type.'  Error</div><div width="500" style="background-color: #A7C4F5; color: #000000; padding: 3px;"><img src="script/fatalerror.gif" align="left" />';

		if ($type == "PHP") {
			echo "<strong>Line:</strong> ".$line."<br /><strong>File:</strong> ".$file."<br />";
		}

		echo "<strong>Error Returned:</strong> ".$message."<br /><br />Please contact the <a href=\"mailto:".$gcgb->config['adminemail']."?subject=Guestbook Error\">Guestbook Administrator</a>.<br /><strong>Date/Time:</strong> ".date("d M Y H:i:s T").'</div><br />Powered by <a href="http://www.global-centre.com/services/scripts/">'.$gcgb->scriptname.'</a> '.$gcgb->version.'</body></html>';
		exit();
	}
}
?>