<?php

function template($page, $output = "") {
 $output .= implode("", file("template/$page"));
 return $output;
}

function ciclo_sub($nome, $completo, $output) {
 $out = preg_replace("#<!-- CICLO $nome -->(.+?)<!-- CICLO $nome -->#si", $completo, $output);
 return $out;
}

function parse_messaggi($page, $output = "") {
 $output .= implode("", file("$page"));
 return $output;
}

function insert_nick($nick) {
 $out = htmlentities($nick);
 return $out;
}

function insert_text($text) {
 $out = htmlentities($text);
 return $out;
}

function view_nick($text) {
 $out = trim($text);
 if ( get_magic_quotes_gpc() ) { $out = stripslashes($text); }
 $out = substr($out, 0, 15);
 return $out;
}

function view_text($text) {
 $out = nl2br($text);
 $out = trim($out);
 if ( get_magic_quotes_gpc() ) { $out = stripslashes($out); }
 return $out;
}

function qstring_remove($togli) {
 $qstring = $_SERVER['QUERY_STRING'];
 $gets = explode("&", $qstring);
 if (!is_array($togli)) { $taglia[0] = $togli; } else { $taglia = $togli; }
 for ($y=0; $y < count($taglia); $y++)
 {
  $datogli = $taglia[$y];
  $newgets = array();
  $gets = explode("&", $qstring);
  for ($x=0; $x < count($gets); $x++)
  {
   if (!preg_match("#$datogli=(.+?)#i", $gets[$x])) { $newgets[] = $gets[$x]; }
  }
  if (count($newgets)!=0) { $qstring = implode("&amp;", $newgets); } 
					 else { $qstring = ""; }
 }
 return $qstring;
}

function get_page($pagine_tot) {
 if ( (isset($_GET['page'])) AND (is_numeric($_GET['page'])) )
 {
  if ( ($_GET['page'] > 0) AND ($_GET['page'] < $pagine_tot + 1) ) 
   { $pagina = $_GET['page']; }
   else
   { $pagina = ($_GET['page'] < 1) ? 1 : $pagine_tot; }
 }
 else
 { $pagina = 1; }
 return $pagina; 
}

function create_pagination($pag_tot, $pag_now) {
 $out = "";
 $qstring = qstring_remove("page");
 for ($x=1; $x <= $pag_tot; $x++)
 {
  $out .= ($x == $pag_now) ? "<span class=\"now\">[ <em>$x</em> ]</span> " : "<a href=\"index.php?$qstring&amp;page=$x\" title=\"Vai alla pagina $x\">[ <em>$x</em> ]</a> ";
 }
 return trim($out);
}

function hidepart($voce, $output) {
 $out = preg_replace("#<!-- INIZIO $voce -->(.+?)<!-- FINE $voce -->#si", "", $output);
 return $out;
}

function remove_item_array($array, $item) {
 $new_array = array();
 $new_array[0] = "";
 for ($x = 0; $x < count($array); $x++)
 {
  if ( ($x!=$item) AND (trim($array[$x])!="") ) { $new_array[] = $array[$x]; }
 }
 return $new_array;
}

?>