<?php
	/***********************************************************************************
	* PHP --> MySQL / SQLite 
	* FRIENDLY DEVELOPMENT WITH AUTOMATED STATS AND GRAPHICS INTERFACE
	*
	* Class my_sql and extended my_sqlite
	* [ bundled with my sql_highlighter() function ] [ built-in adapted version ]
	*
	* Author: Andrea Giammarchi [ andr3a ] [ www.3site.it ] [andrea@3site.it]
	* Copyright: Andrea Giamamrchi
	* Date: 04/09/2003
	* Last Modified: 11/09/2003
	* Version: 1.0 [ PHP4 compatible ]
	*
	* Note:
	* All functions and classes are created from Andrea Giammarchi [andr3a]
	*
	* Important:
	* This class need SQL.sintax file to highlight SQL sintax [ easy to update ]
	*
	* Other Features:
	* [ PHP notice FREE ] [ reporting E_ALL ]
	* [ W3C HTML 4.01 Strict / CSS2 ] [ VALIDATED ]
	* [ JavaScript ] [ CROSSBROWSER ]
	***********************************************************************************/
	Class my_sql {
		var $hst, $db, $c_q, $usr, $pwd, $my_queries, $my_times, $q_limit, $f_limit, $js_lengcheck, $pthigh, $last_error;
		function my_sql() {
			$this->c_q = 0;
			$this->my_queries = Array();
			$this->my_times = Array();
			$this->f_limit = 50;
			$this->q_limit = 300;
			$this->js_lengcheck = false;
			$this->highlight_path("");
			if(!ini_get("track_errors")) {
				ini_set("track_errors", 1);
			}
		}
		function connect($h, $d, $u = "", $p = "") {
		        $this->hst = $h;
			$this->usr = $u;
			$this->pwd = $p;
			$this->db = $d;
			$con = @mysql_connect($this->hst, $this->usr, $this->pwd);
			if(!$con) {
				 $this->error($sqliteerror, $this->db);
				 return false;
			}
			$db_enter = @mysql_select_db($this->db);
			if(!$db_enter) {
				 $this->create_db($this->db);
			}
			return true;
		}
		function pconnect($h, $d, $u = "", $p = "") {
		        $this->hst = $h;
			$this->usr = $u;
			$this->pwd = $p;
			$this->db = $d;
			$con = @mysql_pconnect($this->hst, $this->usr, $this->pwd);
			if(!$con) {
				 $this->error(mysql_error(), $this->db);
				 return false;
			}
			$db_enter = @mysql_select_db($this->db);
			if(!$db_enter) {
				 $this->create_db($this->db);
			}
			return true;
		}
		function create_db($db) {
			$create = @mysql_create_db($db);
                        if(!$create) {
				 $this->error(mysql_error(), $this->db);
				 return false;
			}
			echo "
			<script type=\"text/javascript\">
				alert('Database {$db} created.');
			</script>
			";
			@mysql_select_db($db);
		}
		function limit_showfetch($v) {
			$this->f_limit = $v;
		}
		function limit_showquery($v) {
			$this->q_limit = $v;
		}
		function time_elapsed_capture() {
			list($u, $s) = explode(" ",microtime());
			return ((float)$u + (float)$s);
		}
		function time_elapsed_print($item1, $item2, $rd=6) {
			return round(($item2-$item1), $rd);
		}
		function error($er="",$q="") {
		        if($er=="" && $q=="") {
		        	return $this->last_error;
			}
			else {
				$this->last_error .= $q == "" ? "<p><b>Error:</b> ".$er."</p>" : "<p><b>Error:</b> ".$er."<br /><i>".$q."</i></p>";
				return true;
			}
		}
		function query($q, $umb = false) {
			$this->c_q++;
			if(in_array($q, $this->my_queries)) {
				$this->my_queries[] = "<b>[ Replicated Query ]</b><br />".$q;
			}
			else {
				$this->my_queries[] = $q;
			}
			$start_time = $this->time_elapsed_capture();
			if($umb == false) {
				$now_q = @mysql_query($q);
           		}
           		else {
              			$now_q = @mysql_unbuffered_query($q);
			}
			$this->my_times[] = $this->time_elapsed_print( $start_time,$this->time_elapsed_capture() );
			if(!$now_q){
				$this->error(mysql_error(), $q) ;
				return false ;
			}
			unset($start_time);
			return $now_q;
		}
		function unbuffered_query($q) {
		        return $this->query($q, true);
		}
		function total() {
			$sum_q = 0;
			for($i=0; $i<count($this->my_times); $i++) {
				$sum_q += $this->my_times[$i];
			}
			return Array("query"=>$this->c_q, "time"=>$sum_q);
		}
		function highlight_path($pt) {
		        $this->pthigh = $pt;
		        return $this->pthigh;
		}
		function show_all_normal() {
			return Array("query"=>$this->my_queries, "time"=>$this->my_times);
		}
		function show_all($automatic = true, $highlt = true, $width="500px", $border="solid #EAEAEA", $bg="#F8F8F8", $color="#000000", $bg2="#FCFCFC", $familiy="Verdana, Helvetica, sans-serif", $f_size="7pt") {
			if($automatic != true) {
				return $this->show_all_normal();
			}
			else {
				$bg2 = $bg2=="" ? $bg : $bg2;
				$mye_query = $this->show_all(false);
				$tot = $this->total();
				$out = $this->write_js_onDocument();
				$out .= "<table cellpadding=\"2\" cellspacing=\"2\" style=\"width: {$width}; height: 10px; font-family: {$familiy}; font-size: {$f_size}; border: 1px {$border}; background-color: {$bg}; color: {$color};\">
				<tr><td align=\"left\"><b>Total query [</b> ".$tot["query"]." <b>]</b></td><td align=\"right\"><b>Total time [</b> ".round($tot["time"], 5)." <b>]</b></td></tr>";
				for($i=0; $i<count($mye_query["query"]); $i++) {
					$mye_query["query"][$i] = str_replace("\n", "", $mye_query["query"][$i]);
					$mye_query["query"][$i] = str_replace("\r", "", $mye_query["query"][$i]);
					if(strlen($mye_query["query"][$i]) > $this->q_limit) {
					        $mye_query["query"][$i] = str_replace('"', "&quot;", $mye_query["query"][$i]);
						$mostra = "<a style=\"text-decoration: none; font-family: {$familiy}; font-size: {$f_size}; background-color: {$bg2}; color: {$color};\" name=\"query_line_".$i."\" href=\"#query_line_".$i."\" onClick=\"show_auto_query_class('result_query_".$i."','".addslashes(substr($mye_query["query"][$i], $this->q_limit, strlen($mye_query["query"][$i])-$this->q_limit))."');\" onMouseOver=\"this.style.textDecoration='underline'\" onMouseOut=\"this.style.textDecoration='none'\">".substr($mye_query["query"][$i], 0, $this->q_limit)."</a><span id=\"result_query_".$i."\">...</span>";
					}
					else {
						$mostra = $highlt != true ? $mye_query["query"][$i] : $this->highlight($mye_query["query"][$i], 0, 0, "#0000A0", "#C00000", "#009000", $bg2);
					}
					$out .= "<tr><td align=\"left\" style=\"background-color: {$bg2}; color: {$color}; border: 1px {$border};\">".$mostra."</td><td align=\"right\" style=\"background-color: {$bg2}; color: {$color}; border: 1px {$border};\">".$mye_query["time"][$i]."</td></tr>";
				}
				$out .= "</table>";
				return $out;
			}
		}
		function show_fetch($nq = "", $width="500px", $border="solid #EAEAEA", $bg="#F8F8F8", $color="#000000", $bg2="#FCFCFC", $tipo = "mysql") {
			$item = Array();
			if($nq == "") {
				$lq = $this->show_all(false);
				$lindex = count($lq["query"])-1;
				$lastused = $this->query($lq["query"][$lindex]);
				if(strtolower($tipo) == "mysql") {
					if(mysql_num_rows($lastused)>0) {
						while($s = mysql_fetch_assoc($lastused)) {
							$item[] = $s;
						}
					}
				}
				elseif(strtolower($tipo) == "sqlite") {
                        		if(@$this->num_rows()) {
						while($s = $this->fetch_assoc()) {
							$item[] = $s;
						}
					}
				}
				else {
					die("Don't change last value of this function.");
				}
			}
			else {
				$lastused = $this->query($nq);
				if(strtolower($tipo) == "mysql") {
					if(mysql_num_rows($lastused)>0) {
						while($s = mysql_fetch_assoc($lastused)) {
							$item[] = $s;
						}
					}
				}
				elseif(strtolower($tipo) == "sqlite") {
				     	if(@$this->num_rows()) {
						while($s = $this->fetch_assoc()) {
							$item[] = $s;
						}
					}
				}
				else {
					die("Don't change last value of this function.");
				}
				$lq = $this->show_all(false);
				$lindex = count($lq["query"])-1;
			}
			$primalinea = "";
			$contenuto = "";
			if(isSet($item[0]) && is_Array($item[0])) {
				for($i=0; $i<count($item); $i++) {
					if($i==0) {
						$contenuto .= "<tr>";
						while(list($k, $v) = each($item[$i])) {
							$primalinea .= "<td><b>{$k}</b></td>";
							if (get_magic_quotes_gpc()) {
								$v = stripslashes($v);
							}
							$v = str_replace("\n", " ", $v);
							$v = str_replace("\r", " ", $v);
							$v = htmlspecialchars($v);
							if(strlen($v) > $this->f_limit) {
								$v = "<a style=\"text-decoration: none; font-family: Verdana, Helvetica, sans-serif; font-size: 7pt; background-color: ".$bg."; color: ".$color.";\" name=\"fetch_line_".$i."\" href=\"#fetch_line_".$i."\" onClick=\"show_auto_query_class('result_fetch_".$i."','".htmlentities(addslashes(substr($v, $this->f_limit, strlen($v)-$this->f_limit)))."');\" onMouseOver=\"this.style.textDecoration='underline'\" onMouseOut=\"this.style.textDecoration='none'\">".substr($v, 0, $this->f_limit)."</a><span id=\"result_fetch_".$i."\">...</span>";
							}
							$contenuto .= "<td style=\"background-color: {$bg2}; color: {$color}; border: 1px {$border};\">{$v}</td>";
						}
						$contenuto .= "</tr>";
					}
					else {
						$contenuto .= "<tr>";
						while(list(,$v) = each($item[$i])) {
							if (get_magic_quotes_gpc()) {
								$v = stripslashes($v);
							}
							$v = str_replace("\n", " ", $v);
							$v = str_replace("\r", " ", $v);
							$v = htmlspecialchars($v);
							if(strlen($v) > $this->f_limit) {
								$v = "<a style=\"text-decoration: none; font-family: Verdana, Helvetica, sans-serif; font-size: 7pt; background-color: ".$bg."; color: ".$color.";\" name=\"fetch_line_".$i."\" href=\"#fetch_line_".$i."\" onClick=\"show_auto_query_class('result_fetch_".$i."','".htmlentities(addslashes(substr($v, $this->f_limit, strlen($v)-$this->f_limit)))."');\" onMouseOver=\"this.style.textDecoration='underline'\" onMouseOut=\"this.style.textDecoration='none'\">".substr($v, 0, $this->f_limit)."</a><span id=\"result_fetch_".$i."\">...</span>";
							}
							$contenuto .= "<td style=\"background-color: {$bg2}; color: {$color}; border: 1px {$border};\">{$v}</td>";
						}
						$contenuto .= "</tr>";
					}
				}
				$out = $this->write_js_onDocument();
				$out .= "
				<table cellpadding=\"2\" cellspacing=\"2\" style=\"width: {$width}; height: 10px; font-family: Verdana, Helvetica, sans-serif; font-size: 7pt; background-color: {$bg}; color: {$color}; border: 1px {$border}; \">
					<tr>
						{$primalinea}
					</tr>
					{$contenuto}
				</table>
				";
			}
			else {
			     	if (get_magic_quotes_gpc()) {
					$nomatch = stripslashes($this->my_queries[count($this->my_queries)-1]);
				}
				else {
					$nomatch = $this->my_queries[count($this->my_queries)-1];
				}
                        	$out = "
				<table cellpadding=\"2\" cellspacing=\"2\" style=\"width: {$width}; height: 10px; font-family: Verdana, Helvetica, sans-serif; font-size: 7pt; background-color: {$bg}; color: {$color}; border: 1px {$border}; \">
					<tr>
						<td style=\"background-color: {$bg2}; color: {$color}; border: 1px {$border};\"><b>No match for this query:</b><br />".$this->highlight($nomatch, 1, 0, "#0000A0", "#C00000", "#009000", $bg2)."</td>
					</tr>
				</table>
				";
			}
			return $out;
		}
		function write_js_onDocument() {
			if($this->js_lengcheck == false) {
				$this->js_lengcheck = true;
				$out = "
				<script type=\"text/javascript\">
						function show_auto_query_class(myid, valore) {
							document.getElementById(myid).innerHTML = ' ' + valore;
						}
				</script>
				";
			}
			else {
				$out = "";
			}
			return $out;
		}
		function highlight($st, $upper_sintax = false, $case_insensitive = false, $stringtext="#222299", $sintaxcolor="#C00000", $number="#00C000", $background="#FFFFFF") {
			if (get_magic_quotes_gpc()) {
				$st = stripslashes($st);
			}
			$filename = $this->highlight_path($this->pthigh)."SQL.sintax";
			$rf = @fopen($filename, "r");
			if(!$rf) {
				$nofound = "<b><i>Error</i></b> <i>file</i> \"{$filename}\" <i>not found.</i>";
				return $nofound;
			}
			$l_ar = fread($rf, filesize($filename));
			fclose($rf);
			$sql_arr = explode("|", $l_ar);
			unset($l_ar);
			$tag2 = md5(microtime());
			$st = str_replace("\\\"", $tag2, $st);
			$ver = explode(".", phpversion());
			$tag3 = md5(microtime());
			$st = str_replace("\'", $tag3, $st);
			$m = Array();
			$m = preg_split ("/(\"){1}([^\"])+(\"){1}|('){1}([^'])+('){1}/", $st, -1, PREG_SPLIT_DELIM_CAPTURE);
			$total_out = "";
			$ricorda = 0;
			$m[0] = " ".$m[0];
			$m[count($m)-1] .= " ";
			$num_regger = "([^a-z0-9\_]){1}([0-9]+)(\)| |\r|\n|,){1}";
			for($a=0; $a<count($m); $a++) {
				if($m[$a]=="\"" || $m[$a]=="'") {
					$now_char = 0;
					for($i=$ricorda; $i<strlen($st); $i++) {
						$now_char++;
						if($m[$a] == substr($st, $i, 1)) {
							$newst = $m[$a].substr($st, $ricorda, $now_char);
							break;
						}
					}
					$ricorda += strlen($newst);
					$a += 2;
					$total_out .= "<span style=\"color: {$stringtext}; background-color: {$background};\">".htmlspecialchars($newst)."</span>";
				}
				else {
					if($m[$a]!='') {
						$ricorda += strlen($m[$a]);
						if($upper_sintax != false) {
							$m[$a] = explode(" ", $m[$a]);
							for($b=0; $b<count($m[$a]); $b++) {
								for($i=0; $i<count($sql_arr); $i++) {
									if(strtoupper($m[$a][$b])==$sql_arr[$i]) {
										$m[$a][$b] = strtoupper($m[$a][$b]);
										break;
									}
								}
							}
							$m[$a] = implode(" ", $m[$a]);
						}
						$finitiinumeri = false;
						for($i=0; $i<count($sql_arr); $i++) {
							if(!eregi($num_regger, $m[$a]) && $finitiinumeri == false) {
								$finitiinumeri = true;
							}
							if($finitiinumeri == false) {
								$m[$a] = eregi_replace($num_regger, "\\1<span style=\"color: {$number}; background-color: {$background};\">\\2</span>\\3", $m[$a]);
							}
							$myregexp = "([^a-z0-9\_]){1}(".$sql_arr[$i]."){1}( |\r|\n|\(){1}";
							$txttoreplace = "\\1<span style=\"color: {$sintaxcolor}; background-color: {$background};\">\\2</span>\\3";
							if($case_insensitive != false) {
								if($ver[0] > 4) {
									if(stripos($m[$a], $sql_arr[$i])!== false) {
										$m[$a] = eregi_replace($myregexp, $txttoreplace, $m[$a]);
									}

								}
								else {
									if(strpos(strtoupper($m[$a]), $sql_arr[$i])!== false) {
										$m[$a] = eregi_replace($myregexp, $txttoreplace, $m[$a]);
									}
								}
							}
							else {
								if($upper_sintax != false) {
									if(strpos($m[$a], $sql_arr[$i])!== false) {
										$m[$a] = eregi_replace($myregexp, $txttoreplace, $m[$a]);
									}
								}
								else {
									if((strpos($m[$a], $sql_arr[$i])!== false) || (strpos($m[$a], strtolower($sql_arr[$i]))!== false)) {
										$m[$a] = eregi_replace($myregexp, $txttoreplace, $m[$a]);
									}
								}
							}
						}
						$total_out .= $m[$a];
					}
				}
			}
			$total_out = str_replace($tag2, "\\\"", $total_out);
			$total_out = str_replace($tag3, "\\'", $total_out);
			return trim($total_out);
		}
		function add_sintax($newword) {
		        $newword = strtoupper(trim($newword));
  			$filename = $this->highlight_path($this->pthigh)."SQL.sintax";
			$rf = @fopen($filename, "r");
			if(!$rf) {
				$nofound = "<b><i>Error</i></b> <i>file</i> \"{$filename}\" <i>not found.</i>";
				return $nofound;
			}
			$l_ar = fread($rf, filesize($filename));
			$sql_arr = explode("|", $l_ar);
			for($i=0; $i<count($sql_arr); $i++) {
   				if($newword==$sql_arr[$i]) {
   				        fclose($rf);
   				        return false;
       				}
			}
			fclose($rf);
			$rf = @fopen($filename, "a");
			if(!$rf) {
				die("<b><i>Error</i></b> <i>You don't have permission to write file</i> \"{$filename}\"<br />");
			}
			fputs($rf, "|".$newword);
			fclose($rf);
			return true;
		}
		function rem_sintax($newword) {
		        $newword = strtoupper(trim($newword));
  			$filename = $this->highlight_path($this->pthigh)."SQL.sintax";
			$rf = @fopen($filename, "r");
			if(!$rf) {
				$nofound = "<b><i>Error</i></b> <i>file</i> \"{$filename}\" <i>not found.</i>";
				return $nofound;
			}
			$l_ar = fread($rf, filesize($filename));
			$sql_arr = explode("|", $l_ar);
			$new_ar = "";
			for($i=0; $i<count($sql_arr); $i++) {
   				if($newword!=$sql_arr[$i]) {
   				        $new_ar .= $sql_arr[$i]."|";
       				}
			}
			fclose($rf);
			$rf = @fopen($filename, "w+");
			if(!$rf) {
				die("<b><i>Error</i></b> <i>You don't have permission to write file</i> \"{$filename}\"<br />");
			}
			fwrite($rf, substr($new_ar, 0, strlen($new_ar)-1));
			fclose($rf);
			return true;
		}
		function export($mod = "db", $dirtobackup = "", $tipo = "mysql") {
		        $export_reg = "(.)+([\\|\/]{1})([a-z0-9\.\_\-]+)";
			$head = "# Dump author: Andrea Giammarchi [ andr3a ] [ www.3site.it ]\r";
			$head .= "# Powered by : ".$_SERVER["SERVER_SOFTWARE"]."\r# Dump for ";
			$head .= "database: ".$this->db."\r# Date: ".date("Y/m/d H:i:s")."\r";
			$head .= "# ________________________________________________________________; \r\n";
			$dirtobackup = $dirtobackup == "" ? $this->highlight_path($this->pthigh) : $dirtobackup;
			$tables = Array();
			if($tipo=="mysql") {
				$q = $this->query("SHOW TABLES");
				while($s = mysql_fetch_assoc($q)) {
	             			 while(list(,$v) = each($s)) {
	             				$tables[] = $v;
	                  		}
				}
			}
			elseif($tipo=="sqlite") {
			        $q = $this->query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;");
			        while($s = $this->fetch_assoc()) {
			                while(list(,$v) = each($s)) {
	             				$tables[] = $v;
	                  		}
				}
			}
			else {
	   			die("Don't change last value of this function.");
			}
			if($mod=="db") {
				$createout = "";
				$instout = "";
				for($i=0; $i<count($tables); $i++) {
					// Creation TABLES
					if($tipo=="mysql") {
					        $q = $this->query("SHOW CREATE TABLE ".$tables[$i]);
		  				$s = mysql_fetch_assoc($q);
		  				$createout .= "DROP TABLE IF EXISTS ".$tables[$i]."; \r\n".$s["Create Table"]."; \r\n";
					}
					elseif($tipo=="sqlite") {
						$q = $this->query("SELECT sql FROM sqlite_master WHERE type='table' and name='".$tables[$i]."';");
						$s = $this->fetch_assoc();
						$createout .= str_replace("`", "", $s["sql"])."; \r\n";
					}
					// Contents TABLES
	   				$q = mysql_unbuffered_query("SELECT * FROM ".$tables[$i]);
	   				if($tipo=="mysql") {
		  				while($s = mysql_fetch_assoc($q)) {
							$on = "";
		             				while(list(,$v) = each($s)) {
								$on .= is_Numeric($v) ? $v.", " : "\"".addcslashes(addslashes($v), "\0..\37")."\", ";
							}
							$instout .= "INSERT INTO ".$tables[$i]." VALUES (".substr($on, 0, strlen($on)-2)."); \r\n";
						}
					}
					elseif($tipo=="sqlite") {
					        while($s = $this->fetch_assoc()) {
		             				$on = "";
		             				while(list(,$v) = each($s)) {
								$on .= is_Numeric($v) ? $v.", " : "\"".addcslashes(addslashes($v), "\0..\37")."\", ";
							}
							$instout .= "INSERT INTO ".$tables[$i]." VALUES (".substr($on, 0, strlen($on)-2)."); \r\n";
						}
					}
				}
				$filename = $dirtobackup.eregi_replace($export_reg, "\\3", $this->db)."[".date("Ymd")."].sql";
				$toput = $createout.$instout;
   			}
   			elseif($mod=="structure") {
				$createout = "";
				for($i=0; $i<count($tables); $i++) {
					// Creation TABLES
					if($tipo=="mysql") {
					        $q = $this->query("SHOW CREATE TABLE ".$tables[$i]);
		  				$s = mysql_fetch_assoc($q);
		  				$createout .= "DROP TABLE IF EXISTS ".$tables[$i]."; \r\n".$s["Create Table"]."; \r\n";
					}
					elseif($tipo=="sqlite") {
						$q = $this->query("SELECT sql FROM sqlite_master WHERE type='table' and name='".$tables[$i]."';");
						$s = $this->fetch_assoc();
						$createout .= str_replace("`", "", $s["sql"])."; \r\n";
					}
				}
				$filename = $dirtobackup.eregi_replace($export_reg, "\\3", $this->db)."[structure][".date("Ymd")."].sql";
				$toput = $createout;
			}
			elseif($mod=="data") {
				$instout = "";
				for($i=0; $i<count($tables); $i++) {
					// Contents TABLES
	   				$q = mysql_unbuffered_query("SELECT * FROM ".$tables[$i]);
	   				if($tipo=="mysql") {
		  				while($s = mysql_fetch_assoc($q)) {
							$on = "";
		             				while(list(,$v) = each($s)) {
								$on .= is_Numeric($v) ? $v.", " : "\"".addcslashes(addslashes($v), "\0..\37")."\", ";
							}
							$instout .= "INSERT INTO ".$tables[$i]." VALUES (".substr($on, 0, strlen($on)-2)."); \r\n";
						}
					}
					elseif($tipo=="sqlite") {
					        while($s = $this->fetch_assoc()) {
		             				$on = "";
		             				while(list(,$v) = each($s)) {
								$on .= is_Numeric($v) ? $v.", " : "\"".addcslashes(addslashes($v), "\0..\37")."\", ";
							}
							$instout .= "INSERT INTO ".$tables[$i]." VALUES (".substr($on, 0, strlen($on)-2)."); \r\n";
						}
					}
				}
				$filename = $dirtobackup.eregi_replace($export_reg, "\\3", $this->db)."[data][".date("Ymd")."].sql";
				$toput = $instout;
			}
			$fc = @fopen($filename, "w+");
			if(!$fc) {
				die("<b><i>Error</i></b> <i>You don't have permission to write file</i> \"{$filename}\"<br />");
			}
			fwrite($fc, $head.$toput);
			fclose($fc);
			return "<a href=\"{$filename}\">download database</a>";
		}
		function import($filename, $tipo = "mysql") {
			$rf = @fopen($filename, "r");
			if(!$rf) {
				$nofound = "<b><i>Error</i></b> <i>file</i> \"{$filename}\" <i>not found.</i>";
				return $nofound;
			}
			$l_ar = fread($rf, filesize($filename));
			fclose($rf);
			$l_ar = explode("; \r\n", $l_ar);
			if($tipo=="mysql") {
				for($i=1; $i<(count($l_ar)-1); $i++) {
					mysql_unbuffered_query($l_ar[$i]) or die("<b>Import error.</b><br />".mysql_error());
				}
   			}
   			elseif($tipo=="sqlite") {
      				for($i=1; $i<(count($l_ar)-1); $i++) {
					sqlite_unbuffered_query($this->cnt, $l_ar[$i]) or die("<b>Import error.</b><br />".$l_ar[$i]);
				}
			}
		}
		function separator() {
			return "; \r\n";
		}
		function close() {
	        	return @mysql_close();
	    	}
	}
	// Extended class for SQLite
	// Author: Andrea Giammarchi [andr3a] [www.3site.it] [andrea@3site.it]
	//
	// full SQLite PHP features at [ http://www.zend.com/manual/ref.sqlite.php ]
	Class my_sqlite extends my_sql {
		var $db, $c_q, $my_queries, $my_times, $q_limit, $f_limit, $js_lengcheck, $pthigh, $md, $last_error;
		function connect($d, $i = 0666) {
			$this->db = $d;
                        $this->md = $i;
			$this->cnt = @sqlite_open($this->db, $this->md, $sqliteerror);
			if(!$this->cnt) {
				 $this->error($sqliteerror, $this->db);
				 return false;
			}
			return true;
		}
		function pconnect($d, $i = 0666) {
			$this->db = $d;
                        $this->md = $i;
			$this->cnt = @sqlite_popen($this->db, $this->md, $sqliteerror);
			if(!$this->cnt) {
				 $this->error($sqliteerror, $this->db);
				 return false;
			}
			return true;
		}
		function create_db($db) {
			die("You can't create <b>{$db}</b>. You're just using <b>{$this->db}</b>.");
		}
		function query($q, $umb = false) {
			$this->c_q++;
			if(in_array($q, $this->my_queries)) {
				$this->my_queries[] = "<b>[ Replicated Query ]</b><br />".$q;
			}
			else {
				$this->my_queries[] = $q;
			}
			$start_time = $this->time_elapsed_capture();
			if($umb == false) {
				$this->myq = @sqlite_query($this->cnt, $q);
   			}
   			else {
				$this->myq = @sqlite_unbuffered_query($this->cnt, $q);
      			}
      			$this->my_times[] = $this->time_elapsed_print($start_time,$this->time_elapsed_capture());
			if(!$this->myq) {
				$this->error($php_errormsg, $q);
				return false;
			}
			unset($start_time);
			return true;
		}
		function show_fetch($nq = "", $width="500px", $border="solid #EAEAEA", $bg="#F8F8F8", $color="#000000", $bg2="#FCFCFC") {
			return parent::show_fetch($nq, $width, $border, $bg, $color, $bg2, $tipo = "sqlite");
		}
		function fetch_array($type=SQLITE_BOTH, $dec_bin=TRUE) {
			return sqlite_fetch_array($this->myq,$type,$dec_bin);
		}
		function fetch_assoc($dec_bin=TRUE) {
			return sqlite_fetch_array($this->myq,SQLITE_ASSOC,$dec_bin);
		}
		function array_query($q, $type=SQLITE_BOTH, $dec_bin=TRUE) {
			return sqlite_array_query($this->cnt,$q,$type,$dec_bin);
		}
		function connection_timeout($millisecondi) {
			sqlite_busy_timeout($this->cnt, $millisecondi);
			return true;
		}
		function fetch_first() {
			return sqlite_fetch_string($this->myq);
		}
		function affected_rows() {
			return sqlite_changes($this->cnt);
		}
		function column($column_name, $dec_bin=TRUE) {
			return sqlite_column($this->myq, $column_name, $dec_bin);
		}
		function insert_id() {
			return sqlite_last_insert_rowid($this->cnt);
		}
		function field_name($q) {
			return sqlite_field_name($this->myq, $q);
		}
		function num_fields() {
			return sqlite_num_fields($this->myq);
		}
		function num_rows() {
			return sqlite_num_rows($this->myq);
		}
		function unbuffered_query($q) {
		        return $this->query($q, true);
		}
		function export($mod = "db", $dirtobackup = "") {
  			return parent::export($mod, $dirtobackup, $tipo = "sqlite");
		}
		function import($filename) {
  			return parent::import($filename, "sqlite");
		}
		function close() {
			return @sqlite_close($this->cnt);
		}
	}
?>

