<?php
	/***********************************************************************
	* Funzione Nazionalita'
	* autore: andr3a / mdsjack
	* CSV: http://ip-to-country.directi.com/
	************************************************************************/
	function ip2country($type, $where = "guest_file/") {
		// Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
		// Author: mdsjack [ www.mdsjack.tk/ ] [ mdsjack@iol.it ]
		$ip = split("[.]", $_SERVER["REMOTE_ADDR"]);
		$ip = ($ip[0] * 16777216) + ($ip[1] * 65536) + ($ip[2] * 256) + ($ip[3]);
		$csv = fopen($where."ip-to-country.csv", "r");
		while ($line = fgetcsv($csv, 1024)) {
			list ($from, $to, $code[0], $code[1], $code[2]) = $line;
			if (($from <= $ip) and ($to >= $ip)) {
				fclose($csv);
				$sended = isSet($code[$type-1]) && $code[$type-1]!='' ? $code[$type-1] : "UNK";
				return $sended;
			}
		}
		fclose($csv);
		return "YOU";
	}


	/***********************************************************************
	* Funzione check mail
	* autore: andr3a
	************************************************************************/
	function check_mail($m) {
	        // Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
		$r = "([a-z0-9]+[\.|_|\-]{0,1}){1,3}[a-z0-9]+";
		$r = "^{$r}\@{1}{$r}\.{1}[a-z0-9]{2,6}$";
		return eregi($r, $m);
	}

	/***********************************************************************
	* Doppia funzione tempo trascorso
	* autore: andr3a
	************************************************************************/
	function time_elapsed_capture() {
		list($u, $s) = explode(" ",microtime());
		return ((float)$u + (float)$s);
	}
	function time_elapsed_print($item1, $item2, $rd=6) {
		return round(($item2-$item1), $rd);
	}


	/*****************************************
	* funzione di controllo stringa
	*	esegue comunque il replace se sistente
	* autore: andr3a
	******************************************/
	function str_incounter($match,$string) {
	        // Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
		$count_match = 0;
		for($i=0;$i<strlen($string);$i++) {
			if(strtolower(substr($string,$i,strlen($match)))==strtolower($match)) {
				$count_match++;
			}
		}
		return $count_match;
	}

	/*****************************************
	* funzione di controllo url
	*	esegue controlla che l'url sia valido
	* autore: vari dal web
	*
	* ... prima o poi la riscrivo ...
	******************************************/
	function url_validator($url,$bc,$c,$trasform = true) {
	        // Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
		if($trasform == true) {
			$url = eregi_replace("((htt[p|ps]|ftp){1}(\:\/\/){1}([^[:space:]]+){1,})", "<a style=\"text-decoration: none; color: ".$c."; background-color: ".$bc.";\" href=\"\\1\" onClick=\"window.open(this.href,'_blank'); return false;\">\\1</a>", $url);
			return $url;
		}
		else {
			return eregi("(^(htt[p|ps]|ftp){1}(\:\/\/){1}([^[:space:]]+){1,}$)", trim($url));
		}
	}


	/***********************************************************************
	* funzione di controllo stringa
	*	a differenza del wordwrap non applica il separatore a tutto il testo
	* autore: andr3a
	************************************************************************/
	function wrap_selected($text,$size,$tag = " ") {
	        // Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
		if(isSet($text)&&isSet($size)) {
			$ex = explode(" ",$text);
			$rp = array();
			for($i=0; $i<count($ex); $i++) {
				if(strlen($ex[$i])>$size) {
					if(!eregi("^(htt[p|ps]|ftp){1}(\:\/\/){1}([^[:space:]]+){1,}$", $ex[$i])) {
						$where = 0;
						$rp[$i] = "";
						for($b=0; $b<(ceil(strlen($ex[$i])/$size)); $b++) {
							$rp[$i] .= substr($ex[$i],$where,$size).$tag;
							$where += $size;
						}
					}
					else {
						$rp[$i] = strlen($ex[$i]) > ($size+round($size/2)) ? substr(strtolower($ex[$i]),0,($size+round($size/2))) : strtolower($ex[$i]);
					}
				}
				else {
					$rp[$i] = $ex[$i];
				}
			}
			return implode(" ",$rp);
		}
		return false;
	}

	/*******************************************
	* funzione di controllo OS
	*	restituisce il sistema operativo in uso
	* autore: chris con modifiche di andr3a
	********************************************/
	function show_OS() {
	        // Author: chris / andr3a
		$UserAgent = $_SERVER["HTTP_USER_AGENT"];
		if(strpos($UserAgent, "Windows 98") !== false) {
			$os = "Windows 98";
		}
		elseif(strpos($UserAgent, "Win 98") !== false) {
			$os = "Windows 98 SE";
		}
		elseif(strpos($UserAgent, "Win98") !== false) {
			$os = "Windows 98 SE";
		}
		elseif(strpos($UserAgent, "Windows 95") !== false) {
			$os = "Windows 95";
		}
		elseif(strpos($UserAgent, "Win 95") !== false) {
			$os = "Windows 95";
		}
		elseif(strpos($UserAgent, "Win95") !== false) {
			$os = "Windows 95";
		}
		elseif(strpos($UserAgent, "Windows 2000") !== false) {
			$os = "Windows 2000";
		}
		elseif(strpos($UserAgent, "Windows NT 5.0") !== false) {
			$os = "Windows 2000";
		}
		elseif(strpos($UserAgent, "Windows NT 5.1") !== false) {
			$os = "Windows XP";
		}
		elseif(strpos($UserAgent, "Windows NT 4") !== false) {
			$os = "Windows NT";
		}
		elseif(strpos($UserAgent, "Win NT") !== false) {
			$os = "Windows NT";
		}
		elseif(strpos($UserAgent, "Windows NT") !== false) {
			$os = "Windows NT";
		}
		elseif(strpos($UserAgent, "WinNT4.0") !== false) {
			$os = "Windows NT 4.0";
		}
		elseif(strpos($UserAgent, "Mac") !== false) {
			$os = "Macintosh";
		}
		elseif(strpos($UserAgent, "linux") !== false) {
			$os = "Linux";
		}
		elseif(strpos($UserAgent, "Linux") !== false) {
			$os = "Linux";
		}
		elseif(strpos($UserAgent, "X11") !== false) {
			$os = "Linux";
		}
		elseif(strpos($UserAgent, "UNIX") !== false) {
			$os = "Unix";
		}
		elseif(strpos($UserAgent, "Unix") !== false) {
			$os = "Unix";
		}
		elseif(strpos($UserAgent, "unix") !== false) {
			$os = "Unix";
		}
		elseif(strpos($UserAgent, "Windows ME") !== false) {
			$os = "Windows ME";
		}
		elseif(strpos($UserAgent, "Win9x 4.90") !== false) {
			$os = "Windows ME";
		}
		elseif(strpos($UserAgent, "SunOS") !== false) {
			$os = "Sun OS";
		}
		elseif(strpos($UserAgent, "Win 3.1") !== false) {
			$os = "Windows 3.1";
		}
		elseif(strpos($UserAgent, "FreeBSD") !== false) {
			$os = "FreeBSD";
		}
		elseif(strpos($UserAgent, "WebTV") !== false) {
			$os = "WebTV";
		}
		elseif(strpos($UserAgent, "Eversion Avenger") !== false) {
			$os = "Eversion Avenger";
		}
		else {
			$os = "Sconosciuto";
		}
		return $os;
	}

	/*******************************************
	* funzione di controllo BROWSER
	*	restituisce il browser utilizzato
	* autore: chris con modifiche di andr3a
	********************************************/
	function show_BROWSER() {
	        // Author: chris / andr3a
		$UserAgent = $_SERVER["HTTP_USER_AGENT"];
		if(strpos($UserAgent, "compatible; MSIE 5.5") !== false) {
			$browser = "I.E. 5.5";
		}
		elseif(strpos($UserAgent, "Lynx/") !== false) {
			$browser = "Linx";
		}
		elseif(strpos($UserAgent, "Konqueror") !== false) {
			$browser = "Konqueror";
		}
		elseif(strpos($UserAgent, "Galeon") !== false) {
			$browser = "Galeon";
		}
		elseif(strpos($UserAgent, "Opera/7.") !== false) {
			$browser = "Opera 7";
		}
		elseif(strpos($UserAgent, "Opera 7.") !== false) {
			$browser = "Opera 7";
		}
		elseif(strpos($UserAgent, "Opera/6.") !== false) {
			$browser = "Opera 6";
		}
		elseif(strpos($UserAgent, "Opera 6.") !== false) {
			$browser = "Opera 6";
                }
		elseif(strpos($UserAgent, "Netscape/7") !== false) {
			$browser = "Netscape 7";
		}
		elseif(strpos($UserAgent, "Netscape/6") !== false) {
			$browser = "Netscape 6";
		}
		elseif(strpos($UserAgent, "compatible; MSIE 6.0") !== false) {
			$browser = "I.E. 6";
		}
		elseif(strpos($UserAgent, "MSIE 5") !== false) {
			$browser = "I.E. 5";
		}
		elseif(strpos($UserAgent, "MSIE 4") !== false) {
			$browser = "I.E. 4";
		}
		elseif(strpos($UserAgent, "Opera/5") !== false) {
			$browser = "Opera 5";
		}
		elseif(strpos($UserAgent, "Opera 5") !== false) {
			$browser = "Opera 5";
		}
		elseif(strpos($UserAgent, "Mozilla/4") !== false) {
			$browser = "Netscape 4";
		}
		elseif(strpos($UserAgent, "Mozilla/3") !== false) {
			$browser = "Netscape 3";
		}
		elseif(strpos($UserAgent, "Mozilla/5.") !== false) {
			if(strpos($UserAgent, "rv") !== false) {
				$c = explode(")", $UserAgent);
				$a = explode("rv:", strtolower($c[0]));
				$browser = "Mozilla ".str_replace(" ", "", $a[1]);
			}
			else {
				$browser = "Mozilla 1.x";
			}
		}
		elseif(strpos($UserAgent, "Mozilla") !== false) {
			$browser = "Mozilla";
		}
		elseif(strpos($UserAgent, "Elinks") !== false) {
			$browser = "Elinks";
		}
		elseif(strpos($UserAgent, "Chorus/MiX") !== false) {
			$browser = "Chorus/MiX";
		}
		else {
			$browser = isSet($gug_br) && $gug_br!="" ? $gug_br : "Sconosciuto";
		}
		return $browser;
	}

	/*******************************************
	* funzione di controllo percentuali
	* con generazione automatica o scelta
	* di barre e calcolo percentuale V2 [tabella]
	* autore: andr3a
	********************************************/
	Class percent {
	        // Author: andr3a [ www.3site.it ] [ andrea@3site.it ]
       		var $max_range;
		var $min_range;
		function percent($max=100, $min=0) {
			$this->max_range = $max;
			$this->min_range = $min;
		}
		function portion($num) {
			return round((($num*100)/$this->max_range), 2);
		}
		function array_portion($ar) {
			$now_ar = Array();
			$i = 0;
			$now_ar["total"] = 0;
			while(list($k,$v) = each($ar)) {
				$now_ar["total"] += $v;
				$now_ar[$i][0] = $v;
				$now_ar[$i][1] = $k;
				$i++;
			}
			$this->max_range = $now_ar["total"];
			$result_ar = Array();
			for($a=0; $a<$i; $a++) {
				$now_ar[$a][0] = $this->portion($now_ar[$a][0]);
				$result_ar[$now_ar[$a][1]] = $now_ar[$a][0];
			}
			return $result_ar;
		}
		function bar($long,$border="#000000",$fill="#EFEFEF",$verso="h",$large=8,$max=300,$alt="") {
			if(strtolower($verso) != "h") {
				$x = $large;
				$y = $long > 1 ? $long : 1;
				$y = ($max*$y)/100;
			}
			else {
				$x = $long > 1 ? $long : 1;
				$y = $large;
				$x = ($max*$x)/100;
			}
			$out = "<table cellspacing=\"0\" cellpadding=\"0\" style=\"color: {$border}; background-color: {$fill}; border: 1px solid {$border}; width: {$x}px; height: {$y}px; \"><tr><td></td></tr></table>\r";
			return $out;
		}
		function array_bar($ar,$border="#787878",$fill="#FAFAFA",$large=4,$max=300) {
			$out = "";
			while(list($k,$v) = each($ar)) {
				$out .= $this->bar($v,$border,$fill,"h",$large,$max,$k)." [".$v."%] <b>".$k."</b><br /> &nbsp; ";
			}
			return $out;
		}
	}
?>

