<?
// ######################################################################
// # JGB (Justice Guestbook) - Global Functions 			#
// # -------------------------------------------------------------------#
// # Leave this header in every file !!!				#
// # -------------------------------------------------------------------#
// # Copyright  2001, 2002 by Justice Media				#
// # Contact: kontakt@justice-media.de					#
// # Homepage: http://www.justice-media.de				#
// ######################################################################
// #  Justice Media offers no warranties on this script.		#
// #  The owner/licensee of the script is solely responsible for any	#
// #  problems caused by installation of the script or use of the	#
// #  script, including messages that may be posted on the JGB. 	#
// #									#
// #  All copyright notices regarding the Justice Guestbook must	#
// #  remain intact on the scripts and in the Code for the scripts.	#
// #  For further information read the licence.txt.			#
// #									#
// #  For more info on the Justice Guestbook,				#
// #  see http://www.justice-media.de					#
// ######################################################################

require("admin/config.php");
require("admin/mysql_class.php");

$db_sets = new db_mysql_jm;

//$db_sets->appname="";
//$db_sets->appshortname="";
$db_sets->database=$dbname;
$db_sets->host=$hostname;
$db_sets->user=$dbuser;
$db_sets->password=$dbpwd;

$db_sets->connect();

//create the array with the settings
$settings_rs = $db_sets->query("SELECT * FROM $table_settings");
while($sets = $db_sets->fetch_array($settings_rs)) {
  $set_arr[$sets["title"]] = $sets["content"];
}

################################ Start getentries ################################
function getentries() {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    $getentries_rs = $db_sets->query("SELECT * FROM $table_entries WHERE active = '0' ORDER BY entrydate");
    return $getentries_rs;
}

################################ Start getlimitentries ################################
function getlimitentries($start,$limit) {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    if($start == "" || $start < 0)
	$start = 0;
    $getentries_rs = $db_sets->query("SELECT id,name,email,homepage,icq,aim,yim,age,location,entry,ipaddress,hostname,date_format(entrydate,'%d.%m.%Y %H:%i') FROM $table_entries WHERE active = '0' ORDER BY entrydate DESC LIMIT $start,$limit");
    return $getentries_rs;
}

################################ Start getoneentry ################################
function getoneentry($id) {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    $getentries_rs = $db_sets->query("SELECT id,name,email,homepage,location,entry,ipaddress,hostname,date_format(entrydate,'%d.%m.%Y %H:%i')  FROM $table_entries WHERE id='$id'");
    return $getentries_rs;
}

################################ Start addentry ################################
//currently not used
function addentry($file,$name,$email,$homepage,$location,$text) {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    $ip = $REMOTE_ADDR;
    $host = $REMOTE_HOST;
    $date = date("y-m-d H:i:s");
    $entry_rs = $db_sets->query("INSERT INTO $table_entries (name,email,homepage,location,entry,ipaddress,hostname,entrydate)
			     VALUES ('$name','$email','$homepage','$location','$text','$ip','$host','$date')");
}

################################ Start getsets ################################
function getsets($settingtitle) {
  global $db_sets,$table_settings,$table_entries,$table_smilies,$set_arr;
  $setting = $set_arr[$settingtitle];
  return $setting;
}

################################ Start is_email ################################
function is_email($email) {
    $ret=false;
    if(strstr($email, '@') && strstr($email, '.')){
      if(eregi("^([_a-z0-9]+([\\._a-z0-9-]+)*)@([_a-z0-9]+([\\._a-z0-9-]{2,})*\\.[a-z]{2,3})$", $email)){
	$ret=true;
      }
    }
    return $ret;
}

################################ Start nolongwords ################################
function nolongwords($text) {
    $text_arr = explode(" ",$text);
    $text="";
    $maxlaenge=getsets("maxlength");
    for ($i=0;$i<count($text_arr);$i++){
	$text_arr[$i].=" ";
	$laenge = strlen($text_arr[$i]);
	if($laenge>=$maxlaenge){
	    $word1 = substr($text_arr[$i],0,$maxlaenge);
	    $rest = substr($text_arr[$i],$maxlaenge,$laenge);
	    $zaehler = $laenge / $maxlaenge;
	    $zaehler = round($zaehler);
	    $words = "";
	    for($z=1;$z<$zaehler;$z++) {
	       $getword = substr($rest,0,$maxlaenge);
	       $words.= $getword." ";
	       $rest = substr($rest,$maxlaenge,$laenge);
	    }
	    $text.= $word1." ".$words;
	}
	else
	    $text.=$text_arr[$i];
    }
    return $text;
}

################################ Start censortext ################################
function censortext($text) {
	 global $db_sets,$table_settings,$table_entries,$table_smilies;
	 $censorwords = getsets("censorwords");
	 $censorarray = explode(";", $censorwords);
	 $arraylength = count($censorarray);
	 for($censor = 0;$censor<$arraylength;$censor++) {
	      $text = str_replace($censorarray[$censor],"****",$text);
	      $text = str_replace(ucfirst($censorarray[$censor]),"****",$text);
	 }
	 return $text;
}

################################ Start smiletext ################################
function smiletext($text) {
	 global $db_sets,$table_settings,$table_entries,$table_smilies;
	 $smilies_rs = $db_sets->query("SELECT * FROM $table_smilies");
	 while($smilies = $db_sets->fetch_array($smilies_rs)) {
	    $smiletext = $smilies["smilietext"];
	    $smileurl = $smilies["smilieurl"];
	    $smileurl = "<img src=\"$smileurl\">";
	    $text = str_replace($smiletext,$smileurl,$text);
	 }
	 return $text;
}

################################ Start showsmilies ################################
function showsmilies() {
	 global $db_sets,$table_settings,$table_entries,$table_smilies;
		 $zaehler = 0;
	 $smilies_rs = $db_sets->query("SELECT * FROM $table_smilies");
	 while($smilies = $db_sets->fetch_array($smilies_rs)) {
	    $smiletext = $smilies["smilietext"];
	    $smileurl = $smilies["smilieurl"];
			if($zaehler == getsets("smile_count") && getsets("smile_count") != 0) {
				$zaehler = 0;
				$smilecode.= "<br>";
			}
	    $smilecode.= "<A HREF=\"javascript:Insertsmile(' $smiletext ')\"><IMG SRC=\"$smileurl\" BORDER=\"0\"></A>&nbsp;&nbsp;";
		$zaehler = $zaehler + 1;
		 }
	 return $smilecode;
}

################################ Start emailmaster ################################
function emailtomaster($name,$email,$homepage,$location,$text,$ip,$hostname,$date) {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    $mail_text="Un nuovo messaggio  stato lasciato nel guestbook. ".getsets('contacturl')." .\n\n";
    $mail_text.="$name ha inserito il seguente messaggio:\n";
    $mail_text.="$text\n";
    $mail_text.="Email:$email";
    @mail(getsets('masteremail'),"Nuovo messaggio nel JGB","$mail_text");
}

################################ Start emailuser ################################
function emailtouser($name,$email,$homepage,$location,$text,$ip,$hostname,$date) {
   global $db_sets,$table_settings,$table_entries,$table_smilies;
   $contactmail = getsets("contactemail");
   $mail_text.= getsets("emailtext");
   @mail($email,getsets('emailsubject'),"$mail_text","From:$contactmail.\nReply-To:$contactmail.");
}

################################ Start emailuser ################################
function checkspam($spamid) {
    global $db_sets,$table_settings,$table_entries,$table_smilies;
    $checkspam_rs = $db_sets->query("SELECT date_format(entrydate,'%d.%m.%Y') FROM $table_entries WHERE spamid='$spamid'");
    $checkspam = $db_sets->num_rows($checkspam_rs);
    if($checkspam != 0) {
      $today = date("d.m.Y");
      $check = $db_sets->fetch_array($checkspam_rs);
      $spamdate = $check[0];
      if($today != $spamdate)
	  $spam = "no";
      else
	  $spam = "yes";
    }
    else
	$spam = "no";
    return  $spam;
}

################################ Start emailuser ################################
function checkurl($url) {
    $checkurl = strpos($url,"ttp://");
    if($checkurl != 1)
	$url = "http://$url";
    return  $url;
}

################################ Start getversion ################################
function getversion() {
	 global $db_sets,$table_settings,$table_entries,$table_smilies;
	 $version_rs = $db_sets->query("SELECT * FROM $table_settings WHERE title='version'");
	 $version = $db_sets->fetch_array($version_rs);
	 $version = $version["content"];
	 return $version;
}

################################ Start hidden ################################
function hidden($HTTP_POST_VARS){
  //put the variables from a submit form into hiddenfields
  while(list($key,$value)=each($HTTP_POST_VARS)):
	echo "<input type=\"Hidden\" name=\"$key\" value=\"$value\">\n";
  endwhile;
}

################################ Start getfields ################################
function getfields($HTTP_POST_VARS){
  //put the variables from a submit form into hiddenfields
  while(list($key,$value)=each($HTTP_POST_VARS)):
	echo "<input type=\"Hidden\" name=\"$key\" value=\"$value\">\n";
  endwhile;
}

################################ Start showfield ################################
function showfield($fieldname, $value) {
	global $signcolor;
	if(getsets("require".$fieldname) != 0 || $fieldname == "name") {
		$require = "*";
	}
	$output.= "<TR bgcolor=\"" . getsets("tb_bgcolor") . "\">";
    $output.= "<TD><FONT SIZE=\"" . getsets("fontnormal") . "\" FACE=\"" . getsets("fontface") . "\" COLOR=\"" . getsets("fontentrycolor") . "\">".$signcolor["$fieldname"].getsets($fieldname."_text") . " $require</FONT></td>";
    $output.= "<TD><INPUT TYPE=\"TEXT\" NAME=\"$fieldname\" VALUE=\"$value\" SIZE=20></td>";
    $output.= "</tr>";
	return $output;
}

//################################ Start make_pagenav ################################
function make_pagenav($page, $maxpagesperpage, $pages)
{
	global $db;
	
	$nodouble = "no";
	
	if($pages < $maxpagesperpage) {
		$maxpagesperpage = $pages;
	}

	if($page <= $maxpagesperpage/2) {
		$pagestart = 1;
	} else {
		$pagestart = 1 + ($page-($maxpagesperpage/2));
		if($maxpagesperpage+$pagestart > $pages) {
			$nodouble = "yes";
			$pagestart = $pages-$maxpagesperpage+1;
		}
	}
	
	if($pagestart > 1) {
		$pagenav.= "<a href=jgb.php?page=1>&laquo;</a>&nbsp;&nbsp;";
	}
	
	for($i=$pagestart;$i<$maxpagesperpage+$pagestart;$i++) {
		if($i == $pagestart && $page > 1) {
			$prepage = $page-1;
			$pagenav.=  "<a href=\"jgb.php?page=$prepage\"></a>&nbsp;";
		}
		
		if($page == $i) {
			$pagenav.=  "<a href=\"jgb.php?page=$i\">[$i]</a>&nbsp;";
		} else {
			$pagenav.=  "<a href=\"jgb.php?page=$i\">$i</a>&nbsp;";
		}
		
		if($i==$maxpagesperpage+$pagestart-1 && $page != $pages) {
			$nextpage = $page+1;
			$pagenav.=  "<a href=\"jgb.php?page=$nextpage\"></a>&nbsp;";
		}
	}
	if($nodouble != "yes" && $maxpagesperpage < $pages) {
		$pagenav.=  "<a href=jgb.php?page=$pages>&raquo;</a>";
	}
	
	return $pagenav;
}
?>
