<?php
// Funzione per l'inizializzazione dei files di testo
function inizialize($fpath,$text="")
{
	$file=fopen($fpath,"w");
	flock($file,2);
	fputs($file,$text);
	flock($file,3);
	fclose($file);
}

// Funzione per la creazione dei un'array dei files in una directory
function dir2arr($dir)
{
	$dir=opendir($dir);
	while($file = readdir($dir)):
		if ($file != "." && $file != ".." && eregi("\.[a-z]{3}",$file)): #
			$arr[count($arr)] = substr($file,0,strlen($file)-4);
		endif;
	endwhile;
	closedir($dir); 	
	return $arr;
}

// Funzione per il linguaggio
function lang($which)
{
	global $lang;
	$translated=$lang[LANGUAGE][$which];
	return $translated;
}

// Funzione per il numero delle firme nel guestbook
function visitatori()
{
	$file=fopen(DATA,"r");
	$visitatori=str_replace("id=","",trim(fgets($file,1024)));
	fclose($file);
	chop($visitatori);
	$cifre = preg_split("//", $visitatori);
	for($i = 0; $i <= $visitatori; $i++) {
		if ($cifre[$i] != "") {
			$ospiti .= "<img src=\"".DIGIT.$cifre[$i].".gif\" alt=\"".$cifre[$i]."\" align=\"absmiddle\">";
		}
	}
	if($ospiti==""):
		$ospiti .= "<img src=\"".DIGIT."0.gif\" alt=\"0\" align=\"absmiddle\">";
	endif;
	$ospiti .= "<img alt=\"\" border=\"0\" src=\"".IMG."guests.gif\" align=\"absmiddle\">";
	if($visitatori!=1):
		$ospiti .= "<img src=\"".DIGIT."5.gif\" alt=\"0\" align=\"absmiddle\">";
	endif;
	return $ospiti;
}

// Funzione per la creazione del file di bloccaggio
function lock($status)
{
	if($status==1):
		$file=fopen(LOCK,"w");
		fclose($file);
	elseif($status==0):
		unlink(LOCK);
	endif;
}

// Funzione per il filtro delle parole
function filter($text)
{
	$file=fopen(WORD,"r");
	while(!feof($file)):
		$words[]=trim(fgets($file,1024));
	endwhile;
	fclose($file);
	for($i=0;$i<sizeof($words);$i++):
		$replacement="";
		for($j=0;$j<strlen($words[$i]);$j++):
			$replacement.="*";
		endfor;
		$text=eregi_replace($words[$i],$replacement,$text);
	endfor;
	return $text;
}

// Funzioni per la creazione dell' HTML
function parseMsg($msg)
{
	$smile=dir2arr(SMILE);
	$newlinesymbol=":nl:";
	$br="<br>";
# Converte i caratteri pericolosi / Ridimensiona la lunghezza / Applica il filtro del linguaggio / Rimuove gli spazi eccessivi
	$msg=str_replace("\r\n"," ".$newlinesymbol." ",trim(stripslashes(htmlentities(strip_tags(substr($msg,0,MSGLEN))))));
	if(WORDFILTER==1):
		$msg=filter($msg);
	endif;
	for($i=1;$i<=substr_count($msg,"  ");$i++):
		$msg=str_replace("  "," ",$msg);
	endfor;
# Spezza le parole troppo lunghe
	$words=explode(" ",$msg);
	for($i=0;$i<sizeof($words);$i++):
		if(strlen($words[$i])>26):
			$replacement=chunk_split($words[$i],10," ");
			array_splice($words,$i,1,$replacement);
		endif;
	endfor;
	$msg=implode(" ",$words);
# Rimuove le "nuove linee" eccessive
	$words=explode(" ",$msg);
	for($i=0;$i<=3;$i++):
		if($words[$i]==$newlinesymbol):
			array_splice($words,$i,1,$br);
		endif;
	endfor;
	$msg=implode(" ",$words);
	$msg=str_replace($newlinesymbol," ",$msg);
# Elimina l'ultima parlola se  uno smilie a non terminato
	$words=explode(" ",$msg);
	$lastword=array_pop($words);
	if(ereg("^:[[:alpha:]]{1,9}$", $lastword)):
		$lastword="";
	endif;
	array_push($words,$lastword);
# Sostituisce il codice con gli smilies
	$smileqty=1;
	for($w=0;$w<sizeof($words);$w++):
		for($i=0;$i<sizeof($smile);$i++):
			if(ereg("^:".$smile[$i].":$", $words[$w])):
				if($smileqty<=SMILEISXENTRY): $smileqty++;
					$words[$w]="<img border\"0\" src=\"".SMILE.$smile[$i].".gif\" align=\"absmiddle\">";
				else:
					$words[$w]="";
				endif;
			endif;
		endfor;
	endfor;
	$msg=implode(" ",$words);
	return $msg;
}

function parseMessengerUin($messenger,$uin)
{
	$output="";
	if(!is_numeric($uin)||(strlen($uin)<5)):
		$uin="";
	endif;
	if($uin!=""):
		$uin=strtolower(trim(htmlentities(strip_tags($uin))));
		if($uin!=""):
			switch($messenger):
				case "icq":
					$output="<a href=\"http://wwp.icq.com/scripts/contact.dll?msgto=".$uin."\" target=\"_blank\" onFocus=\"this.blur();\"><img border=\"0\" src=\"".IMG."icq.gif\" align=\"absmiddle\"></a>";
				break;
				case "aim":
					$output="<a href=\"aim:goim?screenname=".$uin."\" target=\"_blank\" onFocus=\"this.blur();\"><img border=\"0\" src=\"".IMG."icq.gif\" align=\"absmiddle\"></a>";
				break;
			endswitch;
		endif;
	else:
		$output="";
	endif;
	return $output;
}

function parseEmail($email)
{
	if(!eregi("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$",$email)):
		$email="";
	endif;
	if($email!=""):
		$email=filter(strtolower(trim(htmlentities(strip_tags($email)))));
		$email="<a href=\"mailto:".$email."\" onFocus=\"this.blur();\"><img border=\"0\" src=\"".IMG."email.gif\" align=\"absmiddle\"></a>";
	endif;
	return $email;
}

function parseWww($www)
{
	@fopen($www,"r") or $www="";
	if($www!=""):
		$www=strtolower(trim(htmlentities(strip_tags($www))));
		$www="<a href=\"".$www."\" target=\"_blank\" onFocus=\"this.blur();\"><img border=\"0\" src=\"".IMG."www.gif\" align=\"absmiddle\"></a>";
	endif;
	return $www;
}

function parseNick($nick)
{
	$nick=filter(substr(trim(htmlentities(strip_tags($nick))),0,NICKLEN));
	return $nick;
}

function parseIp($ip)
{
	if(empty($ip)):
		$ip="";
	endif;
	return $ip;
}

function parsePic($file,$name,$size,$ext)
{
	$pic="";
	$exts=array("image/pjpeg","image/jpeg","image/gif","image/ief","image/png","image/tiff","image/bmp","image/vnd.wap.wbmp","image/x-cmu-raster","image/x-x-portable-anymap","image/x-portable-bitmap","image/x-portable-graymap","image/x-portable-pixmap","image/x-rgb","image/x-xbitmap","image/x-xpixmap","image/x-xwindowdump");
	if(!empty($file)):
		if($size<=MAXPICSIZE):
			for($i=0;$i<sizeof($exts);$i++):
				if($ext==$exts[$i]):
					$imgfilename=PIC.$name;
					copy($file,$imgfilename);
					$pic="<img border=\"0\" src=\"".IMG."pic.gif\" align=\"absmiddle\" onFocus=\"this.blur();\" onClick=\"javascript:var finestra=window.open('".$imgfilename."','picture','width=150,height=150,resizable');finestra.focus();\" style=\"cursor:hand\">";
				endif;
			endfor;
		endif;
	endif;
	return $pic;
}
?>