<?
class clsImageManager{

	var $db_abstraction;
	var $added_image_id;

	function clsImageManager($dblayer) {
	
		$this->db_abstraction = $dblayer;
		if (!$this->db_abstraction->table_exists("images")) {
			$this->db_abstraction->create_table("images","id INT NOT NULL AUTO_INCREMENT, image_data LONGBLOB NOT NULL, image_width INT NOT NULL, image_height INT NOT NULL, image_type CHAR NOT NULL, image_size INT(7) NOT NULL , PRIMARY KEY (id)");
		}
	
	}

	function addImage($img_holder) {
		$theInfo=getImageSize($img_holder);
                if (($theInfo[2]>=1) and ($theInfo[2]<=3)) {
     		    $fields=array("image_data","image_width","image_height","image_type","image_size");
		    $values=array(base64_encode(fread(fopen($img_holder, "r"), filesize($img_holder))),$theInfo[0],$theInfo[1],$theInfo[2],filesize($img_holder));
		    $this->db_abstraction->insert("images",$fields,$values);
		    $this->added_image_id=$this->db_abstraction->insert_id();
                } else {
                    $this->added_image_id=false;
                }
	}

        function addDirectory($thePath) {
                $directory=dir($thePath);
                while ($entry=$directory->read()) {
                    $this->addImage($entry);
                }
        }

	function removeImage($id) {
		$this->db_abstraction->delete("images","id=$id");
	}

	function getImageSize($id) {
		$this->db_abstraction->select("*","images","id=$id");
		list($id,$image_data,$image_width,$image_height,$image_type,$image_size)=$this->db_abstraction->fetch_array();
		return array($image_width,$image_height,$image_type,"width=\"$image_width\" height=\"$image_height\"");
	}
	
	function getScaledImageSize($id,$maxW,$maxH) {
		$this->db_abstraction->select("*","images","id=$id");
		list($id,$image_data,$image_width,$image_height,$image_type,$image_size)=$this->db_abstraction->fetch_array();
                if ($image_width>$maxW) {
                    $ratio=$maxW/$image_width;
                    $image_width=$image_width*$ratio;
                    $image_height=$image_height*$ratio;
                }
                if ($image_height>$maxH) {
                    $ratio=$maxH/$image_height;
                    $image_width=$image_width*$ratio;
                    $image_height=$image_height*$ratio;
                }
		return array($image_width,$image_height,$image_type,"width=\"$image_width\" height=\"$image_height\"");
	}

	function showImage($id) {
		$this->db_abstraction->select("*","images","id=$id");
		list($id,$image_data,$image_width,$image_height,$image_type,$image_size)=$this->db_abstraction->fetch_array();
		switch ($image_type) {
			case 1:
				header("Content-type: image/gif");
				print base64_decode($image_data);
				break;
			case 2:
				header("Content-type: image/jpeg");
				print base64_decode($image_data);
				break;
			case 3:
				header("Content-type: image/png");
				print base64_decode($image_data);
				break;
		}
	}
}
?>
