<?php
	
	require_once '_config_pipho.php';
	
	
	require_once 'Pipho/DeviceInfo.php';
	require_once 'Pipho/FileManager.php';
	

	$device_info	=	Pipho_DeviceInfo::getDeviceInfo();
	
	try
	{
		$pipho			=	new Pipho_FileManager( $device_info, PIPHO_PHOTOS_FOLDER, PIPHO_FORCE_WRITE, PIPHO_PHOTOS_FOLDER_DESTINATION);
		$pipho->init();
		
		$galleries		=	$pipho->getGalleries( true);
	}
	catch (Exception $e)
	{
		die( $e->getMessage());
	}
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	 
	<meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;"/>
	
	<title>Jaipho - iPhone optimized javascript gallery</title>

	<!-- 
		JAIPHO BETA version 0.54.00 - iPhone optimized javascript gallery
		Check on http://www.jaipho.com/ for latest news and source updates 
	 -->
	 
		<link href="jaipho/<?php echo PIPHO_JAIPHO_THEME ?>/jaipho.css" rel="stylesheet" type="text/css"/>
	<?php if (Pipho_DeviceInfo::isIpad()): ?>
		<link href="jaipho/<?php echo PIPHO_JAIPHO_THEME ?>/jaipho-ipad.css" rel="stylesheet" type="text/css"/>
	<?php endif; ?>
	
			<!--
			
			The whole source in one file.
		
			-->	
			
				<script src="jaipho/jaipho-0.54.00-preload-src.js" type="text/javascript"></script>
		
			
	<?php require_once '_config_jaipho.php' ?>

	
</head>

<body>
	
	<script type="text/javascript">
	
	scrollTo(0,1);
	<?php if (Pipho_DeviceInfo::isIpad()): ?>
	var or_mngr	=	new JphUtil_OrientationManager( 768, 1024);
	<?php else: ?>
	var or_mngr	=	new JphUtil_OrientationManager( 320, 480);	// iPhone version
	<?php endif; ?>

	or_mngr.Init();

	</script>
	
   <div class="toolbar">
		<table cellpadding="0" cellspacing="0">
		<tr>
			<td class="wing">
			<!-- 
				<a class="button" href="">
					Back 
				</a>
			--> 
			</td>
			<td class="center">
				All Galeries
			</td>
			<td class="wing"></td>
		</tr>
		</table>
		
    </div>
    
    <ul>
    
    <?php foreach ($galleries as $gallery): ?>
        <li>
			<a href="<?php echo 'index.php?gallery_id='.$gallery->id ?>">
				
				<span class="image">
					<img src="<?php echo $gallery->firstImage->urlThumb ?>"/>
				</span>
				<span class="title">
					<?php echo $gallery->title ?>
				</span>
				<span class="text">
					<?php echo $gallery->description ?>
				</span>
			</a>
        	
        </li>    
    <?php endforeach; ?>
        
    </ul>

</body>
</html>