<?php

require_once("libgmailer.php"); // external library


/**
 * Defines de link for accesing Thumbs generated by GMail. 
 * 
 **/
   define("GM_LNK_THUMB", "https://gmail.google.com/gmail?view=att&disp=thd");

/**
 * GMailerPlus
 * 
 * @package 
 * @author Luis Ignacio Larrateguy
 * @copyright Copyright (c) 2005
 * @version 0.1
 * @license GPL
 * @access public
 **/
class GMailerPlus extends GMailer {
	
	
	/**
	 * GMailerPlus::getThumb()
	 * 
	 * @param string $attid
	 * @param string $msgid
	 * @param string $filename
	 * @return 
	 **/
	function getThumb($attid, $msgid, $filename) {
         if ($this->isConnected() == true) {
            Debugger::say("Start getting attachment...");
            $query = "&attid=".urlencode($attid)."&th=".urlencode($msgid);               
            $fp = fopen($filename, "wb");
            if ($fp) {
               $c = curl_init();
               curl_setopt($c, CURLOPT_FILE, $fp);
               curl_setopt($c, CURLOPT_COOKIE, $this->cookie_str);
               curl_setopt($c, CURLOPT_URL, GM_LNK_THUMB.$query);
               curl_setopt($c, CURLOPT_FOLLOWLOCATION, 1);
               $this->CURL_PROXY($c);
               curl_setopt($c, CURLOPT_SSL_VERIFYHOST, 2);   
               curl_setopt($c, CURLOPT_SSL_VERIFYPEER, FALSE);
               curl_setopt($c, CURLOPT_USERAGENT, GM_USER_AGENT);
               curl_setopt($c, CURLOPT_REFERER, GM_LNK_REFER);
               curl_exec($c);
               curl_close($c);
               fclose($fp);
            } else {
               Debugger::say("Failed to get attachment: cannot fopen the file.");
               return 0;
            }
            Debugger::say("Completed getting attachment.");
            return 1;
         } else {
            Debugger::say("Failed to get attachment: not connected.");
            return 0;
         }
      }

}


?>