<?php
require_once( "GMailerPlus.class.php" );
define( "GIG_LINK_POPUP", 0 ); // popup 
define( "GIG_LINK_INLINE", 1 ); // or inline image? you decide...
define( "GIG_THUMB_RESIZE", 1 ); // Fetch GMAail Thumbs or resize original image?
define( "GIG_THUMB_FETCH", 0 ); // Fetch GMAail Thumbs or resize original image?

/**
 * GImageGallery
 * 
 * @package GImageGallery
 * @author Luis Ignacio Larrateguy 
 * @copyright Copyright (c) 2005
 * @version 0.1.5
 * @license GPL
 * @access public 
 */
class GImageGallery {
	var $gm;
	var $quota;
	var $snapshot;
	var $resize;
	var $photosXRow;

	/**
	 * GImageGallery::GImageGallery()
	 * 
	 * @param string $login 
	 * @param string $pass 
	 * @return null Constructor
	 */
	function GImageGallery( $login, $pass, $timeZone = -3, $session_method = null ) {
		$this->gm = new GMailerPlus();
		if ( is_null( $session_method ) )
			$session_method = GM_USE_COOKIE | GM_USE_PHPSESSION;
		$this->gm->setSessionMethod = $session_method;
		$this->gm->setLoginInfo( $login, $pass, $timeZone );
		$this->photosXRow = 3;              //default 
		$this->resize = GIG_THUMB_FETCH;	//default
		$this->gm->connect();
		$this->quota = 0;
	} 

	/**
	 * GImageGallery::setPhotosXRow()
	 * 
	 * @param integer $n 
	 * @return null How many Photos are going to be shown in a "row"
	 */
	function setPhotosXRow( $n ) {
		$this->photosXRow = $n;
	} 
	/**
	 * GImageGallery::showCategories()
	 * 
	 * @return null Show categories (GMail Labels) with ID. Could be styled with CSS
	 */
	function showCategories() {
		$this->gm->fetchBox( GM_STANDARD, "inbox", 0 );
		$snapshot = $this->gm->getSnapshot( GM_STANDARD );

		if ( $snapshot ) {
			$content = "<div id=\"categories\">\n";
			foreach( $snapshot->label_list as $i ) {
				$dir = urldecode( str_replace( " ", "-", $i ) );
				$content .= "<div id='$dir'><a href=\"index.php?label=$dir\">$i</a></div>\n";
			} 
			$content .= "</div>\n";
		} else {
			$content = "Error al conectar";
		} 
		return $content;
	} 

	/**
	 * GImageGallery::showThumbs()
	 * 
	 * @param string $label 
	 * @param constant $typeLink 
	 * @return null Show thumbnails according to photosXRow. Styled with CSS to make the presentation like a Table
	 */
	function showThumbs( $label , $typeLink = GIG_LINK_ACT ) {
		$this->gm->fetchBox( GM_LABEL, $label, 0 );
		$snapshot = $this->gm->getSnapshot( GM_LABEL );
		$title = array();
		if ( $snapshot ) {
			$total = $snapshot->box_total;
			for ( $i = 0; $i < $total; $i++ ) {
				$convIDs[$i] = $snapshot->box[$i]["id"];
			} 
			foreach ( $convIDs as $key => $convID ) { // para cada conversacion.
				$this->gm->fetchBox( GM_CONVERSATION, $convID, 0 );
				$snapshot = $this->gm->getSnapshot( GM_CONVERSATION );
				if ( $snapshot ) {
					foreach( $snapshot->conv as $msg ) { // para cada mensaje...
						$i = 0;
						$title[$msg["id"]] = $msg["subj"];
						foreach ( $msg["attachment"] as $attachment ) { // para cada adjunto...
							if ( eregi( "jpg|png|gif|jpeg|bmp", $attachment["type"] ) ) {
								$files[$msg["id"]][$i] = $attachment; //solo si es imagen
							} 
							$i++;
						} 
					} 
				} 
			} 
			foreach ( $files as $msg => $images ) { // que comodo es el foreach. si me ve mi profesora me mata
				$check = 0;
				echo "<div class=\"titulo\">" . htmlentities( $title[$msg] ) . "</div>";
				foreach ( $images as $key => $image ) {
					if ( $check == 0 )
						echo "<div class=\"photosRow\">\n\t";
					$uri = "q=" . base64_encode( "a=" . $image["id"] . "&m=" . $msg  . "&tipo=" . $image["type"] . "&size2=" . $image["size"] . "&f=" . $image["filename"]);
					switch ( $typeLink ) {
						case GIG_LINK_POPUP:
							$link = "javascript:popupimg('dl.php?$uri');";
							break;
						case GIG_LINK_ACT:
							$link = "dl.php?$uri";
							break;
						default:;
					} // switch
					echo "<div class=\"thumbnail\"><a href=\"$link\"><img border=0 src=\"th.php?$uri\"></a><br>" . $image["filename"] . "</div>\n";
					$check = ( $check + 1 ) % $this->photosXRow;
					if ( $check == 0 )
						echo "</div>\n";
				} 
				if ( $check != 0 ) // en caso de que terminase el foreach antes...
					echo "</div>\n";
			} 
		} 
	} 

	/**
	 * GImageGallery::getThumb()
	 * 
	 * @param string $linkBase64 
	 * @param number $maxwidth
	 * @param number $maxheight
	 * @return 
	 */
	function getThumb( $linkBase64, $maxwidth = 120, $maxheight = 120 ) {
		$q = base64_decode( $linkBase64 );
		parse_str( $q );
		$a = $this->_filtro( $a );
		$m = $this->_filtro( $m );
		$f = $this->_filtro( $f );
		$tipo = $this->_filtro( $tipo );
		if ( $a && $m && $f ) {
			if ( $this->resize ) {
				require_once('tnimg.class.php');
				$ti = new ThumbnailImage();
				$ti->src_file = substr($_SERVER["SCRIPT_URI"],0,strpos($_SERVER["SCRIPT_URI"],"th"))."dl.php?q=$linkBase64";
				$ti->dest_type = THUMB_JPEG;
				$ti->dest_file = STDOUT;
				$ti->max_width = $maxwidth;
				$ti->max_height = $maxheight;
				$ti->jpeg_quality = 50;
				$ti->interlace = INTERLACE_OFF;
				$ti->Output();

			} else {
				if ( $this->gm->connect() ) {
					header( "Content-Type: $tipo" );
					header( 'Content-Disposition: inline; filename="' . $f . '"' );
					@$this->gm->getThumb( $a, $m, "php://output" );
				} 
			} 
		} 
	} 

	/**
	 * GImageGallery::getImage()
	 * 
	 * @param string $linkBase64 
	 * @return 
	 */
	function getImage( $linkBase64 ) {
		$q = base64_decode( $linkBase64 );
		parse_str( $q );
		$a = $this->_filtro( $a );
		$m = $this->_filtro( $m );
		$f = $this->_filtro( $f );
		$tipo = $this->_filtro( $tipo );
		$size2 = $this->_filtro( $size2 );

		if ( $a && $m && $f ) {
			if ( $this->gm->connect() ) {
				header( "Content-Type: $tipo" );
				header( "Content-Length: $size2" );
	//			header( 'Content-Disposition: inline; filename="' . $f . '"' );
				@$this->gm->getAttachment( $a, $m, "php://output" );
			} 
		} 
	} 

	/**
	 * GImageGallery::setResizeMethod()
	 * 
	 * @param constat $type 
	 * @return 
	 */
	function setResizeMethod( $type ) {
		$this->resize = $type;
	} 

	function _filtro( $cadena ) {
		$no = array( "'<'", "'>'" );
		$cadena = preg_replace( $no, "", $cadena );
		return $cadena;
	} 

	/**
	 * GImageGallery::destroyGImageGallery()
	 * 
	 * @return mull Destructor
	 */
	function destroyGImageGallery() {
		$this->gm->disconnect();
	} 
} 

?>