<?php
/*
*******
******* configure.php
*******
******* phpSlideshow 1.0  2005 by jim isaacs
******* 
******* contact me if you like this script at jim@jimisaacs.com
*******
**********************************************************************************************
***********************   THIS SCRIPT WAS TESTED ON   ****************************************

	Mac OS 10.3.7
	PHP VERSION 4.3.2
	Apache/1.3.33 Server

**********************************************************************************************


This is the configuration file for phpSlideshow,
this is where you can change values to suite your environment and chosen look.

Please keep the same format for the values to avoid trouble.
If you are opening this file for the first time, what you are seeing is simple default values that may be changed.
There should be no need for any change to any values in any file but this one.

If you are still having trouble you, drop me line at my email jim@jimisaacs.com

thanks,
Bobalouie


**********************************************************************************************/



// The folder the phpShowshow will look for the images to display
	$image_folder = 'images';



//
// The title that will display at the top of the Slide show page and in the Instructions
	$page_title = 'phpSlideShow1';



//
// This is the content of the opening page
//
// Set this to the number of seconds you would like to allow for reading instructions
// This value is also the amount of time allowed to preload all the slide images
	$time_to_read_instuctions = 30; // in seconds



//
// Set this to the the information you would like the instructions to say
// It is in HTML format but please refrain from using single quotes ' or " 
// If you need to use quotes make sure you escape them by putting a backslash in front like \' or \"
// Make sure you use the <BR> HTML tab for all line breaks, because there is no text nowrapping without it

	$instructions = 'you may use the arrows on either side of the slide to navigate,<BR>
					or you may use the slide display at the top to find a specific slide.';



//
// ALLOW AUTOMATED SLIDE SHOW
//
// This is the value to allow phpSlideshow to automatically progress through the slideshow
// The value is in seconds for the time to allow one slide to be displayed before progressing
//
// I suggest a larger value like a minimum of 5 to allow pictures to load and be viewed properly
// set to 0 to turn OFF the autoplay ability completely
	$auto_slide_move = 6; // in seconds



//
// You may set an overall limit to your pics width and height
// This effects the actual size of the width and height that phpSlideshow window will open at and the pic display area
	$max_height = 550; // in pixels
	$max_width = 550; // in pixels


//
// You may set the limit of how many link numbers are displayed at the top of the slideshow during manual mode.
// This limit is in order to keep large slideshows link-bar-lengths down, because if the links exceed the overall width
// the previous $max_width value does not have any effect. The below value does, and holds the $max_width value true if
// the link limit is set to the right amount. (for example: if you have 60 pictures in your slide show and this value
// did not exist then 60 links would display at the top. With this limit you can choose to allow only a certain range
// of those links to appear at a time.)
	// Try to keep an even whole number, odd numbers are rounded up to the nearest even number when the active image number 
	// is within the middle of the list. Thes means it rounds when there are continued marks on either side of the active 
	// image. This is when 5 turns to 6, or 11 turns to 12, etc..
	$link_display_limit = 8; // Even number of links to display at one time (excluding the active image number)


//
//
// You may set the below values for the overall look to your page!!!
// All colors are in hexidecimal
//


// Overall Page Attributes
	$page_background_color = '#111111';
	$page_font_family = 'Verdana, Arial, Helvetica, sans-serif';


// The Image Display Color Attributes
	$pic_display_border_color = '#666666';
	$pic_display_background_color = '#222222';


// Non-link Text Colors
	$normal_font_color = '#999999';
	$highlight_font_color = '#FFFFFF';


// Link Colors
	$normal_link_color = '#B3946B';
	$visited_link_color = '#B3946B';
	$rollover_link_color = '#FFFFFF';
	$onclick_link_color = '#FFFFCC';


// Arrow Link Attributes
	$arrow_font_family = 'Arial, Helvetica, sans-serif';
	$arrow_size = 40;  // height in pixels

// Version Footer
	// For Me
$version_footer = "phpSlideShow1 <font face=\"Verdana\">&copy;</font> ".date('Y')." by <a href=\"mailto:jim@jimisaacs.com\" onFocus=\"if(this.blur)this.blur()\">jim isaacs</a>, a part of <a href=\"http://www.jimisaacs.com?page=_phpScripts.php&\" onFocus=\"if(this.blur)this.blur()\">phpScripts by Jim</a>";


// END OF FILE
?>
