<?

include("config");

// INTERNAL FUNCTION
// Display a thumbnail image that wwill open the full-size image in a new window.
// $Image is the URL to the full size image.
// $thumb is the URL to the thumbnail image.
function zoom($image, $thumb, $title, $author)
{

	global $webroot, $thumbdir, $imgdir;

	// Grabs height/width for the image and sets height/width for popup window.
	$the_image = $webroot.$imgdir.'/'.$image;
	$the_thumb = $webroot.$thumbdir.'/'.$thumb;
	$size = GetImageSize ($the_image); 
	$tsize = GetImageSize ($the_thumb); 
	$width = $size[0] + 20;
	$height = $size[1] + 20;
	$title = stripslashes($title);
	$author = stripslashes($author);

	// Print the table that will hold the thumbnail and other data.
	echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" width=\"120\">\n";
	echo "<tr>\n";
	echo "<td align=\"center\" valign=\"top\" class=\"imgtable\" align=\"center\">";
	echo "<a href=\"#\" onclick=\"NewWindow('$imgdir/$image','ZoomIn','$width','$height','no');return false\"><img src=\"$thumbdir/$thumb\" width=\"$tsize[0]\" height=\"$tsize[1]\" border=\"0\" /></a><br />";
	echo "<p><div class=\"att\" style=\"font-weight:bold\" align=\"center\">";
	echo "Title: $title<br />";
	echo "By: $author</div>";
	echo "</td>\n";
	echo "</tr>\n";
	echo "</table>";
}

// Generate the table of images for links to sub-pages
// $pages is the total number of pages and should be set at the beginning of the file.
function linkpages($pages)
{

	global $page;

	echo "<div align=\"right\" valign=\"bottom\" class=\"pagelinks\">";
		
	if (!$page)
	{
		$page = '1';
	}

	if ($pages > '0')
	{
		$c_page = "1";
		$next = $page + 1;
		$previous = $page - 1;

		// If we're on the 2nd page or greater, put in a previous arrow.
		if ($page != "1")
		{
			echo "[<a href=\"$PHP_SELF?page=$previous\">Prev</a>] ";
		}
	
		// Print the stuff in the middle.
		while ($c_page <= $pages) 
		{
			if ($c_page != "")
			{
				echo "[<a href=\"$PHP_SELF?page=$c_page\">$c_page</a>] ";
			}

			$c_page++;
		}	

		// If we're not on the last page, print a next arrow.
		if ($page < $pages)
		{
			echo "[<a href=\"$PHP_SELF?page=$next\">Next</a>]";
		}
	}

	echo "</div>";
}

// Get the image information from the data file and print images.
function list_images()
{

	global $split, $page;

	if (!$page)
	{
		$page = "1";
	}

	$cols = "0";

	echo "<table border=\"0\" cellspacing=\"10\" cellpadding=\"0\">";
	echo "	<tr>";

	$this_image = file("imgdata");

	// This is the min/max/ images for a page, and total images.

	$images = count($this_image);

	if ($page == "1")
	{
		$min = "0";
	}

	else
	{
		$p = $page - 1;
		$min = ($p * $split);
		
	}

	$max = $page * $split;

	$t_count = $min + 1;


	// Get the number of pages - is then used by linkpages()
	for ($i = 1; $i <= ceil($images / $split); $i++)
	{
		$pages = $i;
		global $pages;
	}

	for (reset ($this_image); list ($key, $value) = each ($this_image); )
	{
		// Make sure we don't print beyond the max.
		if ($t_count <= $max && $t_count <= $images)
		{

			// Make sure we start with the min.
			if ($key >= $min) {

				$image_data = explode('|', $value);
	
				echo "<td class=\"imgtable\" valign=\"top\">";
				zoom($image_data[0], $image_data[1], $image_data[2], $image_data[3]);
				echo "</td>";

				$cols++;
		
				// We want our table of thumbnails to be 5 columns wide.
				if ($cols > "4")
				{
					echo "</tr><tr>";
					$cols = "0";
				}
				$t_count++;
			}
		}	
	}	

	echo "</tr>";
	echo "</table>";
}

?>