<?php
############################################################
##
##	PopGallery (Simple Gallery in a Pop-Up)
##
##	Versione 1.0 (03/06/2006)
##	Licenza: Creative Commons
##	Sito: http://www.area82.it/extra/popgallery
##
##  Autore: CubaLibre <info@area82.it>
##	Homepage; http://www.area82.it
##
############################################################

$allowed 			= array('jpg', 'gif'); 		// Tipi di immagini supportate
$navigation_style 	= 'number';					// Stile del menu di navigazione; number= 1,2,3,4,5; text=Precedente|Successiva

############################################################
########### NON MODIFICARE NULLA DA QUI IN POI #############
############################################################

$foto_dir = 'foto/' . $_GET['album'] . "/";

$foto = my_scandir($foto_dir, $allowed);

if(empty($foto)) die("Nessuna foto presente");

$current = (intval($_GET['foto']) && isset($foto[$_GET['foto']])) ? $_GET['foto'] : 0; 

$start = $foto_dir . $foto[$current];

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Foto - Powered by PopGallery</title>
<style>
html, body {text-align:center; font-family:Verdana, Arial, Helvetica, sans-serif; font-size:10px; background:#303638; color:#FFFFFF}
a {color:#FFFFFF}
a:hover {color:#FFFF00}
a.page {border:1px solid #FFFFFF; padding:3px; color:#FFFFFF; text-decoration:none}
a.page:hover {color:#FFFFFF; text-decoration:none}
a.active {border:1px solid #FFFFFF; padding:3px; background:#FFFF00; color:#000000}
.immagine {background:#FFFFFF; padding:5px; margin-bottom:0}
img {border:0}
#descrizione {color: #000000; padding:5px; background: #FFFFFF; width: <?php echo get_width($start); ?>px; margin: 0px auto
}
</style>
</head>
<body>
<?php
echo "Foto " . ($current+1) . " di " . count($foto) . "";
echo "<br /><br />";
echo resize($start);
//echo "<br /><br />";
echo get_description($start);
echo "<br /><br />";
if(count($foto) > 1) echo navigation();
echo "<br /><br />";
echo sponsor();
echo "<br /><br />Powered by <a href=\"http://www.area82.it/extra/popgallery\" target=\"_blank\">PopGallery</a>";

	function get_width($foto)
	{
		$dimensione = getimagesize($foto);
		
		$width 	= $dimensione[0];
		$height = $dimensione[1];
		
		if($width > 600)
		{
			$width = 600;
			$height = ceil($width * $dimensione[1] / $dimensione[0]);
		}
		
		if($height > 450)
		{
			$height = 450;
			$width = ceil($height * $dimensione[0] / $dimensione[1]);
		}
		
		return $width;
	}
	
	###############################################
	# Funzione per stampare il menu di navigazione
	###############################################
	function navigation()
	{
		global $foto, $current, $navigation_style;
		
		$link = "";
		
		if($navigation_style === 'text')
		{
		
			if(isset($foto[$current-1])) 	$link .= "<a href=\"?album=" . $_GET['album'] . "&foto=" . ($current-1) . "\">Precedente</a>";

			if(isset($foto[$current-1]) 
			&& isset($foto[$current+1])) 	$link .= " | ";

			if(isset($foto[$current+1])) 	$link .= "<a href=\"?album=" . $_GET['album'] . "&foto=" . ($current+1) . "\">Successiva</a>";
		}
		else if($navigation_style === 'number')
		{
		
			if(isset($foto[$current-3]))	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=0\" title=\"Vai alla prima immagine\">&laquo;</a> ";
			if(isset($foto[$current-2])) 	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=" . ($current-2) . "\">" . ($current-1) . "</a> ";
			if(isset($foto[$current-1])) 	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=" . ($current-1) . "\">" . ($current) . "</a> ";
											$link .= " <a class=\"active\">" . ($current+1) . "</a> ";
			if(isset($foto[$current+1])) 	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=" . ($current+1) . "\">" . ($current+2) . "</a> ";
			if(isset($foto[$current+2])) 	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=" . ($current+2) . "\">" . ($current+3) . "</a> ";
			if(isset($foto[$current+3]))	$link .= " <a class=\"page\" href=\"?album=" . $_GET['album'] . "&foto=" . (count($foto)-1) . "\" title=\"Vai all'ultima immagine\">&raquo;</a> ";
		}
		
		return $link;
	}

	###############################################
	# Funzione per cercare le foto in una directory
	############################################### 
	function my_scandir($dir, $allowed)
   	{
		
       	if(is_dir($dir))
       	{
          	$dirlist = opendir($dir);
          
           	while( ($file = readdir($dirlist)) !== false)
           	{
               	$estensione = strtolower(end(explode('.', $file)));
				
				if(!is_dir($dir."/".$file) && in_array($estensione, $allowed))
               	{
                   	$files[] = $file;
				}

           	}
          
           	return $files;
       	}
       	else
       	{
       		die("Cartella " . $dir . " non trovata");
       	}
   	}
	
	#################################################
	# Funzione per effettuare il resize se necessario
	#################################################
	function resize($foto)
	{
		$dimensione = getimagesize($foto);
		
		$width 	= $dimensione[0];
		$height = $dimensione[1];
		$resize = FALSE;
		
		if($width > 600)
		{
			$width = 600;
			$height = ceil($width * $dimensione[1] / $dimensione[0]);
			$resize = TRUE;
		}
		
		if($height > 450)
		{
			$height = 450;
			$width = ceil($height * $dimensione[0] / $dimensione[1]);
			$resize = TRUE;
		}
		
		if($resize === TRUE)
		{
		
			switch($ext) {
				case "gif": 	$source = imagecreatefromgif($foto); 	$out = 1; break;
				case "png": 	$source = imagecreatefrompng($foto); 	$out = 2; break;
				case "jpg": 	$source = imagecreatefromjpeg($foto); 	$out = 3; break;
				case "jpeg": 	$source = imagecreatefromjpeg($foto); 	$out = 4; break;
				default: 		$source = imagecreatefromjpeg($foto); 	$out = 3;
			}
		
			$new = imagecreatetruecolor($width, $height);
		
			@imagecopyresampled($new,$source,0,0,0,0,$width,$height,imagesx($source),imagesy($source));
		
			switch($out){
				case 1: 	function_exists('imagegif') ? @imagegif($new, $foto, 90): @imagepng($new, $foto, 90); break;
				case 2: 	@imagepng($new, $foto, 90); break;
				case 3: 	@imagejpeg($new, $foto, 90); break;
				case 4: 	@imagejpeg($new, $foto, 90); break;
				default: 	@imagejpeg($new, $foto, 90);
			}
		
			imagedestroy($source);
		}
		
		return "\n<img class=\"immagine\" src='{$foto}' width='{$width}' height='{$height}' alt='Foto non disponibile' title='{$foto}' />\n";
	}
	
	#################################################
	# Funzione per stampare la descrizione della foto
	#################################################
	function get_description($foto)
	{
		
		$file = $foto . ".txt";
		
		if(!file_exists($file)) return "";
		
		$testo = file_get_contents($file);
		
		return '<div id="descrizione">' . $testo . '</div>';
	}
	
	############################################
	# Funzione per stampare uno sponsor casuale
	############################################
	function sponsor()
	{
		global $allowed;
		
		$sponsor = my_scandir('sponsor', $allowed);
		
		if(empty($sponsor)) return "";
		
		$random = array_rand($sponsor);
		
		$file = "sponsor/" . $sponsor[$random] . ".txt";
		
		if(!file_exists($file)) $link = ""; else $link = file_get_contents($file);
		
		return "\n<a href=\"{$link}\" target=\"_blank\"><img src='sponsor/" . $sponsor[$random] . "' alt='Foto non disponibile' title='Clicca per visitare lo sponsor' /></a>";
	}
	

?>
</body>
</html>