<?php

// Copyright (C) 2005-2008 Ilya S. Lyubinskiy. All rights reserved.
// Technical support: http://www.php-development.ru/
//
// YOU MAY NOT
// (1) Remove or modify this copyright notice.
// (2) Re-distribute this code or any part of it.
//     Instead, you may link to the homepage of this code:
//     http://www.php-development.ru/php-scripts/click-tracker.php
// (3) Use this code as part of another product.
//
// YOU MAY
// (1) Use this code on your website.
//
// NO WARRANTY
// This code is provided "as is" without warranty of any kind.
// You expressly acknowledge and agree that use of this code is at your own risk.


include_once "init.php";

if (!isset($_POST["submit"]))
{
  $date  = getdate();
  $_POST = array("method"   => "simple",
                 "interval" => "0-1",
                 "day1"     => $date['mday'],
                 "month1"   => $date['mon' ],
                 "year1"    => $date['year'],
                 "day2"     => $date['mday'],
                 "month2"   => $date['mon' ],
                 "year2"    => $date['year'],
                 "submit"   => "Submit");
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">


<!-- ***** Head ************************************************************ -->

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>

<title>Click Tracker</title>

<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="description" content="" />
<meta name="keywords"    content="" />

<link rel="stylesheet" type="text/css" href="style.css" />

<style type="text/css">

body
{
  font-family: Verdana, Sans-Serif;
  font-weight: 900;
  font-size: 0.6em;
  color:   #202020;
}

</style>

<script type="text/javascript">

function clicktracker_change_type(type)
{
  for (var i = 0; i != document.forms[0].elements.length; i++)
    if (document.forms[0].elements[i].name == "method")
        document.forms[0].elements[i].checked = document.forms[0].elements[i].value == type;
}

</script>

</head>
<body>
<div class="click_tracker">

<h1>Click Tracker</h1>


<!-- ***** Form ************************************************************ -->

<form method="post" action="index.php">
<table>

<!-- ***** Date: Simple ***** -->

<tr>
<td><input type="radio" name="method" value=   "simple" <?=__checked("method",    "simple");?> /></td>
<td>
<select name="interval" onchange="clicktracker_change_type('simple');">
  <option value="0-1"  <?=__selected("interval", "0-1" );?>>       Today</option>
  <option value="1-2"  <?=__selected("interval", "1-2" );?>>   Yesterday</option>
  <option value="0-3"  <?=__selected("interval", "0-3" );?>>Last  3 days</option>
  <option value="0-7"  <?=__selected("interval", "0-7" );?>>Last  7 days</option>
  <option value="0-30" <?=__selected("interval", "0-30");?>>Last 30 days</option>
</select>
</td>
</tr>

<!-- ***** Date: Start-End ***** -->

<tr>
<td><input type="radio" name="method" value="start-end" <?=__checked("method", "start-end");?> /></td>
<td>
<?php

$selects = array('day'   => array(),
                 'month' => array(1 => "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"),
                 'year'  => array());
for ($i =    1; $i <=   31; $i++) $selects[ 'day'][$i] = $i;
for ($i = 2008; $i <= 2015; $i++) $selects['year'][$i] = $i;
for ($i =    1; $i <=    2; $i++)
{
  foreach($selects as $name => $options)
  {
    echo "<select name=\"$name$i\" onchange=\"clicktracker_change_type('start-end');\">";
    foreach($options as $value => $innerhtml) echo "<option value=\"$value\" " . __selected("$name$i", $value) . ">$innerhtml</option>";
    echo "</select>";
  }
  if ($i == 1) echo " - ";
}

?>
</td>
</tr>

<!-- ***** Submit ***** -->

<tr><td colspan="2"><input type="submit" name="submit" value="Submit" /></td></tr>

</table>
</form>


<!-- ***** Results ********************************************************* -->

<table>

<tr><th>URL</th><th>Clicks</th></tr>

<?php

$ct_urls->Shift();

if ($_POST["method"] == "simple")
  list($start, $end) = explode("-", $_POST["interval"]);

if ($_POST["method"] == "start-end")
{
  $end   = mktime(0, 0, 0, $_POST["month1"], $_POST["day1"], $_POST["year1"]);
  $start = mktime(0, 0, 0, $_POST["month2"], $_POST["day2"], $_POST["year2"]);
  $curr  = (integer)$ct_urls->Get("<< Time >>");
  $end   = $curr-(integer)($end  /24/3600);
  $start = $curr-(integer)($start/24/3600)-1;
}

if ($end > $start) $data = $ct_urls->GetAll($start, $end);
if ($end > $start) $trid = 'class="odd"';

if ($end > $start) foreach ($data as $i => $x)
{
  $x['key'] = unserialize($x['key']);
  $x['val'] = $x['key'][1];
  $x['key'] = $x['key'][0];

  ?>

  <tr>
  <td <?=$trid;?>><a target="top" href="<?=$x['key'];?>"><?=htmlentities($x['val']);?></a></td>
  <td <?=$trid;?>><?=$x['cnt'];?></td>
  </tr>

  <?php

  $trid = ($trid !== 'class="odd"') ? 'class="odd"' : 'class="even"';
}

?>

</table>


<!-- ***** Copyright ******************************************************* -->

Copyright &copy; 2005-2008 Ilya S. Lyubinskiy. All rights reserved
&nbsp;|&nbsp;
<a href="http://www.php-development.ru/php-scripts/click-tracker.php">Homepage</a>

</div>
</body>
</html>
