<?php
/////////////////////////////////||||||||\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
/////////////////////////////////||||||||\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
////////////**************************************************\\\\\\\\\\\\
////////////*                                                *\\\\\\\\\\\\
////////////*                  Created By:                   *\\\\\\\\\\\\
////////////*         BRITISH ELECTRONIC& Computer  Co.      *\\\\\\\\\\\\
////////////*                WEB DEVELOPING                  *\\\\\\\\\\\\
////////////*                                                *\\\\\\\\\\\\
////////////*                   Author by:                   *\\\\\\\\\\\\
////////////* Ahmed Hassan Elkadrey    elkadrey@gmail.com    *\\\\\\\\\\\\
////////////*                 Subervised by:                 *\\\\\\\\\\\\
////////////*       Sherif Negm    chicoo2006@gmail.com      *\\\\\\\\\\\\
////////////*              Copyright  2008                  *\\\\\\\\\\\\
////////////*                                                *\\\\\\\\\\\\
////////////**************************************************\\\\\\\\\\\\
/////////////////////////////////||||||||\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
/////////////////////////////////||||||||\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /******************************************************************

   Projectname:   CAPTCHA class
   Version:       2.0
   Author:        Pascal Rehfeldt <Pascal@Pascal-Rehfeldt.com>
   Last modified: 15. January 2006

   * GNU General Public License (Version 2, June 1991)
   *
   * This program is free software; you can redistribute
   * it and/or modify it under the terms of the GNU
   * General Public License as published by the Free
   * Software Foundation; either version 2 of the License,
   * or (at your option) any later version.
   *
   * This program is distributed in the hope that it will
   * be useful, but WITHOUT ANY WARRANTY; without even the
   * implied warranty of MERCHANTABILITY or FITNESS FOR A
   * PARTICULAR PURPOSE. See the GNU General Public License
   * for more details.

   Description:
   Filters

  ******************************************************************/

  class filters
  {
  	
    function noise (&$image, $runs = 30)
    {
    	
	  $w = imagesx($image);
	  $h = imagesy($image);
  
      for ($n = 0; $n < $runs; $n++)
      {

        for ($i = 1; $i <= $h; $i++)
        {

          $randcolor = imagecolorallocate($image,
                                          mt_rand(0, 255),
                                          mt_rand(0, 255),
                                          mt_rand(0, 255));

          imagesetpixel($image,
                        mt_rand(1, $w),
                        mt_rand(1, $h),
                        $randcolor);

        }

      }  
  
    } //noise
    
    function signs (&$image, $font, $cells = 3)
    {
   	
	  $w = imagesx($image);
	  $h = imagesy($image);

   	  for ($i = 0; $i < $cells; $i++)
   	  {
   	  	   	  	
   	  	$centerX     = mt_rand(1, $w);
   	  	$centerY     = mt_rand(1, $h);
   	  	$amount      = mt_rand(1, 15);
        $stringcolor = imagecolorallocate($image, 175, 175, 175);
   	  	
   	  	for ($n = 0; $n < $amount; $n++)
   	  	{

          $signs = range('A', 'Z');
          $sign  = $signs[mt_rand(0, count($signs) - 1)];

   	  	  imagettftext($image, 25, 
   	  	               mt_rand(-15, 15), 
   	  	               $centerX + mt_rand(-50, 50),
   	  	               $centerY + mt_rand(-50, 50),
   	  	               $stringcolor, $font, $sign);
   	  	
   	  	}
   	  	
   	  }
   	
    } //signs

    function lines_image()
    {
    //here
      //{
      $blacks = imagecolorallocate( $image , 0 , 0 , 0);
      $x_d=date("s");
      $x=substr($x_d,0,2);
      $x_t=substr($x_d,1,1);
      if($x>45)
      {
          $x_y=$x_t*2;
          $x2=$x-$x_y;
          if($x2<=0)
          {
              $x2=$x_t;
          }
      }
      elseif($x<=45)
      {
          $x2=$x+10;
      }
      elseif($x<=0)
      {
          $x=10;
          $x2=20;
      }

      imageline( $image , $x , 30 , $x2 , 20 ,$blacks );
      imageline( $image , 25 , 8 , 30 , 15 ,$blacks );
      imageline( $image , 75 , 30 , 70 , 25 ,$blacks );
      $x*=2;
      if($x>45)
      {
          $x_y=$x_t*4;
          $x2=$x-$x_y;
          if($x2<=0)
          {
              $x2=$x_t;
          }
      }
      elseif($x<=45)
      {
          $x2=$x+30;
      }
      elseif($x<=0)
      {
          $x=20;
          $x2=30;
      }

      imageline( $image , $x , 8 , $x2 , $x_t,$blacks );

      $x-=20;
      $x2=$x*3;
      imageline( $image , $x , 10 , $x2 , 4 ,$blacks );
      $x *= 6;
      $x2 = $x*3;
      imageline( $image , $x , 5 , $x2 , 23 ,$blacks );



        //}
    }

    function blur (&$image, $radius = 3)
    {

	  $radius  = round(max(0, min($radius, 50)) * 2);

	  $w       = imagesx($image);
	  $h       = imagesy($image);
	  
	  $imgBlur = imagecreate($w, $h);

	  for ($i = 0; $i < $radius; $i++)
	  {

		imagecopy     ($imgBlur, $image,   0, 0, 1, 1, $w - 1, $h - 1);
		imagecopymerge($imgBlur, $image,   1, 1, 0, 0, $w,     $h,     50.0000);
		imagecopymerge($imgBlur, $image,   0, 1, 1, 0, $w - 1, $h,     33.3333);
		imagecopymerge($imgBlur, $image,   1, 0, 0, 1, $w,     $h - 1, 25.0000);
		imagecopymerge($imgBlur, $image,   0, 0, 1, 0, $w - 1, $h,     33.3333);
		imagecopymerge($imgBlur, $image,   1, 0, 0, 0, $w,     $h,     25.0000);
		imagecopymerge($imgBlur, $image,   0, 0, 0, 1, $w,     $h - 1, 20.0000);
		imagecopymerge($imgBlur, $image,   0, 1, 0, 0, $w,     $h,     16.6667);
		imagecopymerge($imgBlur, $image,   0, 0, 0, 0, $w,     $h,     50.0000);
		imagecopy     ($image  , $imgBlur, 0, 0, 0, 0, $w,     $h);

	  }
	  
	  imagedestroy($imgBlur);
	  
    } //blur

  } //class: filters

?>