<?php

require_once("$STPHPLIB_DIR/stphpobject.php");
require_once("$STPHPLIB_DIR/stphpxmlelement.php");

class STPHPXmlDoc extends STPHPObject
{
        function STPHPXmlDoc($name)
        {
                STPHPObject::STPHPObject($name);
                $this->root = new STPHPXmlElement('root');
                unset($this->root->parent);
                unset($this->parentXMLElement);
                $this->withCData=false;
        }

        function dtor()
        {
                $this->root->dtor();
                unset($this->parentXMLElement);
                STPHPObject::dtor();
        }

        function deleteTreeFromDb(&$db, $tableElements, $rootTag='', $tableAttributes='', $tableChilds='')
        {
                if(empty($tableAttributes))
                {
                        $tableAttributes = $tableElements . '_attributes';
                }
                if(empty($tableChilds))
                {
                        $tableChilds = $tableElements . '_childs';
                }

                unset($element_id);

                $sql = "SELECT ID FROM $tableElements WHERE ROOT=1 ";
                if(!empty($rootTag))
                {
                        $sql .= "AND NAME ='$rootTag'";
                }

                $recordSet = $db->Execute($sql);

                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $element_id = $recordSet->fields['ID'];
                        }
                        $recordSet->Close();
                }

                if(isset($element_id))
                {
                        $this->deleteElementFromDb($db, $element_id, $tableElements, $tableAttributes, $tableChilds);
                }
        }

        function deleteElementFromDb(&$db, $element_id, $tableElements, $tableAttributes, $tableChilds)
        {
                $sql = "DELETE FROM $tableAttributes WHERE OWNER_ID=" . $element_id;

                $db->Execute($sql);
                $recordSet = $db->Execute("SELECT CHILD_ID FROM $tableChilds WHERE OWNER_ID=$element_id ORDER BY CHILD_ID");
                if($recordSet)
                {
                        while(!$recordSet->EOF)
                        {
                                $child_id = $recordSet->fields['CHILD_ID'];
                                $this->deleteElementFromDb(&$db, $child_id, $tableElements, $tableAttributes, $tableChilds);
                                $recordSet->MoveNext();
                        }
                        $recordSet->Close();
                }

                $sql = "DELETE FROM $tableChilds WHERE CHILD_ID=" . $element_id;
                $db->Execute($sql);

                $sql = "DELETE FROM $tableElements WHERE ID=" . $element_id;
                $db->Execute($sql);
        }

        function readFromDb(&$db, $tableElements, $rootTag='', $tableAttributes='', $tableChilds='')
        {
                unset($this->elementsRead);
                $this->elementsRead = array();

                $this->root->dtor();
                unset($this->parentXMLElement);

                if(empty($tableAttributes))
                {
                        $tableAttributes = $tableElements . '_attributes';
                }
                if(empty($tableChilds))
                {
                        $tableChilds = $tableElements . '_childs';
                }

                $element_id = "";

                $sql = "SELECT ID FROM $tableElements WHERE ROOT=1 ";
                if(!empty($rootTag))
                {
                        $sql .= "AND NAME ='$rootTag'";
                }

                $recordSet = $db->Execute($sql);

                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $element_id = $recordSet->fields['ID'];
                        }
                        $recordSet->Close();
                }

                if(isset($element_id))
                {
                        $this->loadElementFromDb($db, $element_id, $tableElements, $tableAttributes, $tableChilds);
                }
        }

        function loadElementFromDb(&$db, $element_id, $tableElements, $tableAttributes, $tableChilds)
        {
                $recordSet = $db->Execute("SELECT NAME,DATA FROM $tableElements WHERE ID=$element_id");
                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $name = $recordSet->fields['NAME'];
                                $data = $recordSet->fields['DATA'];
                        }
                        $recordSet->Close();
                }

                $attributes = array();
                $recordSet = $db->Execute("SELECT ATTRIBUTE,VALUE FROM $tableAttributes WHERE OWNER_ID=$element_id ORDER BY ID");
                if($recordSet)
                {
                        while(!$recordSet->EOF)
                        {
                                $attribute = $recordSet->fields['ATTRIBUTE'];
                                $value = $recordSet->fields['VALUE'];
                                $attributes[$attribute]=$value;
                                $recordSet->MoveNext();
                        }
                        $recordSet->Close();
                }

                if(!isset($this->parentXMLElement))
                {
                        $this->root->name=$name;
                        $this->root->data=$data;
                        $this->root->attributes=$attributes;
                        $this->parentXMLElement =& $this->root;
                        $this->currentXMLElement=& $this->root;
                }
                else
                {
                        $XMLElement = new STPHPXMLElement($name);
                        $XMLElement->attributes = $attributes;
                        $XMLElement->data = $data;
                        $XMLElement->parent = & $this->parentXMLElement;

                        $i = sizeof($this->parentXMLElement->childs);

                        $this->parentXMLElement->childs[$i] = $XMLElement;
                        $this->currentXMLElement =& $this->parentXMLElement->childs[$i];
                }

                $recordSet = $db->Execute("SELECT CHILD_ID FROM $tableChilds WHERE OWNER_ID=$element_id ORDER BY CHILD_ID");
                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $this->parentXMLElement =& $this->currentXMLElement;
                        }
                        while(!$recordSet->EOF)
                        {
                                $element_id = $recordSet->fields['CHILD_ID'];
                                $this->loadElementFromDb(&$db, $element_id, $tableElements, $tableAttributes, $tableChilds);
                                $recordSet->MoveNext();
                        }
                        $recordSet->Close();
                }
        }

        function saveToDb(&$db, $tableElements, $tableAttributes='', $tableChilds='')
        {
                if(empty($tableAttributes))
                {
                        $tableAttributes = $tableElements . '_attributes';
                }
                if(empty($tableChilds))
                {
                        $tableChilds = $tableElements . '_childs';
                }

                $this->deleteTreeFromDb(&$db, $tableElements, $this->root->name, $tableAttributes, $tableChilds);
                $this->saveElementToDb(&$db, $tableElements, $tableAttributes, $tableChilds, 1, $this->root);
        }

        function saveElementToDb(&$db, $tableElements, $tableAttributes, $tableChilds, $root='0', $element)
        {
                $recordSet = $db->Execute("SELECT MAX(ID)  MAXID FROM $tableElements");
                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $element_id = $recordSet->fields['MAXID'] + 1 ;
                        }
                        $recordSet->Close();
                }

                $sql  = "INSERT INTO $tableElements (ID, NAME, DATA, ROOT) VALUES (";
                $sql .= $element_id . ",'" . $element->name . "', '" . $element->data . "', $root";
                $sql .= ")";
                $db->Execute($sql);

                $this->saveAttributesToDb(&$db, $element_id, $element->attributes, $tableAttributes);
                $this->saveChildsToDb(&$db, $tableElements, $element_id, $element, $tableAttributes, $tableChilds);

                return $element_id;
        }

        function saveAttributesToDb(&$db, $owner_id, &$attributes, $tableAttributes)
        {
                $recordSet = $db->Execute("SELECT MAX(ID)  MAXID FROM $tableAttributes");
                if($recordSet)
                {
                        if(!$recordSet->EOF)
                        {
                                $attribute_id = $recordSet->fields['MAXID'] + 1 ;
                        }
                        $recordSet->Close();
                }

                if(is_array($attributes))
                {
                        reset($attributes);
                        while(list($key, $value)=each($attributes))
                        {
                                $attribute_id++;
                                $sql  = "INSERT INTO $tableAttributes (ID, OWNER_ID, ATTRIBUTE, VALUE) VALUES (";
                                $sql .= $attribute_id . "," . $owner_id . ",'" . $key . "','" . $value . "'";
                                $sql .= ")";
                                $db->Execute($sql);
                        }
                }
        }

        function saveChildsToDb(&$db, $tableElements, $element_id, $element, $tableAttributes, $tableChilds)
        {
                $numOfChilds = $element->getNumOfChilds();
                for($i=0; $i<$numOfChilds; $i++)
                {
                        $saved_id = $this->saveElementToDb($db, $tableElements, $tableAttributes, $tableChilds, '0', $element->childs[$i]);

                        $recordSet = $db->Execute("SELECT MAX(ID)  MAXID FROM $tableChilds");
                        if($recordSet)
                        {
                                if(!$recordSet->EOF)
                                {
                                        $child_id = $recordSet->fields['MAXID'] + 1 ;
                                }
                                $recordSet->Close();
                        }
                        $sql  = "INSERT INTO $tableChilds (ID, OWNER_ID, CHILD_ID) VALUES (";
                        $sql .= $child_id . "," . $element_id . "," . $saved_id;
                        $sql .= ")";
                        $db->Execute($sql);
                }
        }

        function saveToFile($fileName)
        {
                $fp = fopen($fileName, 'w+');
                $header = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
                fwrite($fp, $header);
                fwrite($fp, "\n");

                $level = 0;
                $this->saveElementToFile($fp, $this->root, $level);
                fclose($fp);
        }

        function saveElementToFile(&$fp, &$element, $level)
        {
                fwrite($fp, str_repeat("\t", $level));
                fwrite($fp, '<' . $element->name);

                if(is_array($element->attributes))
                {
                        reset($element->attributes);
                        while(list($key, $value) = each($element->attributes))
                        {
                                fwrite($fp, ' ' . $key . '="' . $value . '"');
                        }
                }
                fwrite($fp, '>');

                $numOfChilds = $element->getNumOfChilds();
                if($numOfChilds>0)
                {
                        fwrite($fp, "\n");
                        $level++;
                        for($i=0; $i<$numOfChilds; $i++)
                        {
                                $this->saveElementToFile($fp, $element->childs[$i], $level);
                        }
                        $level--;
                        fwrite($fp, str_repeat("\t", $level));
                }
                else
                {
                        if($this->withCData)
                        {
                                fwrite($fp, '<![CDATA[' . $element->data . ']]>');
                        }
                        else
                        {
                                fwrite($fp, $element->data);
                        }
                }

                fwrite($fp, '</' . $element->name . '>');
                fwrite($fp, "\n");
        }

        function readFromFile($fileName)
        {
                $this->root->dtor();
                unset($this->parentXMLElement);

                $retValue=FALSE;

                $this->parser = xml_parser_create();
                xml_set_object($this->parser,&$this);
                xml_set_default_handler($this->parser, "defaultHandler");
                xml_set_element_handler($this->parser,"tag_open","tag_close");
                xml_set_character_data_handler($this->parser,"cdata");
                xml_set_external_entity_ref_handler($this->parser, "externalEntityRefHandler");

                if(!file_exists($fileName))
                {
                        $errorMsg .= "File :  $fileName doesn't exists\n";
                        $this->errorLog($errorMsg);
                        $retValue=FALSE;
                        return $retValue;
                }

                if (!($fp = fopen($fileName, "r")))
                {
                        $errorMsg .= "Impossible to read the file :  $fileName \n";
                        $this->errorLog($errorMsg);
                        $retValue=FALSE;
                }
                else
                {
                        while($data = fread($fp, 4096))
                        {
                                if (!xml_parse($this->parser, $data, feof($fp)))
                                {
                                        $errorStr = sprintf("%s at line %d",
                                        xml_error_string(xml_get_error_code($this->parser)),
                                        xml_get_current_line_number($this->parser));
                                        $errorMsg .= "Error reading XML file : $errorStr \n";
                                        echo $errorMsg;
                                        $this->errorLog($errorMsg);
                                        $retValue=FALSE;
                                }
                                else
                                {
                                        $retValue=TRUE;
                                }
                        }
                }
                xml_parser_free($this->parser);

                return $retValue;
        }

        function readFromString($str)
        {
                $this->root->dtor();
                unset($this->parentXMLElement);

                $retValue=FALSE;

                $this->parser = xml_parser_create();
                xml_set_object($this->parser,&$this);
                xml_set_default_handler($this->parser, "defaultHandler");
                xml_set_element_handler($this->parser,"tag_open","tag_close");
                xml_set_character_data_handler($this->parser,"cdata");
                xml_set_external_entity_ref_handler($this->parser, "externalEntityRefHandler");

                if (!xml_parse($this->parser, $str))
                {
                        $errorStr = sprintf("%s at line %d",
                        xml_error_string(xml_get_error_code($this->parser)),
                        xml_get_current_line_number($this->parser));
                        $errorMsg .= "Error reading XML file : $errorStr \n";
                        $this->errorLog($errorMsg);
                        $retValue=FALSE;
                }
                else
                {
                        $retValue=TRUE;
                }
                xml_parser_free($this->parser);

                return $retValue;
        }

        function getSubTreeAsArray(&$element)
        {
                $arrayTree = $this->getArrayElement($element);
                return $arrayTree;
        }

        function getTreeAsArray()
        {
                $arrayTree = $this->getArrayElement($this->root);
                return $arrayTree;
        }

        function getArrayElement(&$element)
        {
                $arrayElement = array();

                $arrayElement['name'] = $element->name;
                $arrayElement['attributes'] = $element->attributes;

                $numOfChilds = sizeof($element->childs);
                if($numOfChilds>0)
                {
                        $childs = array();
                        for($i=0; $i<$numOfChilds; $i++)
                        {
                                array_push($childs, $this->getArrayElement($element->childs[$i]));
                        }
                        $arrayElement['childs'] = $childs;
                }
                $arrayElement['data']=$element->data;
                return $arrayElement;
        }

        var $parser;
        var $root;
        var $currentXMLElement;
        var $parentXMLElement;
        var $elementsRead;
        var $withCData;
         
        function defaultHandler($parser, $data)
        {
        }

        function tag_open($parser, $tag, $attributes)
        {
                if(!isset($this->parentXMLElement))
                {
                        $this->root->name=$tag;
                        $this->parentXMLElement =& $this->root;
                        $this->currentXMLElement=& $this->root;
                }
                else
                {
                        $XMLElement = new STPHPXMLElement($tag);
                        $XMLElement->attributes = $attributes;

                        $i = sizeof($this->currentXMLElement->childs);

                        $this->currentXMLElement->childs[$i] = $XMLElement;
                        $this->currentXMLElement->childs[$i]->parent =& $this->parentXMLElement;

                        $this->currentXMLElement =& $this->currentXMLElement->childs[$i];
                        $this->parentXMLElement =& $this->currentXMLElement;
                }
        }

        function cdata($parser, $cdata)
        {
                $this->currentXMLElement->data = $cdata;
        }

        function tag_close($parser,$tag)
        {
                $this->parentXMLElement =& $this->currentXMLElement->parent;
                $this->currentXMLElement =& $this->parentXMLElement;
        }

        function externalEntityRefHandler($parser, $openEntityNames, $base, $systemId, $publicId)
        {
                if ($systemId)
                {
                        if (!list($parser, $fp) = new_xml_parser($systemId))
                        {
                                $errorStr = "Could not open entity $openEntityNames at $systemId";
                                $errorMsg = "Error reading XML file : $errorStr \n";
                                $this->errorLog($errorMsg);
                                xml_parser_free($parser);
                                return false;
                        }
                        while ($data = fread($fp, 4096))
                        {
                                if (!xml_parse($parser, $data, feof($fp)))
                                {
                                        $errorStr = sprintf("XML error: %s at line %d while parsing entity %s\n",
                                        xml_error_string(xml_get_error_code($parser)),
                                        xml_get_current_line_number($parser), $openEntityNames);
                                        $errorMsg .= "Error reading XML file : $errorStr \n";
                                        $this->errorLog($errorMsg);
                                        xml_parser_free($parser);
                                        return false;
                                }
                        }
                        xml_parser_free($parser);
                        return true;
                }
                xml_parser_free($parser);
                return false;
        }
}
?>
