<?php

require_once("$STPHPLIB_DIR/stphptable.php");
require_once("$STPHPLIB_DIR/stphplabel.php");

class STPHPToolbar extends STPHPTable
{
  function STPHPToolbar($name)
  {
        STPHPTable::STPHPTable($name);
        $this->buttons = array();
        $this->setAttribute('ALIGNMENT','HORIZONTAL');
  }

  function dtor()
  {
        STPHPTable::dtor();
  }

  function addButton(&$button)
  {
        $numOfButtons = sizeof($this->buttons);
        $this->buttons[$numOfButtons+1] =& $button;
  }

  function openWrite()
  {
        $this->attrsToIgnore['ALIGNMENT']=1;

        $numOfButtons = sizeof($this->buttons);

        if(strtoupper($this->attributes['ALIGNMENT'])=='HORIZONTAL')
        {
                $this->setNumOfRows(2);
                $this->setNumOfCols($numOfButtons);
        }
        else if(strtoupper($this->attributes['ALIGNMENT'])=='VERTICAL')
        {
                $this->setNumOfCols(1);
                $this->setNumOfRows($numOfButtons*2);
        }

        $this->prepare();

        $rowBtnIndex=0;

        for($i=1; $i<=$numOfButtons; $i++)
        {
                if(strtoupper($this->attributes['ALIGNMENT'])=='HORIZONTAL')
                {
                        $rowBtnIndex=1;
                        $rowLblIndex=2;
                        $colBtnIndex=$i;
                        $colLblIndex=$i;
                }
                else if(strtoupper($this->attributes['ALIGNMENT'])=='VERTICAL')
                {
                        $rowBtnIndex=$rowBtnIndex+1;
                        $rowLblIndex=$rowBtnIndex+1;
                        $colBtnIndex=1;
                        $colLblIndex=1;
                }

                $this->cells[$rowBtnIndex][$colBtnIndex]->setAttribute('VALIGN', 'BOTTOM');
                $this->cells[$rowBtnIndex][$colBtnIndex]->setAttribute('ALIGN', 'CENTER');

                $this->cells[$rowLblIndex][$colBtnIndex]->setAttribute('VALIGN', 'TOP');
                $this->cells[$rowLblIndex][$colBtnIndex]->setAttribute('ALIGN', 'CENTER');

                $this->cells[$rowBtnIndex][$colBtnIndex]->addComponent($this->buttons[$i]);

                $link_class = '';
                if(empty($this->buttons[$i]->attributes['CLASS']))
                {
                        $this->buttons[$i]->setAttribute('CLASS', 'btnToolbar');
                }

        }

        return STPHPTable::openWrite();
  }

  function setConfiguration($configuration)
  {
        STPHPControlWithCaption::setConfiguration($configuration);
        $items = $this->configuration->getChildByName('buttons');
        $numOfItems = $items->getNumOfChilds();

        for($i=1; $i<=$numOfItems; $i++)
        {
                $item = $items->getChildByNameNum('button', $i);
                $name = $item->attributes['NAME'];
                $type = $item->attributes['TYPE'];
                eval("\$this->button[$i] = new $type('$name');");
                if(isset($this->button[$i]))
                {
                       $this->button[$i]->appendAttributes($items->attributes);
                       $this->button[$i]->setConfiguration($item);
                       $this->addButton($this->button[$i]);
                }
        }
  }


  var $buttons;
}

?>
