<?php

require_once("$STPHPLIB_DIR/stphpcomponent.php");
require_once("$STPHPLIB_DIR/stphptablerow.php");

class STPHPTable extends STPHPComponent
{
        function STPHPTable($name)
        {
                STPHPComponent::STPHPComponent($name);
                $this->openTag = '<TABLE>';
                $this->closeTag = '</TABLE>';

                $this->numOfRows = 0;
                $this->numOfCols = 0;
                $this->rows = array();
                $this->cells = array();
                
                $this->setAttribute('BORDER', 0);
        }

        function dtor()
        {
                STPHPComponent::dtor();
        }

        function insertComponent(&$component)
        {
                if(is_a($component, "STPHPTableRow"))
                {
                        STPHPComponent::insertComponent($component);
                }
        }

        function appendComponent(&$component)
        {
                if(is_a($component,"STPHPTableRow"))
                {
                        STPHPComponent::appendComponent($component);
                }
        }

        function addComponent(&$component)
        {
                $this->appendComponent($component);
        }

        function insertComponentToCell($row, $col, &$component)
        {
                if
                (
                        ($row>=1) && ($row<=sizeof($this->rows)) &&
                        ($col>=1) && ($col<=$this->numOfCols)
                )
                {
                        $this->cells[$row][$col]->insertComponent($component);
                }
        }

        function appendComponentToCell($row, $col, &$component)
        {
                if
                (
                        ($row>=1) && ($row<=sizeof($this->rows)) &&
                        ($col>=1) && ($col<=$this->numOfCols)
                )
                {
                        $this->cells[$row][$col]->appendComponent($component);
                }
        }

        function addComponentToCell($row, $col, &$component)
        {
                $this->appendComponentToCell($row, $col, $component);
        }

        function setNumOfRows($rows)
        {
                $this->numOfRows=$rows;
        }

        function setNumOfCols($cols)
        {
                $this->numOfCols=$cols;
        }

        function prepare()
        {
                unset($this->rows);
                unset($this->cells);

                $this->rows=array();
                $this->cells=array();

                for($i=1; $i<=$this->numOfRows; $i++)
                {
                        $this->rows[$i] = new STPHPTableRow("tRow_$i_" . $this->name);
                        for($j=1; $j<=$this->numOfCols; $j++)
                        {
                                $this->cells[$i][$j] = new STPHPTableCell("tCell_$i_$j" . $this->name);
                                $this->rows[$i]->addComponent($this->cells[$i][$j]);
                        }
                        $this->addComponent($this->rows[$i]);
                }
        }

        function addRow()
        {
                $i = sizeof($this->rows) + 1;
                $this->rows[$i] = new STPHPTableRow("tRow_$i_" . $this->name);
                for($j=1; $j<=$this->numOfCols; $j++)
                {
                        $this->cells[$i][$j] = new STPHPTableCell("tCell_$i_$j_" . $this->name);
                        $this->rows[$i]->addComponent($this->cells[$i][$j]);
                }
                $this->addComponent($this->rows[$i]);
                return $i;
        }

        function addVSpaceToCell($row, $col, $units)
        {
                if(($row<=sizeof($this->rows)) && ($col<=sizeof($this->cells[$row])))
                {
                        $this->cells[$row][$col]->addVSpace($units);
                }
        }

        var $numOfRows;
        var $numOfCols;
        var $rows;
        var $cells;
}

?>
