<?php

require_once("$STPHPLIB_DIR/stphpradiobuttonwithcaption.php");

class STPHPRadioGroup extends STPHPControlWithCaption
{
        function STPHPRadioGroup($name)
        {
                STPHPControlWithCaption::STPHPControlWithCaption($name);
        }

        function setNumOfChecks($options)
        {
                $this->numOfOptions = $options;
        }

        function prepareCtrls()
        {
                $this->tblControls = new STPHPTable('tbl_ctrls_' . $this->name);
                $this->tblControls->setNumOfRows($this->numOfOptions);
                $this->tblControls->setNumOfCols(1);
                $this->tblControls->prepare();
                for($i=1; $i<=$this->numOfOptions; $i++)
                {
                       $this->radio[$i] = new STPHPRadioButtonWithCaption($this->name);
                       $this->radio[$i]->setFormParent($this->getFormParent()) ;
                       $this->radio[$i]->setIndex($i-1);
                       $this->tblControls->cells[$i][1]->setAttribute('ALIGN', 'LEFT');
                       $this->tblControls->cells[$i][1]->addComponent($this->radio[$i]);
                }
        }

        function prepareWrite()
        {
                STPHPControlWithCaption::prepareWrite();
                $this->ctlCell->addComponent($this->tblControls);
        }

        function setConfiguration($configuration)
        {
                STPHPControlWithCaption::setConfiguration($configuration);
                $items = $this->configuration->getChildByName('items');
                $this->numOfOptions = $items->getNumOfChilds();
                $this->prepareCtrls();

                for($i=1; $i<=$this->numOfOptions; $i++)
                {
                        $item = $items->getChildByNameNum('item', $i);
                        $this->radio[$i]->appendAttributes($items->attributes);
                        $this->radio[$i]->setAttribute('CAPTION', $item->attributes['CAPTION']);
                        $this->radio[$i]->setAttribute('VALUE', $item->data);
                }
        }

        var $numOfOptions;
}

?>
