<?php

require_once("$STPHPLIB_DIR/stphpcontrolwithcaption.php");
require_once("$STPHPLIB_DIR/stphpradiobutton.php");

class STPHPRadioButtonWithCaption extends STPHPControlWithCaption
{

        function STPHPRadioButtonWithCaption($name)
        {
                STPHPControlWithCaption::STPHPControlWithCaption($name);
                $this->radiobutton = new STPHPRadioButton('rdb_' . $name);

                global $STJSLIB_DIR;
                $this->addCodeFile($STJSLIB_DIR . '/stjsradiobuttonwithcaption.js');
                
                $this->index = 0;
        }

        function prepareWrite()
        {
                $this->attrsToIgnore['VALUE']=1;

                $this->radiobutton->setAttribute('VALUE', $this->attributes['VALUE']);

                $ctlName = 'document.' . $this->getFormParent() . '.' . $this->radiobutton->getName();
                $link  = '<a href="javascript://"';
                if(!empty($this->attributes['CAPTION_CLASS']))
                {
                        $link .= ' class="' . $this->attributes['CAPTION_CLASS'] . '"';
                }
                $link .= ' onclick="javascript:STJSRadioButtonWithCaption_click(' . $ctlName . ',' . $this->index . ')">';
                $link .= $this->attributes['CAPTION'];
                $link .= '</A>';
                $this->setAttribute('CAPTION', $link);

                STPHPControlWithCaption::prepareWrite();
                $this->ctlCell->addComponent($this->radiobutton);
        }

        function dtor()
        {
                $this->radiobutton->dtor();
                unset($this->radiobutton);
        }

        function setIndex($index)
        {
                $this->index = $index;
        }

        var $radiobutton;
        var $index;
}

?>
