<?php

require_once("$STPHPLIB_DIR/stphpcontrolwithcaption.php");
require_once("$STPHPLIB_DIR/stphplistbox.php");

class STPHPListBoxWithCaption extends STPHPControlWithCaption
{

        function STPHPListBoxWithCaption($name)
        {
                STPHPControlWithCaption::STPHPControlWithCaption($name);
                $this->list = new STPHPListBox('lst_' . $name);
        }

        function prepareWrite()
        {
                $this->attrsToIgnore['SIZE']=1;
                $this->list->setAttribute('SIZE', $this->attributes['SIZE']);

                STPHPControlWithCaption::prepareWrite();
                $this->ctlCell->addComponent($this->list);
        }

        function dtor()
        {
                $this->list->dtor();
                unset($this->list);
        }

        function setConfiguration($configuration)
        {
                STPHPControlWithCaption::setConfiguration($configuration);
                $items = $this->configuration->getChildByName('items');
                $numOfItems = $items->getNumOfChilds();

                for($i=1; $i<=$numOfItems; $i++)
                {
                        $item = $items->getChildByNameNum('item', $i);
                        $this->list->addElement($item->data, $item->attributes['CAPTION']);
                }
        }
}

?>
