<?php

require_once("$STPHPLIB_DIR/stphpcomponent.php");

class STPHPListbox extends STPHPComponent
{
        function STPHPListbox($name)
        {
                STPHPComponent::STPHPComponent($name);
                $this->openTag="<SELECT NAME=\"$name\">";
                $this->closeTag="</SELECT>";
        }

        function dtor()
        {
                unset($this->elements);
                STPHPComponent::dtor();
        }

        function write()
        {
                $retValue  = "";
                $retValue .= $this->openWrite();

                $numOfElements=sizeof($this->elements);
                for($i=0; $i<$numOfElements; $i++)
                {
                        $key=$this->elements[$i][0];
                        $value=$this->elements[$i][1];
                        $selected=$this->elements[$i][2];
                        if($selected)
                        {
                                $str_selected="SELECTED";
                        }
                        else
                        {
                                $str_selected="";
                        }

                        $retValue .= "<OPTION VALUE=\"$key\" $str_selected>$value";
                }

                $retValue .= $this->closeWrite();
                return $retValue;
        }

        function addElement($key, $value, $selected=FALSE)
        {
                $i=sizeof($this->elements);
                $this->elements[$i][0]=$key;
                $this->elements[$i][1]=$value;
                $this->elements[$i][2]=$selected;
        }

        function loadFromDb(&$db, $key_col, $val_col, $sql)
        {
                $recordSet =& $db->Execute($sql);
                if($recordSet)
                {
                        while(!$recordSet->EOF)
                        {
                                $key = $recordSet->fields[$key_col];
                                $val = $recordSet->fields[$val_col];
                                $this->addElement($key, $val);
                                $recordSet->MoveNext();
                        }
                        $recordSet->Close();
                }
        }

        function selectElementByKey($key)
        {
                $numOfElements = sizeof($this->elements);
                for($i=0; $i<$numOfElements; $i++)
                {
                        $this->elements[$i][2]=FALSE;
                        if($this->elements[$i][0]==$key)
                        {
                                $this->elements[$i][2]=TRUE;
                        }
                }
        }

        function selectElementByValue($value)
        {
                $numOfElements = sizeof($this->elements);
                for($i=0; $i<$numOfElements; $i++)
                {
                        $this->elements[$i][2]=FALSE;
                        if($this->elements[$i][1]==$value)
                        {
                                $this->elements[$i][2]=TRUE;
                        }
                }
        }

        function clearElements()
        {
                unset($this->elements);
        }

        var $elements;
}

?>
