<?php

require_once("$STPHPLIB_DIR/stphpcomponent.php");

class STPHPLabel extends STPHPComponent
{
        function STPHPLabel($name)
        {
                STPHPComponent::STPHPComponent($name);
                $this->openTag="<SPAN>";
                $this->closeTag="</SPAN>";
        }

        function openWrite()
        {
                $this->attrsToIgnore["TEXT"]=1;
                $this->attrsToIgnore["ALIGN"]=1;
                $this->attrsToIgnore["LINK"]=1;
                $this->attrsToIgnore["LINK_TARGET"]=1;
                
                $retValue = STPHPComponent::openWrite();

                if(!empty($this->attributes['ALIGN']))
                {
                        $retValue .= "<DIV ALIGN=\"" . $this->attributes["ALIGN"] . "\">";
                }

                if(!empty($this->attributes['LINK']))
                {

                        $link=$this->attributes["LINK"];

                        if(!empty($this->attributes['CLASS']))
                        {
                                $link_class = "CLASS=\"" . $this->attributes['CLASS'] . "\"";
                        }
                        $retValue .= "<A HREF=\"" . $link . "\" " . $link_class . " ";
                        if(!empty($this->attributes['LINK_TARGET']))
                        {
                                $retValue .= "TARGET=" . $this->attributes['LINK_TARGET'];
                        }
                        $retValue .= ">";
                }

                $retValue .= $this->attributes['TEXT'];
                return $retValue;
        }

        function closeWrite()
        {
                $retValue = "";
                $retValue .= STPHPComponent::closeWrite();

                if(!empty($this->attributes['LINK']))
                {
                        $retValue .= "</A>";
                }

                if(!empty($this->attributes['ALIGN']))
                {
                        $retValue .= "</DIV>";
                }
                return $retValue;
        }
}

?>
