<?php

require_once("$STPHPLIB_DIR/stphpcomponent.php");

class STPHPImage extends STPHPComponent
{
        function STPHPImage($name)
        {
                STPHPComponent::STPHPComponent($name);
                $this->openTag="<img name=\"$name\"";
                $this->closeTag=">";
        }

        function openWrite()
        {
                if(empty($this->attributes['ALT']))
                {
                     $this->attributes['ALT']=$this->name;
                }

                $this->attrsToIgnore["LINK"]=1;
                $this->attrsToIgnore["LINK_TARGET"]=1;

                if(!empty($this->attributes['LINK']))
                {
                        $this->attrsToIgnore["LINK"]=1;
                        $link=$this->attributes["LINK"];

                        $retValue .= "<a href=\"" . $link . "\" ";
                        if(!empty($this->attributes['LINK_TARGET']))
                        {
                                $retValue .= "target=" . $this->attributes['LINK_TARGET'];
                        }
                        $retValue .= ">";
                }

                $retValue .= STPHPComponent::openWrite();
                return $retValue;
        }

        function closeWrite()
        {
                $retValue = "";
                $retValue .= STPHPComponent::closeWrite();

                if(!empty($this->attributes['LINK']))
                {
                        $retValue .= "</a>";
                }

                return $retValue;
        }

        function loadFromDb($db_conf, $table, $record_id, $imgField, $imgTypeField, $imgDesc)
        {
                global $STPHPLIBBASE_PATH;
                $this->attributes['SRC']="$STPHPLIBBASE_PATH/utils/stphpimage_show.php?db_conf=$db_conf&table=$table&record_id=$record_id&imgField=$imgField&imgTypeField=$imgTypeField";
                $this->attributes['ALT']=$imgDesc;
        }
}

?>
