<?php

require_once("$STPHPLIB_DIR/stphptable.php");

class STPHPControlWithCaption extends STPHPTable
{

        function STPHPControlWithCaption($name)
        {
                STPHPTable::STPHPTable($name);
                $this->caption = '';
        }

        function dtor()
        {
                STPHPTable::dtor();
                unset($this->captionCell);
                unset($this->ctlCell);
        }

        function prepareWrite()
        {
                $this->attrsToIgnore['CAPTION']=1;
                $this->attrsToIgnore['CAPTION_ALIGN']=1;
                $this->attrsToIgnore['CAPTION_CLASS']=1;
                $this->attrsToIgnore['CONTROL_CLASS']=1;

                switch(strtoupper($this->attributes['CAPTION_ALIGN']))
                {
                        case 'TOP':
                                $this->setNumOfRows(2);
                                $this->setNumOfCols(1);
                                $this->prepare();
                                $this->captionCell =& $this->cells[1][1];
                                $this->ctlCell =& $this->cells[2][1];
                        break;
                        case 'BOTTOM':
                                $this->setNumOfRows(2);
                                $this->setNumOfCols(1);
                                $this->prepare();
                                $this->captionCell =& $this->cells[2][1];
                                $this->ctlCell =& $this->cells[1][1];
                        break;
                        case 'LEFT':
                                $this->setNumOfRows(1);
                                $this->setNumOfCols(2);
                                $this->prepare();
                                $this->captionCell =& $this->cells[1][1];
                                $this->ctlCell =& $this->cells[1][2];
                        break;
                        case 'RIGHT':
                                $this->setNumOfRows(1);
                                $this->setNumOfCols(2);
                                $this->prepare();
                                $this->captionCell =& $this->cells[1][2];
                                $this->ctlCell =& $this->cells[1][1];
                        break;
                        default :
                                $this->setNumOfRows(1);
                                $this->setNumOfCols(2);
                                $this->prepare();
                                $this->captionCell =& $this->cells[1][1];
                                $this->ctlCell =& $this->cells[1][2];
                        break;
                }
                $this->captionCell->text = $this->attributes['CAPTION'];
                $this->captionCell->setAttribute('CLASS', $this->attributes['CAPTION_CLASS']);
                $this->ctlCell->setAttribute('CLASS', $this->attributes['CONTROL_CLASS']);
        }

        function write()
        {
                $this->prepareWrite();
                $retValue  = "";
                $retValue .= STPHPTable::write();

                return $retValue;
        }

        var $captionCell;
        var $ctlCell;
}

?>
