<?php

require_once("$STPHPLIB_DIR/stphpobject.php");
require_once("$STPHPLIB_DIR/stphpspacer.php");

class STPHPComponent extends STPHPObject
{

        function STPHPComponent($name)
        {
                STPHPObject::STPHPObject($name);
                $this->openTag='<';
                $this->closeTag='>';
                $this->attributes=array();
                $this->components=array();
                $this->attrsToIgnore=array();
                $this->text = '';
                $this->attributes['VISIBLE']='TRUE';
        }

        function dtor()
        {
                unset($this->attributes);
                unset($this->openTag);
                unset($this->closeTag);
                unset($this->components);
                STPHPObject::dtor();
        }

        function insertComponent(&$component)
        {

                array_unshift($this->components, "0");
                $this->components[0] =& $component;
        }

        function addComponent(&$component)
        {
                $this->appendComponent($component);
        }

        function appendComponent(&$component)
        {
                $this->components[] =& $component;
        }

        function addVSpace($units)
        {
                $theSpacer = new STPHPSpacer("VSpace");
                $theSpacer->setSpaceType("VER");
                $theSpacer->setUnits($units);
                $this->addComponent($theSpacer);
        }

        function addCodeFile($file)
        {
                global $Wnd;
                $Wnd->addCodeFile($file);
        }

        function addCssFile($file)
        {
                global $Wnd;
                $Wnd->addCssFile($file);
        }

        function setAttribute($key, $val)
        {
                $key = strtoupper($key);
                if(($key == 'CLASS') && (empty($val)))
                {
                        return;
                }
                $this->attributes[$key]=$val;
        }

        function appendAttributes($attributes)
        {
                 $this->attributes = array_merge($this->attributes, $attributes);
        }

        function setFormParent($form)
        {
                $this->formParent = $form;
        }

        function getFormParent()
        {
                return $this->formParent;
        }

        function openWrite()
        {
                $this->attrsToIgnore['VISIBLE']=1;
                $retValue  = '';
                $htmlAttr = '';

                if(isset($this->attributes))
                {
                        while(list($key, $value) = each($this->attributes))
                        {
                                if(!empty($this->attrsToIgnore[$key]))
                                {
                                        continue;
                                }

                                if(($key=='READONLY') && ($value==TRUE))
                                {
                                        $htmlAttr .= " $key";
                                        continue;
                                }

                                if(($key=='CHECKED') && ($value==TRUE))
                                {
                                        $htmlAttr .= " $key";
                                        continue;
                                }

                                if(!empty($this->attrsToIgnore[$key]))
                                {
                                        continue;
                                }

                                if(!empty($value))
                                {
                                        $htmlAttr .= ' ' . $key . '="' . $value . '"';
                                }
                                else if(($value==0) && ($key!='VALUE'))
                                {
                                        $htmlAttr .= ' ' . $key . '="0"';
                                }
                        }
                }

                $pos=strpos($this->openTag, ">");
                if($pos>0)
                {
                        $retValue .= str_replace(">" , $htmlAttr . ">", $this->openTag);
                }
                else
                {
                        $retValue .=$this->openTag . $htmlAttr;
                }

                return $retValue;
        }

        function write()
        {
                $retValue = "";
                $retValue .= $this->openWrite();

                while (list ($key, $val) = each ($this->components))
                {
                        if(strtoupper($val->attributes['VISIBLE'])=='TRUE')
                        {
                                $retValue .= $val->Write();
                        }
                }
                $retValue .= $this->text;

                $retValue .= $this->closeWrite();
                return $retValue;
        }

        function closeWrite()
        {
                $retValue .= $this->closeTag;
                return $retValue;
        }

        function setVisible($visible)
        {
                $this->visible = $visible;
        }

        function setConfiguration(&$configuration)
        {
                $this->configuration =& $configuration;
                $this->attributes = array_merge($this->attributes, $configuration->attributes);

                $attributes=$this->configuration->getChildByName('attributes');
                $numOfAttributes = $attributes->getNumOfChilds();

                for($i=1; $i<=$numOfAttributes; $i++)
                {
                        $attribute = $attributes->getChildByNum($i);
                        $this->setAttribute($attribute->name, $attribute->data);
                }
        }

        var $openTag;
        var $closeTag;
        var $attributes;
        var $components;
        var $formParent;
        var $attrsToIgnore;
        var $text;
        var $configuration;
}
?>
