<?php

require_once("$STPHPLIB_DIR/stphpcheckboxwithcaption.php");

class STPHPCheckGroup extends STPHPControlWithCaption
{
        function STPHPCheckGroup($name)
        {
                STPHPControlWithCaption::STPHPControlWithCaption($name);
        }

        function setNumOfOptions($options)
        {
                $this->numOfOptions = $options;
        }

        function prepareCtrls()
        {
                $this->tblControls = new STPHPTable('tbl_ctrls_' . $this->name);
                $this->tblControls->setNumOfRows($this->numOfOptions);
                $this->tblControls->setNumOfCols(1);
                $this->tblControls->prepare();
                for($i=1; $i<=$this->numOfOptions; $i++)
                {
                       $this->check[$i] = new STPHPCheckBoxWithCaption($i . '_' . $this->name);
                       $this->check[$i]->setFormParent($this->getFormParent()) ;
                       $this->tblControls->cells[$i][1]->setAttribute('ALIGN', 'CENTER');
                       $this->tblControls->cells[$i][1]->addComponent($this->check[$i]);
                }
        }

        function prepareWrite()
        {
                STPHPControlWithCaption::prepareWrite();
                $this->ctlCell->addComponent($this->tblControls);
        }

        function setConfiguration($configuration)
        {
                STPHPControlWithCaption::setConfiguration($configuration);
                $items = $this->configuration->getChildByName('items');
                $this->numOfOptions = $items->getNumOfChilds();
                $this->prepareCtrls();

                for($i=1; $i<=$this->numOfOptions; $i++)
                {
                        $item = $items->getChildByNameNum('item', $i);
                        $this->check[$i]->appendAttributes($items->attributes);
                        $this->check[$i]->setAttribute('CAPTION', $item->attributes['CAPTION']);
                        $this->check[$i]->setAttribute('VALUE', $item->data);
                }
        }

        var $numOfOptions;
}

?>
